/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.db.mysql;

import br.com.objectos.db.core.DatabaseConfig;
import br.com.objectos.db.core.Vendor;
import com.zaxxer.hikari.HikariConfig;

final class MysqlVendor
extends Vendor {
    private static final MysqlVendor INSTANCE = new MysqlVendor();

    private MysqlVendor() {
    }

    public static MysqlVendor get() {
        return INSTANCE;
    }

    protected String catalogName(String dbName) {
        return dbName;
    }

    protected void configure(DatabaseConfig config, HikariConfig hk) {
        hk.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        hk.addDataSourceProperty("url", (Object)this.url(config));
        hk.addDataSourceProperty("user", (Object)config.user());
        hk.addDataSourceProperty("password", (Object)config.password());
        hk.setInitializationFailFast(false);
        hk.setMinimumIdle(0);
        hk.setMaximumPoolSize(50);
        hk.addDataSourceProperty("cachePrepStmts", (Object)true);
        hk.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        hk.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        hk.addDataSourceProperty("rewriteBatchedStatements", (Object)true);
        hk.addDataSourceProperty("useServerPrepStmts", (Object)true);
    }

    protected String driverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    protected String urlFormat() {
        return "jdbc:mysql://%s:%d";
    }

    private String url(DatabaseConfig config) {
        String server = config.server();
        int port = config.port();
        String db = config.db();
        return String.format("jdbc:mysql://%s:%d/%s", server, port, db);
    }
}

