/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.db.mysql;

import br.com.objectos.db.mysql.MysqlInsertBuilder;
import br.com.objectos.db.mysql.MysqlSchemaBuilder;
import br.com.objectos.db.mysql.MysqlSelectBuilder;
import br.com.objectos.db.mysql.MysqlUpdateBuilder;
import br.com.objectos.db.query.AbstractSqlBuilder;
import br.com.objectos.db.query.InsertBuilder;
import br.com.objectos.db.query.Name;
import br.com.objectos.db.query.SchemaBuilder;
import br.com.objectos.db.query.SelectBuilder;
import br.com.objectos.db.query.Space;
import br.com.objectos.db.query.SqlBuilder;
import br.com.objectos.db.query.UpdateBuilder;

class MysqlSqlBuilder
extends AbstractSqlBuilder {
    private MysqlSqlBuilder(Name name, Space space, StringBuilder sql) {
        super(name, space, sql);
    }

    public static MysqlSqlBuilder get() {
        return new Start();
    }

    public InsertBuilder toInsertBuilder() {
        return new MysqlInsertBuilder((SqlBuilder)this);
    }

    public SchemaBuilder toSchemaBuilder() {
        return new MysqlSchemaBuilder((SqlBuilder)this);
    }

    public SelectBuilder toSelectBuilder() {
        return new MysqlSelectBuilder((SqlBuilder)this);
    }

    public UpdateBuilder toUpdateBuilder() {
        return new MysqlUpdateBuilder((SqlBuilder)this);
    }

    protected SqlBuilder factory(Name name, Space space, StringBuilder sql) {
        return new MysqlSqlBuilder(name, space, sql);
    }

    protected String quote(String text) {
        return "`" + text + "`";
    }

    private static class Start
    extends MysqlSqlBuilder {
        public Start() {
            super(Name.QUALIFIED, Space.OFF, new StringBuilder());
        }

        protected SqlBuilder self() {
            return this.autoSpaceOn();
        }
    }
}

