/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.aws.util.CredentialsUtil;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.swap.SwapCNamesCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.swap.SwapCNamesContextBuilder;
import br.com.ingenieux.mojo.beanstalk.cmd.env.terminate.TerminateEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.terminate.TerminateEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.terminate.TerminateEnvironmentContextBuilder;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.waitfor.WaitForEnvironmentContextBuilder;
import br.com.ingenieux.mojo.beanstalk.env.CreateEnvironmentMojo;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="replace-environment")
public class ReplaceEnvironmentMojo
extends CreateEnvironmentMojo {
    private static final Pattern PATTERN_NUMBERED = Pattern.compile("^(.*)-(\\d+)$");
    private static final int MAX_ENVNAME_LEN = 23;
    @Parameter(property="beanstalk.timeoutMins", defaultValue="20")
    Integer timeoutMins;
    @Parameter(property="beanstalk.skipIfSameVersion", defaultValue="true")
    boolean skipIfSameVersion = true;
    @Parameter(property="beanstalk.maxAttempts", defaultValue="15")
    Integer maxAttempts = 15;
    @Parameter(property="beanstalk.mockTerminateEnvironment", defaultValue="false")
    boolean mockTerminateEnvironment = false;
    @Parameter(property="beanstalk.attemptRetryInterval", defaultValue="60")
    int attemptRetryInterval = 60;

    @Override
    protected EnvironmentDescription handleResults(List<EnvironmentDescription> environments) throws MojoExecutionException {
        return null;
    }

    @Override
    protected Object executeInternal() throws AbstractMojoExecutionException {
        if (!this.hasEnvironmentFor(this.applicationName, this.cnamePrefix)) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Just launching a new environment.");
            }
            return super.executeInternal();
        }
        EnvironmentDescription curEnv = this.getEnvironmentFor(this.applicationName, this.cnamePrefix);
        if (curEnv.getVersionLabel().equals(this.versionLabel) && this.skipIfSameVersion) {
            this.getLog().warn((CharSequence)String.format("Environment is running version %s and skipIfSameVersion is true. Returning", this.versionLabel));
            return null;
        }
        String cnamePrefixToCreate = this.getCNamePrefixToCreate();
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Creating a new environment on " + cnamePrefixToCreate + ".elasticbeanstalk.com"));
        }
        this.copyOptionSettings(curEnv);
        if (!this.solutionStack.equals(curEnv.getSolutionStackName())) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().warn((CharSequence)String.format("(btw, we're launching with solutionStack/ set to '%s' instead of the default ('%s'). If this is not the case, then we kindly ask you to file a bug report on the mailing list :)", curEnv.getSolutionStackName(), this.solutionStack));
            }
            this.solutionStack = curEnv.getSolutionStackName();
        }
        String newEnvironmentName = this.getNewEnvironmentName(this.environmentName);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("And it'll be named " + newEnvironmentName));
        }
        CreateEnvironmentResult createEnvResult = this.createEnvironment(cnamePrefixToCreate, newEnvironmentName);
        EnvironmentDescription newEnvDesc = null;
        try {
            newEnvDesc = this.waitForEnvironment(createEnvResult.getEnvironmentId());
        }
        catch (Exception exc) {
            this.terminateEnvironment(createEnvResult.getEnvironmentId());
            this.handleException(exc);
            return null;
        }
        boolean swapped = false;
        for (int i = 1; i <= this.maxAttempts; ++i) {
            try {
                this.swapEnvironmentCNames(newEnvDesc.getEnvironmentId(), curEnv.getEnvironmentId(), this.cnamePrefix);
                swapped = true;
                break;
            }
            catch (Throwable exc) {
                if (exc instanceof MojoFailureException) {
                    exc = (Throwable)Throwable.class.cast(((MojoFailureException)MojoFailureException.class.cast(exc)).getCause());
                }
                this.getLog().warn((CharSequence)String.format("Attempt #%d/%d failed. Sleeping and retrying. Reason: %s", i, this.maxAttempts, exc.getMessage()));
                this.sleepInterval(this.attemptRetryInterval);
                continue;
            }
        }
        if (!swapped) {
            this.getLog().info((CharSequence)"Failed to properly Replace Environment. Finishing the new one. And throwing you a failure");
            this.terminateEnvironment(newEnvDesc.getEnvironmentId());
            String message = "Unable to swap cnames. btw, see https://github.com/ingenieux/beanstalker/issues/25 and help us improve beanstalker";
            this.getLog().warn((CharSequence)message);
            throw new MojoFailureException(message);
        }
        this.terminateEnvironment(curEnv.getEnvironmentId());
        return createEnvResult;
    }

    public void sleepInterval(int pollInterval) {
        this.getLog().info((CharSequence)String.format("Sleeping for %d seconds (and until %s)", pollInterval, new Date(System.currentTimeMillis() + (long)(1000 * pollInterval))));
        try {
            Thread.sleep(1000 * pollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void copyOptionSettings(EnvironmentDescription curEnv) {
        if (null != this.optionSettings && this.optionSettings.length > 0) {
            return;
        }
        DescribeConfigurationSettingsResult configSettings = ((AWSElasticBeanstalkClient)this.getService()).describeConfigurationSettings(new DescribeConfigurationSettingsRequest().withApplicationName(this.applicationName).withEnvironmentName(curEnv.getEnvironmentName()));
        ArrayList newOptionSettings = new ArrayList(((ConfigurationSettingsDescription)configSettings.getConfigurationSettings().get(0)).getOptionSettings());
        ListIterator listIterator = newOptionSettings.listIterator();
        while (listIterator.hasNext()) {
            ConfigurationOptionSetting curOptionSetting = (ConfigurationOptionSetting)listIterator.next();
            boolean bInvalid = this.harmfulOptionSettingP(curEnv.getEnvironmentId(), curOptionSetting);
            if (bInvalid) {
                this.getLog().info((CharSequence)String.format("Excluding Option Setting: %s:%s['%s']", curOptionSetting.getNamespace(), curOptionSetting.getOptionName(), CredentialsUtil.redact((String)curOptionSetting.getValue())));
                listIterator.remove();
                continue;
            }
            this.getLog().info((CharSequence)String.format("Including Option Setting: %s:%s['%s']", curOptionSetting.getNamespace(), curOptionSetting.getOptionName(), CredentialsUtil.redact((String)curOptionSetting.getValue())));
        }
        this.optionSettings = newOptionSettings.toArray(new ConfigurationOptionSetting[newOptionSettings.size()]);
    }

    protected void swapEnvironmentCNames(String newEnvironmentId, String curEnvironmentId, String cnamePrefix) throws AbstractMojoExecutionException {
        this.getLog().info((CharSequence)("Swapping environment cnames " + newEnvironmentId + " and " + curEnvironmentId));
        Object context = ((SwapCNamesContextBuilder)((SwapCNamesContextBuilder)SwapCNamesContextBuilder.swapCNamesContext().withSourceEnvironmentId(newEnvironmentId)).withDestinationEnvironmentId(curEnvironmentId)).build();
        BaseCommand command = new SwapCNamesCommand(this);
        command.execute(context);
        context = ((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withApplicationName(this.applicationName)).withStatusToWaitFor("Ready")).withEnvironmentId(newEnvironmentId)).withTimeoutMins(this.timeoutMins)).withDomainToWaitFor(cnamePrefix)).build();
        command = new WaitForEnvironmentCommand(this);
        command.execute(context);
    }

    protected void terminateEnvironment(String environmentId) throws AbstractMojoExecutionException {
        if (this.mockTerminateEnvironment) {
            this.getLog().info((CharSequence)String.format("We're ignoring the termination of environment id '%s' (see mockTerminateEnvironment)", environmentId));
            return;
        }
        Exception lastException = null;
        for (int i = 1; i <= this.maxAttempts; ++i) {
            this.getLog().info((CharSequence)String.format("Terminating environmentId=%s (attempt %d/%d)", environmentId, i, this.maxAttempts));
            try {
                TerminateEnvironmentContext terminatecontext = ((TerminateEnvironmentContextBuilder)((TerminateEnvironmentContextBuilder)new TerminateEnvironmentContextBuilder().withEnvironmentId(environmentId)).withTerminateResources(true)).build();
                TerminateEnvironmentCommand command = new TerminateEnvironmentCommand(this);
                command.execute(terminatecontext);
                return;
            }
            catch (Exception exc) {
                lastException = exc;
                continue;
            }
        }
        throw new MojoFailureException("Unable to terminate environment " + environmentId, lastException);
    }

    protected EnvironmentDescription waitForEnvironment(String environmentId) throws AbstractMojoExecutionException {
        this.getLog().info((CharSequence)("Waiting for environmentId " + environmentId + " to get into Ready state"));
        WaitForEnvironmentContext context = ((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)((WaitForEnvironmentContextBuilder)new WaitForEnvironmentContextBuilder().withApplicationName(this.applicationName)).withStatusToWaitFor("Ready")).withEnvironmentId(environmentId)).withTimeoutMins(this.timeoutMins)).build();
        WaitForEnvironmentCommand command = new WaitForEnvironmentCommand(this);
        return (EnvironmentDescription)command.execute(context);
    }

    protected String getCNamePrefixToCreate() {
        String cnamePrefixToReturn = this.cnamePrefix;
        int i = 0;
        while (this.hasEnvironmentFor(this.applicationName, cnamePrefixToReturn)) {
            cnamePrefixToReturn = String.format("%s-%d", this.cnamePrefix, i++);
        }
        return cnamePrefixToReturn;
    }

    protected boolean hasEnvironmentFor(String applicationName, String cnamePrefix) {
        return null != this.getEnvironmentFor(applicationName, cnamePrefix);
    }

    protected EnvironmentDescription getEnvironmentFor(String applicationName, String cnamePrefix) {
        Collection<EnvironmentDescription> environments = this.getEnvironmentsFor(applicationName);
        String cnameToMatch = String.format("%s.elasticbeanstalk.com", cnamePrefix);
        for (EnvironmentDescription envDesc : environments) {
            if (!envDesc.getCNAME().equals(cnameToMatch)) continue;
            return envDesc;
        }
        return null;
    }

    private String getNewEnvironmentName(String newEnvironmentName) {
        String result;
        String environmentRadical = result = newEnvironmentName;
        int i = 0;
        Matcher matcher = PATTERN_NUMBERED.matcher(newEnvironmentName);
        if (matcher.matches()) {
            environmentRadical = matcher.group(1);
            i = 1 + Integer.valueOf(matcher.group(2));
        }
        while (this.containsNamedEnvironment(result)) {
            result = this.formatAndTruncate("%s-%d", 23, environmentRadical, i++);
        }
        return result;
    }

    protected String formatAndTruncate(String mask, int maxLen, Object ... args) {
        String result = String.format(mask, args);
        if (result.length() > maxLen) {
            result = result.substring(result.length() - maxLen, result.length());
        }
        return result;
    }

    protected boolean containsNamedEnvironment(String environmentName) {
        for (EnvironmentDescription envDesc : this.getEnvironmentsFor(this.applicationName)) {
            if (!envDesc.getEnvironmentName().equals(environmentName)) continue;
            return true;
        }
        return false;
    }
}

