/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.env;

import br.com.ingenieux.mojo.beanstalk.AbstractNeedsEnvironmentMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentContext;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentContextBuilder;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-environment")
public class CreateEnvironmentMojo
extends AbstractNeedsEnvironmentMojo {
    @Parameter(property="beanstalk.applicationDescription", defaultValue="${project.name}")
    String applicationDescription;
    @Parameter
    ConfigurationOptionSetting[] optionSettings;
    @Parameter(property="beanstalk.versionLabel", defaultValue="${project.version}", required=true)
    String versionLabel;
    @Parameter(property="beanstalk.solutionStack", defaultValue="32bit Amazon Linux running Tomcat 7")
    String solutionStack;
    @Parameter(property="beanstalk.templateName")
    String templateName;

    @Override
    protected void configure() {
    }

    protected Object executeInternal() throws AbstractMojoExecutionException {
        CreateEnvironmentResult result = this.createEnvironment(this.cnamePrefix, this.environmentName);
        return result;
    }

    protected CreateEnvironmentResult createEnvironment(String cnameToCreate, String newEnvironmentName) throws AbstractMojoExecutionException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)newEnvironmentName), (String)"No New Environment Name Supplied");
        CreateEnvironmentContextBuilder builder = (CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)((CreateEnvironmentContextBuilder)CreateEnvironmentContextBuilder.createEnvironmentContext().withApplicationName(this.applicationName)).withApplicationDescription(this.applicationDescription)).withCnamePrefix(cnameToCreate)).withSolutionStack(this.solutionStack)).withTemplateName(this.templateName)).withEnvironmentName(newEnvironmentName)).withOptionSettings(this.optionSettings)).withVersionLabel(this.versionLabel);
        CreateEnvironmentContext context = builder.build();
        CreateEnvironmentCommand command = new CreateEnvironmentCommand(this);
        return (CreateEnvironmentResult)command.execute(context);
    }
}

