/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk.cmd.env.create;

import br.com.ingenieux.mojo.aws.util.CredentialsUtil;
import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import br.com.ingenieux.mojo.beanstalk.cmd.BaseCommand;
import br.com.ingenieux.mojo.beanstalk.cmd.env.create.CreateEnvironmentContext;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojoExecutionException;

public class CreateEnvironmentCommand
extends BaseCommand<CreateEnvironmentContext, CreateEnvironmentResult> {
    public CreateEnvironmentCommand(AbstractBeanstalkMojo parentMojo) throws AbstractMojoExecutionException {
        super(parentMojo);
    }

    @Override
    protected CreateEnvironmentResult executeInternal(CreateEnvironmentContext context) throws Exception {
        CreateEnvironmentRequest request = new CreateEnvironmentRequest();
        request.setApplicationName(context.getApplicationName());
        request.setCNAMEPrefix(context.getCnamePrefix());
        request.setDescription(context.getApplicationDescription());
        request.setEnvironmentName(context.getEnvironmentName());
        request.setOptionSettings(Arrays.asList(context.getOptionSettings()));
        if (StringUtils.isNotBlank((String)context.getTemplateName())) {
            request.setTemplateName(this.parentMojo.lookupTemplateName(context.getApplicationName(), context.getTemplateName()));
        } else if (StringUtils.isNotBlank((String)context.getSolutionStack())) {
            request.setSolutionStackName(context.getSolutionStack());
        }
        request.setVersionLabel(context.getVersionLabel());
        if (this.parentMojo.isVerbose()) {
            this.parentMojo.getLog().info((CharSequence)("Requesting createEnvironment w/ request: " + CredentialsUtil.redact((String)("" + request))));
        }
        return this.service.createEnvironment(request);
    }
}

