/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.beanstalk;

import br.com.ingenieux.mojo.beanstalk.AbstractBeanstalkMojo;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractNeedsEnvironmentMojo
extends AbstractBeanstalkMojo {
    @Parameter(property="beanstalk.applicationName", defaultValue="${project.artifactId}", required=true)
    protected String applicationName;
    @Parameter(property="beanstalk.environmentName", defaultValue="${project.artifactId}-env")
    protected String environmentName;
    @Parameter(property="beanstalk.cnamePrefix", defaultValue="${project.artifactId}")
    protected String cnamePrefix;
    protected EnvironmentDescription curEnv;

    protected void configure() {
        try {
            this.curEnv = super.lookupEnvironment(this.applicationName, this.cnamePrefix, this.environmentName);
        }
        catch (MojoExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected EnvironmentDescription getEnvironmentForCNamePrefix(String applicationName, String cnamePrefix) {
        for (EnvironmentDescription env : this.getEnvironmentsFor(applicationName)) {
            String cnameToMatch = cnamePrefix + ".elasticbeanstalk.com";
            if (!env.getCNAME().equalsIgnoreCase(cnameToMatch)) continue;
            return env;
        }
        return null;
    }

    protected Collection<EnvironmentDescription> getEnvironmentsFor(String applicationName) {
        DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(applicationName).withIncludeDeleted(Boolean.valueOf(false));
        return ((AWSElasticBeanstalkClient)this.getService()).describeEnvironments(req).getEnvironments();
    }
}

