/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.RuntimeContainerProperties;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;

public abstract class AbstractNioSender<T extends AbstractSelectableChannel>
implements ErrorReporter {
    public static final String PROPERTY_BUFFER_SIZE = "logstash-gelf.buffer.size";
    public static final int INITIAL_BUFFER_SIZE = Integer.parseInt(RuntimeContainerProperties.getProperty("logstash-gelf.buffer.size", "327680"));
    private T channel;
    private volatile boolean shutdown = false;
    private final ErrorReporter errorReporter;
    private final String host;
    private final int port;
    private final ThreadLocal<ByteBuffer> readBuffers = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return ByteBuffer.allocate(1);
        }
    };

    protected AbstractNioSender(ErrorReporter errorReporter, String host, int port) throws UnknownHostException {
        InetAddress.getByName(host);
        this.errorReporter = errorReporter;
        this.host = host;
        this.port = port;
    }

    protected boolean isConnected() throws IOException {
        ByteBuffer byteBuffer = this.readBuffers.get();
        byteBuffer.clear();
        T myChannel = this.channel();
        if (myChannel != null && ((AbstractInterruptibleChannel)myChannel).isOpen() && this.isConnected(myChannel)) {
            try {
                return ((ReadableByteChannel)myChannel).read(byteBuffer) >= 0;
            }
            catch (PortUnreachableException e) {
                this.errorReporter.reportError("Port " + this.getHost() + ":" + this.getPort() + " not reachable", e);
            }
            catch (IOException e) {
                this.errorReporter.reportError("Cannot verify whether channel to " + this.getHost() + ":" + this.getPort() + " is connected: " + e.getMessage(), e);
            }
        }
        return false;
    }

    protected abstract boolean isConnected(T var1);

    protected T channel() {
        return this.channel;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void close() {
        this.shutdown = true;
        Closer.close(this.channel());
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public void reportError(String message, Exception e) {
        this.errorReporter.reportError(message, e);
    }

    public void setChannel(T channel) {
        this.channel = channel;
    }
}

