/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import biz.netcentric.cq.tools.actool.aem.AcToolCqActions;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validators {
    private static final Logger LOG = LoggerFactory.getLogger(Validators.class);

    public static boolean isValidNodePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return true;
        }
        return path.startsWith("/");
    }

    public static boolean isValidAuthorizableId(String id) {
        return !StringUtils.isBlank((CharSequence)id);
    }

    public static boolean isValidRegex(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return true;
        }
        boolean isValid = true;
        if (expression.startsWith("*")) {
            expression = expression.replaceFirst("\\*", "\\\\*");
        }
        try {
            Pattern.compile(expression);
        }
        catch (PatternSyntaxException e) {
            LOG.error("PatternSyntaxException while validating rep glob: {} ", (Object)expression);
            isValid = false;
        }
        return isValid;
    }

    public static boolean isValidAction(String action) {
        List validActions = Stream.of(AcToolCqActions.CqActions.values()).map(Enum::name).collect(Collectors.toList());
        if (action == null) {
            return false;
        }
        return validActions.contains(action);
    }

    public static boolean isValidJcrPrivilege(String privilege, AccessControlManager aclManager) {
        if (privilege == null) {
            return false;
        }
        try {
            aclManager.privilegeFromName(privilege);
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidPermission(String permission) {
        if (permission == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)"allow", (CharSequence)permission) || StringUtils.equals((CharSequence)"deny", (CharSequence)permission);
    }
}

