/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.slingsettings;

import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import biz.netcentric.cq.tools.actool.slingsettings.ExtendedSlingSettingsService;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ExtendedSlingSettingsService.class})
@Designate(ocd=Config.class)
public class ExtendedSlingSettingsServiceImpl
implements ExtendedSlingSettingsService {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedSlingSettingsServiceImpl.class);
    private static final String ADDITIONAL_RUNMODE_CLOUD = "cloud";
    private static final String RUN_MODE_SPEC_OR_SEPARATOR = ",";
    private static final String RUN_MODE_SPEC_AND_SEPARATOR = ".";
    private static final String RUN_MODE_SPEC_NOT_PREFIX = "-";
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingSettingsService slingSettingsService;
    private Set<String> extendedRunmodes;

    public ExtendedSlingSettingsServiceImpl() {
    }

    public ExtendedSlingSettingsServiceImpl(Set<String> extendedRunmodes) {
        this.extendedRunmodes = extendedRunmodes;
    }

    @Activate
    public void activate(Config config) {
        Set defaultRunmodes = this.slingSettingsService.getRunModes();
        this.extendedRunmodes = new HashSet<String>();
        this.extendedRunmodes.addAll(defaultRunmodes);
        boolean isCloudReady = RuntimeHelper.isCloudReadyInstance();
        if (isCloudReady) {
            this.extendedRunmodes.add(ADDITIONAL_RUNMODE_CLOUD);
        }
        if (config.additionalRunmodes() != null) {
            List<String> additionalRunmodes = Arrays.asList(config.additionalRunmodes());
            this.extendedRunmodes.addAll(additionalRunmodes);
        }
        LOG.info("Default runmodes: {} Extended Runmodes: {}  isCloudReady: {}", new Object[]{defaultRunmodes, this.extendedRunmodes, isCloudReady});
    }

    @Override
    public Set<String> getRunModes() {
        return this.extendedRunmodes;
    }

    @Override
    public String getSlingId() {
        return this.slingSettingsService.getSlingId();
    }

    @Override
    public boolean isMatchingRunModeSpec(String spec) {
        return ExtendedSlingSettingsServiceImpl.getBestRunModeMatchCountFromSpec(spec, this.extendedRunmodes) > 0;
    }

    static int getBestRunModeMatchCountFromSpec(String spec, Collection<String> activeRunModes) {
        int numMatchingRunModes = 0;
        for (String discjunctivePart : spec.split(Pattern.quote(RUN_MODE_SPEC_OR_SEPARATOR))) {
            int newNumMatchingRunModes = ExtendedSlingSettingsServiceImpl.getBestRunModeMatchCountFromConjunctions(discjunctivePart, activeRunModes);
            if (newNumMatchingRunModes <= numMatchingRunModes) continue;
            numMatchingRunModes = newNumMatchingRunModes;
        }
        return numMatchingRunModes;
    }

    static int getBestRunModeMatchCountFromConjunctions(String conjunctions, Collection<String> activeRunModes) {
        int numMatchingRunModes = 0;
        for (String conjunctivePart : conjunctions.split(Pattern.quote(RUN_MODE_SPEC_AND_SEPARATOR))) {
            if (conjunctivePart.startsWith(RUN_MODE_SPEC_NOT_PREFIX) ? activeRunModes.contains(conjunctivePart.substring(RUN_MODE_SPEC_NOT_PREFIX.length())) : !activeRunModes.contains(conjunctivePart)) {
                return 0;
            }
            ++numMatchingRunModes;
        }
        return numMatchingRunModes;
    }

    @ObjectClassDefinition(name="AC Tool Extended Runmodes", description="Add additional runmodes (useful for the cloud where dev/stage/prod are only available at image build time)")
    protected static @interface Config {
        @AttributeDefinition(name="Additional Runmodes", description="Additional runmodes to be considered for AC Tool configs")
        public String[] additionalRunmodes() default {};
    }
}

