/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(property={"url.handler.protocol=jcrinstall"})
public class JcrInstallUrlHandler
extends AbstractURLStreamHandlerService
implements URLStreamHandlerService {
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ResourceResolverFactory resolverFactory;
    private ResourceResolver resolver;
    @Reference
    ServiceUserMapped serviceUserMappingAvailable;

    @Activate
    public void activate() throws LoginException {
        this.resolver = this.resolverFactory.getServiceResourceResolver(null);
    }

    @Deactivate
    public void deactivate() {
        this.resolver.close();
    }

    public URLConnection openConnection(URL url) throws IOException {
        return new JcrInstallConnection(url, this.resolver);
    }

    private static final class JcrInstallConnection
    extends URLConnection {
        private final ResourceResolver resolver;
        private final String path;

        protected JcrInstallConnection(URL url, ResourceResolver resolver) {
            super(url);
            this.resolver = resolver;
            this.path = url.getPath();
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            Resource resource = this.resolver.getResource(this.path);
            if (resource == null) {
                throw new IOException("Could not find resource at path '" + this.path + "'");
            }
            InputStream is = (InputStream)resource.adaptTo(InputStream.class);
            if (is == null) {
                throw new IOException("There is no binary resource at path '" + this.path + "'");
            }
            return is;
        }
    }
}

