/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.history.impl;

import biz.netcentric.cq.tools.actool.history.AcToolExecution;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class AcToolExecutionImpl
implements AcToolExecution,
Comparable<AcToolExecution> {
    static final String TRIGGER_SEPARATOR_IN_NODE_NAME = "_via_";
    private final String id;
    private final String path;
    private final Date installationDate;
    private final boolean isSuccess;
    private final String trigger;
    private final String configurationRootPath;
    private final int authorizableChanges;
    private final int aclChanges;

    public AcToolExecutionImpl(String id, String path, Date installationDate, boolean isSuccess, String configurationRootPath, int authorizableChanges, int aclChanges) {
        this.id = id;
        this.path = path;
        this.installationDate = installationDate;
        this.isSuccess = isSuccess;
        this.trigger = StringUtils.substringAfter((String)path, (String)TRIGGER_SEPARATOR_IN_NODE_NAME);
        this.configurationRootPath = configurationRootPath;
        this.authorizableChanges = authorizableChanges;
        this.aclChanges = aclChanges;
    }

    public String toString() {
        String successStatusString = this.isSuccess ? "ok" : "failed";
        return this.path + " (" + this.installationDate.toString() + ")(" + successStatusString + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLogsPath() {
        return this.path;
    }

    @Override
    public Date getInstallationDate() {
        return this.installationDate;
    }

    @Override
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    public String getTrigger() {
        return this.trigger;
    }

    @Override
    public String getConfigurationRootPath() {
        return this.configurationRootPath;
    }

    @Override
    public int getAuthorizableChanges() {
        return this.authorizableChanges;
    }

    @Override
    public int getAclChanges() {
        return this.aclChanges;
    }

    @Override
    public int compareTo(AcToolExecution otherExecution) {
        return -this.getInstallationDate().compareTo(otherExecution.getInstallationDate());
    }
}

