/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.ui;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WebConsoleConfigTracker.class, ConfigurationListener.class})
public class WebConsoleConfigTracker
implements ConfigurationListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebConsoleConfigTracker.class);
    private static final String CONSOLE_SEC_PROVIDER_PID = "org.apache.sling.extensions.webconsolesecurityprovider.internal.SlingWebConsoleSecurityProvider";
    private static final String CONSOLE_SEC_PROVIDER_USERS_PROP = "users";
    private static final String CONSOLE_SEC_PROVIDER_GROUPS_PROP = "groups";
    private static final String[] RELEVANT_PIDS = new String[]{"org.apache.sling.extensions.webconsolesecurityprovider.internal.SlingWebConsoleSecurityProvider"};
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ConfigurationAdmin configAdmin;
    private String[] allowedUsers = new String[0];
    private String[] allowedGroups = new String[0];

    @Activate
    private void updateConfig() {
        try {
            Dictionary webconsoleSecProviderConfig = this.configAdmin.getConfiguration(CONSOLE_SEC_PROVIDER_PID, null).getProperties();
            if (webconsoleSecProviderConfig != null) {
                this.allowedUsers = PropertiesUtil.toStringArray(webconsoleSecProviderConfig.get(CONSOLE_SEC_PROVIDER_USERS_PROP));
                this.allowedGroups = PropertiesUtil.toStringArray(webconsoleSecProviderConfig.get(CONSOLE_SEC_PROVIDER_GROUPS_PROP));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("allowedUsers: {} allowedGroups: {}", (Object)ArrayUtils.toString((Object)this.allowedUsers), (Object)ArrayUtils.toString((Object)this.allowedGroups));
            }
        }
        catch (IOException e) {
            LOG.warn("Could not update config: " + e, (Throwable)e);
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        String pid = event.getPid();
        if (ArrayUtils.contains((Object[])RELEVANT_PIDS, (Object)pid)) {
            this.updateConfig();
        }
    }

    public String[] getAllowedUsers() {
        return this.allowedUsers;
    }

    public String[] getAllowedGroups() {
        return this.allowedGroups;
    }
}

