/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.helper;

import java.security.Principal;
import java.util.HashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AccessControlUtils.class);

    private AccessControlUtils() {
    }

    public static Privilege[] privilegesFromNames(Session session, String ... privilegeNames) throws RepositoryException {
        return AccessControlUtils.privilegesFromNames(session.getAccessControlManager(), privilegeNames);
    }

    public static Privilege[] privilegesFromNames(AccessControlManager accessControlManager, String ... privilegeNames) throws RepositoryException {
        HashSet<Privilege> privileges = new HashSet<Privilege>(privilegeNames.length);
        for (String privName : privilegeNames) {
            privileges.add(accessControlManager.privilegeFromName(privName));
        }
        return privileges.toArray(new Privilege[privileges.size()]);
    }

    public static String[] namesFromPrivileges(Privilege ... privileges) {
        if (privileges == null || privileges.length == 0) {
            return new String[0];
        }
        String[] names = new String[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            names[i] = privileges[i].getName();
        }
        return names;
    }

    public static JackrabbitAccessControlList getAccessControlList(Session session, String absPath) throws RepositoryException {
        AccessControlManager acMgr = session.getAccessControlManager();
        return AccessControlUtils.getAccessControlList(acMgr, absPath);
    }

    public static JackrabbitAccessControlList getAccessControlPolicies(Session session, Principal principal) throws UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitAccessControlManager acMgr = (JackrabbitAccessControlManager)session.getAccessControlManager();
        if (acMgr.getPolicies(principal).length > 0) {
            JackrabbitAccessControlList jACL = (JackrabbitAccessControlList)acMgr.getPolicies(principal)[0];
            return jACL;
        }
        return null;
    }

    public static JackrabbitAccessControlList getAccessControlList(AccessControlManager accessControlManager, String absPath) throws RepositoryException {
        AccessControlPolicy[] pcls;
        AccessControlPolicyIterator itr = accessControlManager.getApplicablePolicies(absPath);
        while (itr.hasNext()) {
            AccessControlPolicy policy = itr.nextAccessControlPolicy();
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        for (AccessControlPolicy policy : pcls = accessControlManager.getPolicies(absPath)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            return (JackrabbitAccessControlList)policy;
        }
        LOG.warn("no policy found for path: {}", (Object)absPath);
        return null;
    }

    public static int deleteAllEntriesForPrincipalsFromACL(Session session, String path, String[] principalNamesToBeDeleted) throws UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitAccessControlList acl;
        AccessControlManager accessControlManager = session.getAccessControlManager();
        if (StringUtils.isBlank((CharSequence)path)) {
            path = null;
        }
        if ((acl = AccessControlUtils.getModifiableAcl(accessControlManager, path)) == null) {
            return 0;
        }
        AccessControlEntry[] aces = acl.getAccessControlEntries();
        int countRemoved = 0;
        for (AccessControlEntry ace : aces) {
            JackrabbitAccessControlEntry jace = (JackrabbitAccessControlEntry)ace;
            String principalNameInCurrentAce = jace.getPrincipal().getName();
            if (!ArrayUtils.contains((Object[])principalNamesToBeDeleted, (Object)principalNameInCurrentAce)) continue;
            acl.removeAccessControlEntry((AccessControlEntry)jace);
            ++countRemoved;
        }
        if (countRemoved > 0) {
            if (!acl.isEmpty()) {
                accessControlManager.setPolicy(path, (AccessControlPolicy)acl);
            } else {
                accessControlManager.removePolicy(path, (AccessControlPolicy)acl);
            }
        }
        return countRemoved;
    }

    public static JackrabbitAccessControlList getModifiableAcl(AccessControlManager acMgr, String path) throws RepositoryException, AccessDeniedException {
        if (StringUtils.isBlank((CharSequence)path)) {
            path = null;
        }
        AccessControlPolicy[] existing = null;
        try {
            existing = acMgr.getPolicies(path);
        }
        catch (PathNotFoundException e) {
            LOG.debug("No node could be found under: {}. Application of ACL for that node cancelled!", (Object)path);
        }
        if (existing != null) {
            for (AccessControlPolicy p : existing) {
                if (!(p instanceof JackrabbitAccessControlList)) continue;
                return (JackrabbitAccessControlList)p;
            }
            AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
            while (it.hasNext()) {
                AccessControlPolicy p = it.nextAccessControlPolicy();
                if (!(p instanceof JackrabbitAccessControlList)) continue;
                return (JackrabbitAccessControlList)p;
            }
            throw new AccessControlException("No modifiable ACL at " + path);
        }
        return null;
    }

    public static UserManager getUserManagerAutoSaveDisabled(Session session) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        JackrabbitSession js = (JackrabbitSession)session;
        UserManager userManager = js.getUserManager();
        if (userManager.isAutoSave()) {
            try {
                userManager.autoSave(false);
            }
            catch (UnsupportedRepositoryOperationException e) {
                LOG.warn("disabling autoSave not possible with this user manager!");
            }
        }
        return userManager;
    }
}

