/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.dumpservice;

import biz.netcentric.cq.tools.actool.configmodel.AceBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.Restriction;
import biz.netcentric.cq.tools.actool.dumpservice.AcDumpElementVisitor;
import biz.netcentric.cq.tools.actool.dumpservice.CommentingDumpElement;
import biz.netcentric.cq.tools.actool.dumpservice.StructuralDumpElement;
import biz.netcentric.cq.tools.actool.helper.AcHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AcDumpElementYamlVisitor
implements AcDumpElementVisitor {
    public static final int DUMP_INDENTATION_KEY = 4;
    public static final int DUMP_INDENTATION_FIRST_PROPERTY = 7;
    public static final int DUMP_INDENTATION_PROPERTY = 9;
    public static final int DUMP_INDENTATION_PROPERTY_SUB = 11;
    public static final String YAML_STRUCTURAL_ELEMENT_PREFIX = "- ";
    private final StringBuilder sb;
    private final int mapOrder;

    public AcDumpElementYamlVisitor(int mapOrder, StringBuilder sb) {
        this.mapOrder = mapOrder;
        this.sb = sb;
    }

    @Override
    public void visit(AuthorizableConfigBean authorizableConfigBean) {
        String authorizableNameInDump = !StringUtils.equals((CharSequence)authorizableConfigBean.getAuthorizableId(), (CharSequence)authorizableConfigBean.getName()) ? authorizableConfigBean.getName() : "";
        this.sb.append(AcHelper.getBlankString(4)).append(YAML_STRUCTURAL_ELEMENT_PREFIX + authorizableConfigBean.getAuthorizableId() + ":").append("\n");
        this.sb.append("\n");
        this.sb.append(AcHelper.getBlankString(7)).append("- name: ").append(StringUtils.isNotBlank((CharSequence)authorizableNameInDump) ? "\"" + authorizableNameInDump + "\"" : "").append("\n");
        this.writeIsMemberOf(authorizableConfigBean);
        this.sb.append(AcHelper.getBlankString(9)).append("path: " + authorizableConfigBean.getPath()).append("\n");
        if (!authorizableConfigBean.isGroup() && authorizableConfigBean.isSystemUser()) {
            this.sb.append(AcHelper.getBlankString(9)).append("isSystemUser: true\n");
        }
        if (StringUtils.isNotBlank((CharSequence)authorizableConfigBean.getExternalId())) {
            this.sb.append(AcHelper.getBlankString(9)).append("externalId: " + authorizableConfigBean.getExternalId()).append("\n");
        }
        this.sb.append("\n");
    }

    /*
     * WARNING - void declaration
     */
    private void writeIsMemberOf(AuthorizableConfigBean authorizableConfigBean) {
        Object[] isMemberOf = authorizableConfigBean.getIsMemberOf();
        if (isMemberOf == null) {
            isMemberOf = new String[]{};
        }
        boolean useCommaSeparatedList = isMemberOf.length <= 3;
        for (String string : isMemberOf) {
            if (!string.contains(",")) continue;
            useCommaSeparatedList = false;
        }
        StringBuilder isMemberOfYamlVal = new StringBuilder();
        if (useCommaSeparatedList) {
            isMemberOfYamlVal.append(StringUtils.join((Object[])isMemberOf, (String)","));
        } else {
            void var7_10;
            Object[] objectArray = isMemberOf;
            int n = objectArray.length;
            boolean bl = false;
            while (var7_10 < n) {
                Object isMemberOfGroup = objectArray[var7_10];
                isMemberOfYamlVal.append("\n" + AcHelper.getBlankString(11) + YAML_STRUCTURAL_ELEMENT_PREFIX + (String)isMemberOfGroup);
                ++var7_10;
            }
        }
        this.sb.append(AcHelper.getBlankString(9)).append("isMemberOf: " + isMemberOfYamlVal).append("\n");
    }

    @Override
    public void visit(AceBean aceBean) {
        if (this.mapOrder == AcHelper.PATH_BASED_ORDER) {
            this.sb.append(AcHelper.getBlankString(7)).append("- principal: " + aceBean.getPrincipalName());
            if (!StringUtils.equals((CharSequence)aceBean.getPrincipalName(), (CharSequence)aceBean.getAuthorizableId())) {
                this.sb.append(" # authorizableId: ").append(aceBean.getAuthorizableId());
            }
            this.sb.append("\n");
        } else if (this.mapOrder == AcHelper.PRINCIPAL_BASED_ORDER) {
            this.sb.append(AcHelper.getBlankString(7)).append("- path: " + (String)StringUtils.defaultIfEmpty((CharSequence)aceBean.getJcrPath(), (CharSequence)"")).append("\n");
        }
        this.sb.append(AcHelper.getBlankString(9)).append("permission: " + aceBean.getPermission()).append("\n");
        if (StringUtils.isNotBlank((CharSequence)aceBean.getActionsString())) {
            this.sb.append(AcHelper.getBlankString(9)).append("actions: " + aceBean.getActionsString()).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)aceBean.getPrivilegesString())) {
            this.sb.append(AcHelper.getBlankString(9)).append("privileges: " + aceBean.getPrivilegesString()).append("\n");
        }
        if (aceBean.isKeepOrder()) {
            this.sb.append(AcHelper.getBlankString(9)).append("keepOrder: true").append("\n");
        }
        this.writeRestrictions(aceBean, this.sb);
        this.sb.append("\n");
        this.sb.append("\n");
    }

    private void writeRestrictions(AceBean aceBean, StringBuilder sb) {
        List<Restriction> restrictions = aceBean.getRestrictions();
        if (restrictions.isEmpty()) {
            return;
        }
        sb.append(AcHelper.getBlankString(9)).append("restrictions:");
        sb.append("\n");
        for (Restriction restriction : restrictions) {
            String restrictionsValueString = StringUtils.join(restriction.getValues(), (String)",");
            String restrictionsValEscaped = StringUtils.equals((CharSequence)restrictionsValueString, (CharSequence)"") ? "''" : (restrictionsValueString != null && restrictionsValueString.matches("[A-Za-z0-9,/]+") ? restrictionsValueString : "'" + restrictionsValueString + "'");
            sb.append(AcHelper.getBlankString(11)).append(restriction.getName()).append(": ").append(restrictionsValEscaped);
            sb.append("\n");
        }
    }

    @Override
    public void visit(CommentingDumpElement commentingDumpElement) {
        this.sb.append("# " + commentingDumpElement.getString());
        this.sb.append("\n");
        this.sb.append("\n");
    }

    @Override
    public void visit(StructuralDumpElement structuralDumpElement) {
        this.sb.append("\n");
        String key = structuralDumpElement.getString();
        if (StringUtils.isBlank((CharSequence)key) || !key.matches("[A-Za-z0-9\\-_/.]+")) {
            key = "'" + key + "'";
        }
        this.sb.append(AcHelper.getBlankString(structuralDumpElement.getLevel() * 2) + YAML_STRUCTURAL_ELEMENT_PREFIX + key + ":");
        String comment = structuralDumpElement.getComment();
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            this.sb.append(" # " + comment);
        }
        this.sb.append("\n");
        this.sb.append("\n");
    }

    public int getMapOrder() {
        return this.mapOrder;
    }
}

