/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven.plugin;

import aQute.bnd.exceptions.Exceptions;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.maven.lib.configuration.BeanProperties;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.mapping.MappingUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractBndMavenPlugin
extends AbstractMojo {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    static final String MANIFEST_LAST_MODIFIED = "aQute.bnd.maven.plugin.BndMavenPlugin.manifestLastModified";
    static final String MARKED_FILES = "aQute.bnd.maven.plugin.BndMavenPlugin.markedFiles";
    static final String PACKAGING_JAR = "jar";
    static final String PACKAGING_WAR = "war";
    static final String TSTAMP = "${tstamp}";
    static final String SNAPSHOT = "SNAPSHOT";
    static final String OUTPUT_TIMESTAMP = "project.build.outputTimestamp";
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    File targetDir;
    @Parameter(defaultValue="true")
    boolean includeClassesDir;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}")
    File warOutputDir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    Settings settings;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    MojoExecution mojoExecution;
    @Parameter(property="bnd.packagingTypes", defaultValue="jar,war")
    List<String> packagingTypes;
    @Parameter(property="bnd.skipIfEmpty", defaultValue="false")
    boolean skipIfEmpty;
    @Parameter(defaultValue="bnd.bnd")
    String bndfile;
    @Parameter
    String bnd;
    @Component
    BuildContext buildContext;
    File propertiesFile;

    public abstract File getSourceDir();

    public abstract List<Resource> getResources();

    public abstract File getClassesDir();

    public abstract File getOutputDir();

    public abstract File getManifestPath();

    public abstract boolean isSkip();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.logger.debug("skip project as configured");
            return;
        }
        File classesDir = this.getClassesDir();
        if (this.skipIfEmpty && this.includeClassesDir && this.isEmpty(classesDir)) {
            this.logger.debug("skip project because includeClassesDir=true, compiler output directory is empty and skipIfEmpty=true");
            return;
        }
        if (!this.packagingTypes.contains(this.project.getPackaging())) {
            this.logger.info("skip project with packaging=" + this.project.getPackaging());
            return;
        }
        BeanProperties beanProperties = new BeanProperties();
        beanProperties.put("project", this.project);
        beanProperties.put("settings", this.settings);
        Properties mavenProperties = new Properties((Properties)beanProperties);
        Properties projectProperties = this.project.getProperties();
        Enumeration<?> propertyNames = projectProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object key = propertyNames.nextElement();
            mavenProperties.put(key, projectProperties.get(key));
        }
        try (Builder builder = new Builder(new Processor(mavenProperties, false));){
            String snapshot;
            boolean isReproducible;
            builder.setTrace(this.logger.isDebugEnabled());
            builder.setBase(this.project.getBasedir());
            this.propertiesFile = this.loadProperties(builder);
            builder.setProperty("project.output", this.targetDir.getCanonicalPath());
            if (Processor.isTrue((String)builder.getProperty("-nobundles"))) {
                this.logger.debug("-nobundles: true");
                return;
            }
            List subs = builder.getSubBuilders();
            if (subs.size() != 1 || !builder.equals(subs.get(0))) {
                throw new MojoExecutionException("Sub-bundles not permitted in a maven build");
            }
            if (this.getClassesDir().isDirectory()) {
                builder.addClasspath(this.getClassesDir());
                Jar classesDirJar = new Jar(this.project.getName(), this.getClassesDir());
                if (!this.includeClassesDir) {
                    classesDirJar.removePrefix("");
                }
                classesDirJar.setManifest(new Manifest());
                builder.setJar(classesDirJar);
            }
            boolean isWab = PACKAGING_WAR.equals(this.project.getPackaging());
            boolean hasWablibs = builder.getProperty("-wablib") != null;
            String wabProperty = builder.getProperty("-wab");
            File outputDir = this.getOutputDir();
            if (isWab) {
                if (wabProperty == null) {
                    builder.setProperty("-wab", "");
                }
                outputDir = this.warOutputDir;
                this.logger.info("WAB mode enabled. Bnd output will be expanded into the 'maven-war-plugin' <webappDirectory>:" + outputDir);
            } else if (wabProperty != null || hasWablibs) {
                throw new MojoFailureException("-wab & -wablib are not supported with packaging 'jar'");
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Object> buildpath = new ArrayList<Object>(artifacts.size());
            ArrayList<String> wablibs = new ArrayList<String>(artifacts.size());
            ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter("runtime");
            for (Artifact artifact : artifacts) {
                File cpe = artifact.getFile().getCanonicalFile();
                if (!cpe.exists()) {
                    this.logger.debug("dependency {} does not exist", (Object)cpe);
                    continue;
                }
                if (cpe.isDirectory()) {
                    Jar cpeJar = new Jar(cpe);
                    builder.addClose((AutoCloseable)cpeJar);
                    builder.updateModified(cpeJar.lastModified(), cpe.getPath());
                    buildpath.add(cpeJar);
                    continue;
                }
                if (!artifact.getType().equals(PACKAGING_JAR)) {
                    try (ZipFile zip = new ZipFile(cpe);){
                        zip.entries();
                    }
                    catch (ZipException e) {
                        this.logger.debug("dependency {} is not a zip", (Object)cpe);
                        continue;
                    }
                }
                builder.updateModified(cpe.lastModified(), cpe.getPath());
                buildpath.add(cpe);
                if (!isWab || hasWablibs || artifact.isOptional() || !scopeFilter.include(artifact)) continue;
                String fileNameMapping = MappingUtils.evaluateFileNameMapping((String)"@{artifactId}@-@{baseVersion}@.@{extension}@", (Artifact)artifact);
                wablibs.add("WEB-INF/lib/" + fileNameMapping + "=" + cpe.getName() + ";lib:=true");
            }
            if (!wablibs.isEmpty()) {
                String wablib = wablibs.stream().collect(Collectors.joining(","));
                builder.setProperty("-wablib", wablib);
            }
            this.processBuildPath(buildpath);
            builder.setProperty("project.buildpath", Strings.join((String)File.pathSeparator, buildpath));
            this.logger.debug("builder classpath: {}", (Object)builder.getProperty("project.buildpath"));
            boolean delta = !this.buildContext.isIncremental() || this.manifestOutOfDate();
            ArrayList<File> sourcepath = new ArrayList<File>();
            if (this.getSourceDir().exists()) {
                sourcepath.add(this.getSourceDir().getCanonicalFile());
                delta |= this.buildContext.hasDelta(this.getSourceDir());
            }
            for (Resource resource : this.getResources()) {
                File resourceDir = new File(resource.getDirectory());
                if (!resourceDir.exists()) continue;
                sourcepath.add(resourceDir.getCanonicalFile());
                delta |= this.buildContext.hasDelta(resourceDir);
            }
            builder.setProperty("project.sourcepath", Strings.join((String)File.pathSeparator, sourcepath));
            this.logger.debug("builder sourcepath: {}", (Object)builder.getProperty("project.sourcepath"));
            this.processBuilder(builder);
            boolean bl = isReproducible = projectProperties.getProperty(OUTPUT_TIMESTAMP) != null;
            if (builder.getProperty("Bundle-SymbolicName") == null) {
                builder.setProperty("Bundle-SymbolicName", this.project.getArtifactId());
            }
            if (builder.getProperty("Bundle-Name") == null) {
                builder.setProperty("Bundle-Name", this.project.getName());
            }
            String string = snapshot = isReproducible ? SNAPSHOT : null;
            if (builder.getProperty("Bundle-Version") == null) {
                Version version = new MavenVersion(this.project.getVersion()).getOSGiVersion();
                builder.setProperty("Bundle-Version", version.toString());
                if (snapshot == null) {
                    snapshot = TSTAMP;
                }
            }
            if (snapshot != null && builder.getProperty("-snapshot") == null) {
                builder.setProperty("-snapshot", snapshot);
            }
            if (builder.getProperty("Bundle-Description") == null && StringUtils.isNotBlank((String)this.project.getDescription())) {
                builder.setProperty("Bundle-Description", this.project.getDescription());
            }
            if (builder.getProperty("Bundle-Vendor") == null && this.project.getOrganization() != null && StringUtils.isNotBlank((String)this.project.getOrganization().getName())) {
                builder.setProperty("Bundle-Vendor", this.project.getOrganization().getName());
            }
            if (builder.getProperty("Bundle-License") == null) {
                StringBuilder licenses = new StringBuilder();
                for (License license : this.project.getLicenses()) {
                    AbstractBndMavenPlugin.addHeaderValue(licenses, license.getName(), ',');
                    if (StringUtils.isNotBlank((String)license.getUrl())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(licenses, "link", license.getUrl(), ';');
                    }
                    if (!StringUtils.isNotBlank((String)license.getComments())) continue;
                    AbstractBndMavenPlugin.addHeaderAttribute(licenses, "description", license.getComments(), ';');
                }
                if (licenses.length() > 0) {
                    builder.setProperty("Bundle-License", licenses.toString());
                }
            }
            if (builder.getProperty("Bundle-SCM") == null) {
                StringBuilder scm = new StringBuilder();
                if (this.project.getScm() != null) {
                    if (StringUtils.isNotBlank((String)this.project.getScm().getUrl())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "url", this.project.getScm().getUrl(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getConnection())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "connection", this.project.getScm().getConnection(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getDeveloperConnection())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "developer-connection", this.project.getScm().getDeveloperConnection(), ',');
                    }
                    if (StringUtils.isNotBlank((String)this.project.getScm().getTag())) {
                        AbstractBndMavenPlugin.addHeaderAttribute(scm, "tag", this.project.getScm().getTag(), ',');
                    }
                    if (scm.length() > 0) {
                        builder.setProperty("Bundle-SCM", scm.toString());
                    }
                }
            }
            if (builder.getProperty("Bundle-Developers") == null) {
                StringBuilder developers = new StringBuilder();
                for (Developer developer : this.project.getDevelopers()) {
                    if (StringUtils.isNotBlank((String)developer.getId())) {
                        AbstractBndMavenPlugin.addHeaderValue(developers, developer.getId(), ',');
                        if (StringUtils.isNotBlank((String)developer.getEmail())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "email", developer.getEmail(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getName())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "name", developer.getName(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getOrganization())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "organization", developer.getOrganization(), ';');
                        }
                        if (StringUtils.isNotBlank((String)developer.getOrganizationUrl())) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "organizationUrl", developer.getOrganizationUrl(), ';');
                        }
                        if (!developer.getRoles().isEmpty()) {
                            AbstractBndMavenPlugin.addHeaderAttribute(developers, "roles", StringUtils.join(developer.getRoles().iterator(), (String)","), ';');
                        }
                        if (!StringUtils.isNotBlank((String)developer.getTimezone())) continue;
                        AbstractBndMavenPlugin.addHeaderAttribute(developers, "timezone", developer.getTimezone(), ';');
                        continue;
                    }
                    this.logger.warn("Cannot consider developer in line '{}' of file '{}' for bundle header '{}' as it does not contain the mandatory id.", new Object[]{developer.getLocation((Object)"").getLineNumber(), developer.getLocation((Object)"").getSource().getLocation(), "Bundle-Developers"});
                }
                if (developers.length() > 0) {
                    builder.setProperty("Bundle-Developers", developers.toString());
                }
            }
            if (builder.getProperty("Bundle-DocURL") == null && StringUtils.isNotBlank((String)this.project.getUrl())) {
                builder.setProperty("Bundle-DocURL", this.project.getUrl());
            }
            if (isReproducible && builder.getProperty("-noextraheaders") == null) {
                builder.setProperty("-noextraheaders", "true");
            }
            this.logger.debug("builder properties: {}", (Object)builder.getProperties());
            this.logger.debug("builder delta: {}", (Object)delta);
            if (delta || builder.getJar() == null || builder.lastModified() > builder.getJar().lastModified()) {
                builder.setClasspath(buildpath);
                builder.setSourcepath(sourcepath.toArray(new File[0]));
                Jar bndJar = builder.build();
                this.expandJar(bndJar, outputDir);
            } else {
                this.logger.debug("No build");
            }
            this.reportErrorsAndWarnings(builder);
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("bnd error: " + e.getMessage(), e);
        }
    }

    protected void processBuilder(Builder builder) throws MojoFailureException {
    }

    protected void processBuildPath(List<Object> buildpath) {
    }

    private static StringBuilder addHeaderValue(StringBuilder builder, String value, char separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        OSGiHeader.quote((StringBuilder)builder, (String)value);
        return builder;
    }

    private static StringBuilder addHeaderAttribute(StringBuilder builder, String key, String value, char separator) {
        if (builder.length() > 0) {
            builder.append(separator);
        }
        builder.append(key).append("=");
        OSGiHeader.quote((StringBuilder)builder, (String)value);
        return builder;
    }

    private File loadProperties(Builder builder) throws Exception {
        this.loadParentProjectProperties(builder, this.project);
        Xpp3Dom configuration = Optional.ofNullable(this.project.getBuildPlugins()).flatMap(this::getConfiguration).orElseGet(this::defaultConfiguration);
        return this.loadProjectProperties(builder, this.project, this.project, configuration);
    }

    private void loadParentProjectProperties(Builder builder, MavenProject currentProject) throws Exception {
        MavenProject parentProject = currentProject.getParent();
        if (parentProject == null) {
            return;
        }
        this.loadParentProjectProperties(builder, parentProject);
        Xpp3Dom configuration = Optional.ofNullable(parentProject.getBuildPlugins()).flatMap(this::getConfiguration).orElse(null);
        if (configuration != null) {
            this.loadProjectProperties(builder, parentProject, parentProject, configuration);
            return;
        }
        configuration = Optional.ofNullable(currentProject.getPluginManagement()).map(PluginContainer::getPlugins).flatMap(this::getConfiguration).orElseGet(this::defaultConfiguration);
        this.loadProjectProperties(builder, parentProject, currentProject, configuration);
    }

    private File loadProjectProperties(Builder builder, MavenProject bndProject, MavenProject pomProject, Xpp3Dom configuration) throws Exception {
        Xpp3Dom bndElement;
        File pomFile;
        File baseDir = bndProject.getBasedir();
        if (baseDir != null) {
            pomFile = bndProject.getFile();
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
            Xpp3Dom bndfileElement = configuration.getChild("bndfile");
            String bndFileName = bndfileElement != null ? bndfileElement.getValue() : "bnd.bnd";
            File bndFile = IO.getFile((File)baseDir, (String)bndFileName);
            if (bndFile.isFile()) {
                this.logger.debug("loading bnd properties from file: {}", (Object)bndFile);
                builder.setProperties(bndFile.getParentFile(), builder.loadProperties(bndFile));
                return bndFile;
            }
        }
        baseDir = pomProject.getBasedir();
        pomFile = pomProject.getFile();
        if (baseDir != null) {
            builder.updateModified(pomFile.lastModified(), "POM: " + pomFile);
        }
        if ((bndElement = configuration.getChild("bnd")) != null) {
            this.logger.debug("loading bnd properties from bnd element in pom: {}", (Object)pomProject);
            UTF8Properties properties = new UTF8Properties();
            properties.load(bndElement.getValue(), pomFile, (Reporter)builder);
            builder.setProperties(baseDir, (Properties)properties.replaceHere(baseDir));
        }
        return pomFile;
    }

    private Optional<Xpp3Dom> getConfiguration(List<Plugin> plugins) {
        return plugins.stream().filter(p -> Objects.equals(p, this.mojoExecution.getPlugin())).map(Plugin::getExecutions).flatMap(Collection::stream).filter(e -> Objects.equals(e.getId(), this.mojoExecution.getExecutionId())).findFirst().map(ConfigurationContainer::getConfiguration).map(Xpp3Dom.class::cast).map(Xpp3Dom::new);
    }

    private Xpp3Dom defaultConfiguration() {
        return new Xpp3Dom("configuration");
    }

    protected void reportErrorsAndWarnings(Builder builder) throws MojoFailureException {
        Collection<File> markedFiles = (HashSet)this.buildContext.getValue(MARKED_FILES);
        if (markedFiles == null) {
            this.buildContext.removeMessages(this.propertiesFile);
            markedFiles = builder.getIncluded();
        }
        if (markedFiles != null) {
            for (File file : markedFiles) {
                this.buildContext.removeMessages(file);
            }
        }
        markedFiles = new HashSet();
        List warnings = builder.getWarnings();
        for (String warning : warnings) {
            Report.Location location = builder.getLocation(warning);
            if (location == null) {
                location = new Report.Location();
                location.message = warning;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 1, null);
        }
        List list = builder.getErrors();
        for (String error : list) {
            Report.Location location = builder.getLocation(error);
            if (location == null) {
                location = new Report.Location();
                location.message = error;
            }
            File f = location.file == null ? this.propertiesFile : new File(location.file);
            markedFiles.add(f);
            this.buildContext.addMessage(f, location.line, location.length, location.message, 2, null);
        }
        this.buildContext.setValue(MARKED_FILES, markedFiles);
        if (!builder.isOk()) {
            if (list.size() == 1) {
                throw new MojoFailureException((String)list.get(0));
            }
            throw new MojoFailureException("Errors in bnd processing, see log for details.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEmpty(File directory) {
        if (directory == null) return true;
        if (!directory.isDirectory()) {
            return true;
        }
        Path path = directory.toPath();
        try (Stream<Path> entries = Files.walk(path, new FileVisitOption[0]);){
            boolean bl = !entries.filter(p -> !Files.isDirectory(p, new LinkOption[0])).findFirst().isPresent();
            return bl;
        }
        catch (IOException ioe) {
            throw Exceptions.duck((Throwable)ioe);
        }
    }

    private void expandJar(Jar jar, File dir) throws Exception {
        long lastModified = jar.lastModified();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Bundle lastModified: %tF %<tT.%<tL", lastModified));
        }
        dir = dir.getAbsoluteFile();
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        for (Map.Entry entry : jar.getResources().entrySet()) {
            FileResource fr;
            File outFile = IO.getBasedFile((File)dir, (String)((String)entry.getKey()));
            aQute.bnd.osgi.Resource resource = (aQute.bnd.osgi.Resource)entry.getValue();
            if (resource instanceof FileResource && outFile.equals((fr = (FileResource)resource).getFile()) || outFile.exists() && outFile.lastModified() >= lastModified) continue;
            if (this.logger.isDebugEnabled()) {
                if (outFile.exists()) {
                    this.logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", outFile.lastModified(), outFile));
                } else {
                    this.logger.debug("Creating '{}'", (Object)outFile);
                }
            }
            Files.createDirectories(outFile.toPath().getParent(), new FileAttribute[0]);
            OutputStream out = this.buildContext.newFileOutputStream(outFile);
            Throwable throwable = null;
            try {
                IO.copy((InputStream)resource.openInputStream(), (OutputStream)out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        if (this.manifestOutOfDate() || this.getManifestPath().lastModified() < lastModified) {
            if (this.logger.isDebugEnabled()) {
                if (!this.manifestOutOfDate()) {
                    this.logger.debug(String.format("Updating lastModified: %tF %<tT.%<tL '%s'", this.getManifestPath().lastModified(), this.getManifestPath()));
                } else {
                    this.logger.debug("Creating '{}'", (Object)this.getManifestPath());
                }
            }
            Files.createDirectories(this.getManifestPath().toPath().getParent(), new FileAttribute[0]);
            try (OutputStream manifestOut = this.buildContext.newFileOutputStream(this.getManifestPath());){
                jar.writeManifest(manifestOut);
            }
            this.buildContext.setValue(MANIFEST_LAST_MODIFIED, (Object)this.getManifestPath().lastModified());
        }
    }

    private boolean manifestOutOfDate() {
        if (!this.getManifestPath().isFile()) {
            return true;
        }
        long manifestLastModified = 0L;
        if (this.buildContext.getValue(MANIFEST_LAST_MODIFIED) != null) {
            manifestLastModified = (Long)this.buildContext.getValue(MANIFEST_LAST_MODIFIED);
        }
        return this.getManifestPath().lastModified() != manifestLastModified;
    }
}

