/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class StackMapTableAttribute
implements Attribute {
    public static final String NAME = "StackMapTable";
    public final StackMapFrame[] entries;

    public StackMapTableAttribute(StackMapFrame[] entries) {
        this.entries = entries;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "StackMapTable " + Arrays.toString(this.entries);
    }

    public static StackMapTableAttribute read(DataInput in, ConstantPool constant_pool) throws IOException {
        int number_of_entries = in.readUnsignedShort();
        StackMapFrame[] entries = new StackMapFrame[number_of_entries];
        for (int i = 0; i < number_of_entries; ++i) {
            int n;
            VerificationTypeInfo[] locals;
            int frame_type = in.readUnsignedByte();
            if (frame_type <= 63) {
                entries[i] = new SameFrame(frame_type);
                continue;
            }
            if (frame_type <= 127) {
                VerificationTypeInfo stack = VerificationTypeInfo.read(in, constant_pool);
                entries[i] = new SameLocals1StackItemFrame(frame_type, stack);
                continue;
            }
            if (frame_type <= 246) {
                throw new IOException("Unrecognized stack map frame type " + frame_type);
            }
            if (frame_type <= 247) {
                int offset_delta = in.readUnsignedShort();
                VerificationTypeInfo stack = VerificationTypeInfo.read(in, constant_pool);
                entries[i] = new SameLocals1StackItemFrameExtended(frame_type, offset_delta, stack);
                continue;
            }
            if (frame_type <= 250) {
                int offset_delta = in.readUnsignedShort();
                entries[i] = new ChopFrame(frame_type, offset_delta);
                continue;
            }
            if (frame_type <= 251) {
                int offset_delta = in.readUnsignedShort();
                entries[i] = new SameFrameExtended(frame_type, offset_delta);
                continue;
            }
            if (frame_type <= 254) {
                int offset_delta = in.readUnsignedShort();
                int number_of_locals = frame_type - 251;
                locals = new VerificationTypeInfo[number_of_locals];
                for (n = 0; n < number_of_locals; ++n) {
                    locals[n] = VerificationTypeInfo.read(in, constant_pool);
                }
                entries[i] = new AppendFrame(frame_type, offset_delta, locals);
                continue;
            }
            if (frame_type > 255) continue;
            int offset_delta = in.readUnsignedShort();
            int number_of_locals = in.readUnsignedShort();
            locals = new VerificationTypeInfo[number_of_locals];
            for (n = 0; n < number_of_locals; ++n) {
                locals[n] = VerificationTypeInfo.read(in, constant_pool);
            }
            int number_of_stack_items = in.readUnsignedShort();
            VerificationTypeInfo[] stack = new VerificationTypeInfo[number_of_stack_items];
            for (int n2 = 0; n2 < number_of_stack_items; ++n2) {
                stack[n2] = VerificationTypeInfo.read(in, constant_pool);
            }
            entries[i] = new FullFrame(frame_type, offset_delta, locals, stack);
        }
        return new StackMapTableAttribute(entries);
    }

    @Override
    public void write(DataOutput out, ConstantPool constant_pool) throws IOException {
        int attribute_name_index = constant_pool.utf8Info(this.name());
        int attribute_length = this.attribute_length();
        out.writeShort(attribute_name_index);
        out.writeInt(attribute_length);
        out.writeShort(this.entries.length);
        for (StackMapFrame entry : this.entries) {
            entry.write(out, constant_pool);
        }
    }

    @Override
    public int attribute_length() {
        int attribute_length = 2;
        for (StackMapFrame entry : this.entries) {
            attribute_length += entry.value_length();
        }
        return attribute_length;
    }

    public static abstract class StackMapFrame {
        public static final int SAME = 63;
        public static final int SAME_LOCALS_1_STACK_ITEM = 127;
        public static final int RESERVED = 246;
        public static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
        public static final int CHOP = 250;
        public static final int SAME_FRAME_EXTENDED = 251;
        public static final int APPEND = 254;
        public static final int FULL_FRAME = 255;
        public final int tag;

        protected StackMapFrame(int tag) {
            this.tag = tag;
        }

        public abstract int type();

        public String toString() {
            return Integer.toString(this.tag);
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
        }

        int value_length() {
            return 1;
        }
    }

    public static class SameFrame
    extends StackMapFrame {
        public SameFrame(int tag) {
            super(tag);
        }

        @Override
        public int type() {
            return 63;
        }
    }

    public static class VerificationTypeInfo {
        public static final int ITEM_Top = 0;
        public static final int ITEM_Integer = 1;
        public static final int ITEM_Float = 2;
        public static final int ITEM_Double = 3;
        public static final int ITEM_Long = 4;
        public static final int ITEM_Null = 5;
        public static final int ITEM_UninitializedThis = 6;
        public static final int ITEM_Object = 7;
        public static final int ITEM_Uninitialized = 8;
        public final int tag;

        public VerificationTypeInfo(int tag) {
            this.tag = tag;
        }

        static VerificationTypeInfo read(DataInput in, ConstantPool constant_pool) throws IOException {
            int tag = in.readUnsignedByte();
            return switch (tag) {
                case 0, 1, 2, 3, 4, 5, 6 -> new VerificationTypeInfo(tag);
                case 7 -> {
                    int cpool_index = in.readUnsignedShort();
                    yield new ObjectVariableInfo(tag, constant_pool.className(cpool_index));
                }
                case 8 -> {
                    int offset = in.readUnsignedShort();
                    yield new UninitializedVariableInfo(tag, offset);
                }
                default -> throw new IOException("Unrecognized verification type tag " + tag);
            };
        }

        public String toString() {
            return Integer.toString(this.tag);
        }

        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
        }

        int value_length() {
            return 1;
        }
    }

    public static class SameLocals1StackItemFrame
    extends StackMapFrame {
        public final VerificationTypeInfo stack;

        public SameLocals1StackItemFrame(int tag, VerificationTypeInfo stack) {
            super(tag);
            this.stack = stack;
        }

        @Override
        public int type() {
            return 127;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.stack;
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            this.stack.write(out, constant_pool);
        }

        @Override
        int value_length() {
            return 1 + this.stack.value_length();
        }
    }

    public static class SameLocals1StackItemFrameExtended
    extends StackMapFrame {
        public final int delta;
        public final VerificationTypeInfo stack;

        public SameLocals1StackItemFrameExtended(int tag, int delta, VerificationTypeInfo stack) {
            super(tag);
            this.delta = delta;
            this.stack = stack;
        }

        @Override
        public int type() {
            return 247;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta + "/" + this.stack;
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            out.writeShort(this.delta);
            this.stack.write(out, constant_pool);
        }

        @Override
        int value_length() {
            return 3 + this.stack.value_length();
        }
    }

    public static class ChopFrame
    extends StackMapFrame {
        public final int delta;

        public ChopFrame(int tag, int delta) {
            super(tag);
            this.delta = delta;
        }

        @Override
        public int type() {
            return 250;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta;
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            out.writeShort(this.delta);
        }

        @Override
        int value_length() {
            return 3;
        }
    }

    public static class SameFrameExtended
    extends StackMapFrame {
        public final int delta;

        public SameFrameExtended(int tag, int delta) {
            super(tag);
            this.delta = delta;
        }

        @Override
        public int type() {
            return 251;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta;
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            out.writeShort(this.delta);
        }

        @Override
        int value_length() {
            return 3;
        }
    }

    public static class AppendFrame
    extends StackMapFrame {
        public final int delta;
        public final VerificationTypeInfo[] locals;

        public AppendFrame(int tag, int delta, VerificationTypeInfo[] locals) {
            super(tag);
            this.delta = delta;
            this.locals = locals;
        }

        @Override
        public int type() {
            return 254;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta + "/" + Arrays.toString(this.locals);
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            out.writeShort(this.delta);
            for (VerificationTypeInfo local : this.locals) {
                local.write(out, constant_pool);
            }
        }

        @Override
        int value_length() {
            int value_length = 3;
            for (VerificationTypeInfo local : this.locals) {
                value_length += local.value_length();
            }
            return value_length;
        }
    }

    public static class FullFrame
    extends StackMapFrame {
        public final int delta;
        public final VerificationTypeInfo[] locals;
        public final VerificationTypeInfo[] stack;

        public FullFrame(int tag, int delta, VerificationTypeInfo[] locals, VerificationTypeInfo[] stack) {
            super(tag);
            this.delta = delta;
            this.locals = locals;
            this.stack = stack;
        }

        @Override
        public int type() {
            return 255;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta + "/" + Arrays.toString(this.locals) + "/" + Arrays.toString(this.stack);
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            out.writeShort(this.delta);
            out.writeShort(this.locals.length);
            for (VerificationTypeInfo local : this.locals) {
                local.write(out, constant_pool);
            }
            out.writeShort(this.stack.length);
            for (VerificationTypeInfo stack_item : this.stack) {
                stack_item.write(out, constant_pool);
            }
        }

        @Override
        int value_length() {
            int value_length = 7;
            for (VerificationTypeInfo local : this.locals) {
                value_length += local.value_length();
            }
            for (VerificationTypeInfo stack_item : this.stack) {
                value_length += stack_item.value_length();
            }
            return value_length;
        }
    }

    public static class UninitializedVariableInfo
    extends VerificationTypeInfo {
        public final int offset;

        public UninitializedVariableInfo(int tag, int offset) {
            super(tag);
            this.offset = offset;
        }

        @Override
        public String toString() {
            return this.tag + ":" + this.offset;
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            out.writeShort(this.offset);
        }

        @Override
        int value_length() {
            return 3;
        }
    }

    public static class ObjectVariableInfo
    extends VerificationTypeInfo {
        public final String type;

        public ObjectVariableInfo(int tag, String type) {
            super(tag);
            this.type = type;
        }

        @Override
        public String toString() {
            return this.tag + ":" + this.type;
        }

        @Override
        void write(DataOutput out, ConstantPool constant_pool) throws IOException {
            out.writeByte(this.tag);
            int cpool_index = constant_pool.classInfo(this.type);
            out.writeShort(cpool_index);
        }

        @Override
        int value_length() {
            return 3;
        }
    }
}

