/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.txn.WriteLockInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Locker {
    private static final String DEBUG_NAME = Locker.class.getName();
    protected EnvironmentImpl envImpl;
    protected LockManager lockManager;
    protected long id;
    protected boolean readUncommittedDefault;
    protected boolean defaultNoWait;
    protected long lockTimeOutMillis;
    private long txnTimeOutMillis;
    private long txnStartMillis;
    private Lock waitingFor;
    protected Map deleteInfo;
    protected Map handleLockToHandleMap;
    protected Map handleToHandleLockMap;
    protected Thread thread;

    public Locker(EnvironmentImpl envImpl, boolean readUncommittedDefault, boolean noWait) throws DatabaseException {
        TxnManager txnManager = envImpl.getTxnManager();
        this.id = this.generateId(txnManager);
        this.envImpl = envImpl;
        this.lockManager = txnManager.getLockManager();
        this.readUncommittedDefault = readUncommittedDefault;
        this.waitingFor = null;
        this.defaultNoWait = noWait;
        this.lockTimeOutMillis = envImpl.getLockTimeout();
        this.txnTimeOutMillis = envImpl.getTxnTimeout();
        this.txnStartMillis = this.txnTimeOutMillis != 0L ? System.currentTimeMillis() : 0L;
        this.thread = Thread.currentThread();
    }

    Locker() {
    }

    protected abstract long generateId(TxnManager var1);

    public long getId() {
        return this.id;
    }

    public boolean getDefaultNoWait() {
        return this.defaultNoWait;
    }

    public synchronized long getLockTimeout() {
        return this.lockTimeOutMillis;
    }

    public synchronized void setLockTimeout(long timeOutMillis) {
        this.lockTimeOutMillis = timeOutMillis;
    }

    public synchronized void setTxnTimeout(long timeOutMillis) {
        this.txnTimeOutMillis = timeOutMillis;
        this.txnStartMillis = System.currentTimeMillis();
    }

    public boolean isReadUncommittedDefault() {
        return this.readUncommittedDefault;
    }

    Lock getWaitingFor() {
        return this.waitingFor;
    }

    void setWaitingFor(Lock lock) {
        this.waitingFor = lock;
    }

    void setOnlyAbortable() {
    }

    protected abstract void checkState(boolean var1) throws DatabaseException;

    abstract LockResult lockInternal(long var1, LockType var3, boolean var4, DatabaseImpl var5) throws DeadlockException, DatabaseException;

    public LockResult lock(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws LockNotGrantedException, DeadlockException, DatabaseException {
        LockResult result = this.lockInternal(nodeId, lockType, noWait, database);
        if (result.getLockGrant() == LockGrantType.DENIED) {
            throw new LockNotGrantedException("Non-blocking lock was denied.");
        }
        return result;
    }

    public LockResult nonBlockingLock(long nodeId, LockType lockType, DatabaseImpl database) throws DatabaseException {
        return this.lockInternal(nodeId, lockType, true, database);
    }

    public void releaseLock(long nodeId) throws DatabaseException {
        this.lockManager.release(nodeId, this);
        this.removeLock(nodeId);
    }

    public void demoteLock(long nodeId) throws DatabaseException {
        this.lockManager.demote(nodeId, this);
    }

    public abstract boolean isTransactional();

    public abstract boolean isSerializableIsolation();

    public abstract boolean isReadCommittedIsolation();

    public abstract Txn getTxnLocker();

    public abstract Locker newNonTxnLocker() throws DatabaseException;

    public abstract void releaseNonTxnLocks() throws DatabaseException;

    public boolean sharesLocksWith(Locker other) {
        if (other instanceof BuddyLocker) {
            BuddyLocker buddy = (BuddyLocker)other;
            return buddy.getBuddy() == this;
        }
        return false;
    }

    public abstract void operationEnd() throws DatabaseException;

    public abstract void operationEnd(boolean var1) throws DatabaseException;

    public abstract void setHandleLockOwner(boolean var1, Database var2, boolean var3) throws DatabaseException;

    public void operationEnd(OperationStatus status) throws DatabaseException {
        this.operationEnd(status == OperationStatus.SUCCESS);
    }

    public abstract void registerCursor(CursorImpl var1) throws DatabaseException;

    public abstract void unRegisterCursor(CursorImpl var1) throws DatabaseException;

    public abstract long getAbortLsn(long var1) throws DatabaseException;

    public abstract WriteLockInfo getWriteLockInfo(long var1) throws DatabaseException;

    public abstract void markDeleteAtTxnEnd(DatabaseImpl var1, boolean var2) throws DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteInfo(BIN bin, Key deletedKey) throws DatabaseException {
        Locker locker = this;
        synchronized (locker) {
            Long nodeId;
            BINReference binRef;
            if (this.deleteInfo == null) {
                this.deleteInfo = new HashMap();
            }
            if ((binRef = (BINReference)this.deleteInfo.get(nodeId = new Long(bin.getNodeId()))) == null) {
                binRef = bin.createReference();
                this.deleteInfo.put(nodeId, binRef);
            }
            binRef.addDeletedKey(deletedKey);
        }
    }

    abstract void addLock(Long var1, LockType var2, LockGrantType var3) throws DatabaseException;

    public abstract boolean createdNode(long var1) throws DatabaseException;

    abstract void removeLock(long var1) throws DatabaseException;

    abstract void moveWriteToReadLock(long var1, Lock var3);

    public abstract LockStats collectStats(LockStats var1) throws DatabaseException;

    boolean isTimedOut() throws DatabaseException {
        long diff;
        return this.txnStartMillis != 0L && (diff = System.currentTimeMillis() - this.txnStartMillis) > this.txnTimeOutMillis;
    }

    public long getTxnTimeOut() {
        return this.txnTimeOutMillis;
    }

    long getTxnStartMillis() {
        return this.txnStartMillis;
    }

    void unregisterHandle(Database dbHandle) {
        if (this.handleToHandleLockMap != null) {
            this.handleToHandleLockMap.remove(dbHandle);
        }
    }

    public void addToHandleMaps(Long handleLockId, Database databaseHandle) {
        HashSet<Database> dbHandleSet = null;
        if (this.handleLockToHandleMap == null) {
            this.handleLockToHandleMap = new Hashtable();
            this.handleToHandleLockMap = new Hashtable();
        } else {
            dbHandleSet = (HashSet<Database>)this.handleLockToHandleMap.get(handleLockId);
        }
        if (dbHandleSet == null) {
            dbHandleSet = new HashSet<Database>();
            this.handleLockToHandleMap.put(handleLockId, dbHandleSet);
        }
        dbHandleSet.add(databaseHandle);
        this.handleToHandleLockMap.put(databaseHandle, handleLockId);
    }

    public boolean isHandleLockTransferrable() {
        return true;
    }

    void transferHandleLockToHandle(Database dbHandle) throws DatabaseException {
        BasicLocker holderTxn = new BasicLocker(this.envImpl);
        this.transferHandleLock(dbHandle, holderTxn, true);
    }

    public void transferHandleLock(Database dbHandle, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        Long handleLockId;
        if (DbInternal.dbGetDatabaseImpl(dbHandle) != null && (handleLockId = (Long)this.handleToHandleLockMap.get(dbHandle)) != null) {
            long nodeId = handleLockId;
            this.lockManager.transfer(nodeId, this, destLocker, demoteToRead);
            destLocker.addToHandleMaps(handleLockId, dbHandle);
            Set dbHandleSet = (Set)this.handleLockToHandleMap.get(handleLockId);
            Iterator iter = dbHandleSet.iterator();
            while (iter.hasNext()) {
                if ((Database)iter.next() != dbHandle) continue;
                iter.remove();
                break;
            }
            if (dbHandleSet.size() == 0) {
                this.handleLockToHandleMap.remove(handleLockId);
            }
            DbInternal.dbSetHandleLocker(dbHandle, destLocker);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return Long.toString(this.id) + "_" + (this.thread == null ? "" : this.thread.getName()) + "_" + className;
    }

    public void dumpLockTable() throws DatabaseException {
        this.lockManager.dump();
    }
}

