/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FSyncManager;
import com.sleepycat.je.log.FileHandle;
import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.JEFileFilter;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.HexFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class FileManager {
    static boolean IO_EXCEPTION_TESTING;
    private static final String DEBUG_NAME;
    private static long writeCount;
    private static long stopOnWriteCount;
    public static final String JE_SUFFIX = ".jdb";
    public static final String DEL_SUFFIX = ".del";
    public static final String BAD_SUFFIX = ".bad";
    private static final String LOCK_FILE = "je.lck";
    static final String[] DEL_SUFFIXES;
    static final String[] JE_SUFFIXES;
    private static final String[] JE_AND_DEL_SUFFIXES;
    private boolean syncAtFileEnd = true;
    private EnvironmentImpl envImpl;
    private long maxFileSize;
    private File dbEnvHome;
    private boolean includeDeletedFiles = false;
    private FileCache fileCache;
    private Latch fileCacheLatch;
    private RandomAccessFile lockFile;
    private FileChannel channel;
    private FileLock envLock;
    private FileLock exclLock;
    private boolean readOnly;
    private long currentFileNum;
    private long nextAvailableLsn;
    private long lastUsedLsn;
    private long prevOffset;
    private boolean forceNewFile;
    private long savedCurrentFileNum;
    private long savedNextAvailableLsn;
    private long savedLastUsedLsn;
    private long savedPrevOffset;
    private boolean savedForceNewFile;
    private LogEndFileDescriptor endOfLog;
    private FSyncManager syncManager;
    private Map perFileLastUsedLsn;
    private boolean useNIO;
    private long chunkedNIOSize = 0L;
    static boolean RUNRECOVERY_EXCEPTION_TESTING;
    private static final int RUNRECOVERY_EXCEPTION_MAX = 100;
    private int runRecoveryExceptionCounter = 0;
    private boolean runRecoveryExceptionThrown = false;
    private Random runRecoveryExceptionRandom = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileManager(EnvironmentImpl envImpl, File dbEnvHome, boolean readOnly) throws DatabaseException {
        this.envImpl = envImpl;
        this.dbEnvHome = dbEnvHome;
        this.readOnly = readOnly;
        DbConfigManager configManager = envImpl.getConfigManager();
        this.maxFileSize = configManager.getLong(EnvironmentParams.LOG_FILE_MAX);
        this.useNIO = configManager.getBoolean(EnvironmentParams.LOG_USE_NIO);
        this.chunkedNIOSize = configManager.getLong(EnvironmentParams.LOG_CHUNKED_NIO);
        boolean directNIO = configManager.getBoolean(EnvironmentParams.LOG_DIRECT_NIO);
        if (!this.useNIO && (this.chunkedNIOSize > 0L || directNIO)) {
            throw new IllegalArgumentException(EnvironmentParams.LOG_USE_NIO.getName() + " is false and therefore " + EnvironmentParams.LOG_DIRECT_NIO.getName() + " or " + EnvironmentParams.LOG_CHUNKED_NIO.getName() + " may not be used.");
        }
        if (!envImpl.isMemOnly()) {
            if (!dbEnvHome.exists()) {
                throw new LogException("Environment home " + dbEnvHome + " doesn't exist");
            }
            this.lockEnvironment(readOnly, false);
        }
        this.fileCache = new FileCache(configManager);
        this.fileCacheLatch = LatchSupport.makeLatch(DEBUG_NAME + "_fileCache", envImpl);
        this.currentFileNum = 0L;
        this.nextAvailableLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
        this.lastUsedLsn = -1L;
        this.perFileLastUsedLsn = new HashMap();
        this.prevOffset = 0L;
        this.endOfLog = new LogEndFileDescriptor();
        this.forceNewFile = false;
        this.saveLastPosition();
        String stopOnWriteProp = System.getProperty("je.debug.stopOnWrite");
        if (stopOnWriteProp != null) {
            stopOnWriteCount = Long.parseLong(stopOnWriteProp);
        }
        this.syncManager = new FSyncManager(envImpl);
    }

    public void setLastPosition(long nextAvailableLsn, long lastUsedLsn, long prevOffset) {
        this.lastUsedLsn = lastUsedLsn;
        this.perFileLastUsedLsn.put(new Long(DbLsn.getFileNumber(lastUsedLsn)), new Long(lastUsedLsn));
        this.nextAvailableLsn = nextAvailableLsn;
        this.currentFileNum = DbLsn.getFileNumber(this.nextAvailableLsn);
        this.prevOffset = prevOffset;
        this.saveLastPosition();
    }

    void saveLastPosition() {
        this.savedNextAvailableLsn = this.nextAvailableLsn;
        this.savedLastUsedLsn = this.lastUsedLsn;
        this.savedPrevOffset = this.prevOffset;
        this.savedForceNewFile = this.forceNewFile;
        this.savedCurrentFileNum = this.currentFileNum;
    }

    void restoreLastPosition() {
        this.nextAvailableLsn = this.savedNextAvailableLsn;
        this.lastUsedLsn = this.savedLastUsedLsn;
        this.prevOffset = this.savedPrevOffset;
        this.forceNewFile = this.savedForceNewFile;
        this.currentFileNum = this.savedCurrentFileNum;
    }

    public void setSyncAtFileEnd(boolean sync) {
        this.syncAtFileEnd = sync;
    }

    public Long getFirstFileNum() {
        return this.getFileNum(true);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public Long getLastFileNum() {
        return this.getFileNum(false);
    }

    public long getCurrentFileNum() {
        return this.currentFileNum;
    }

    public void setIncludeDeletedFiles(boolean includeDeletedFiles) {
        this.includeDeletedFiles = includeDeletedFiles;
    }

    public Long[] getAllFileNumbers() {
        String[] names = this.listFiles(JE_SUFFIXES);
        Long[] nums = new Long[names.length];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = this.getNumFromName(names[i]);
        }
        return nums;
    }

    public Long getFollowingFileNum(long currentFileNum, boolean forward) {
        Object[] names = this.listFiles(JE_SUFFIXES);
        String searchName = FileManager.getFileName(currentFileNum, JE_SUFFIX);
        int foundIdx = Arrays.binarySearch(names, searchName);
        boolean foundTarget = false;
        if (foundIdx >= 0) {
            foundIdx = forward ? ++foundIdx : --foundIdx;
        } else {
            foundIdx = Math.abs(foundIdx + 1);
            if (!forward) {
                --foundIdx;
            }
        }
        if (forward && foundIdx < names.length) {
            foundTarget = true;
        } else if (!forward && foundIdx > -1) {
            foundTarget = true;
        }
        if (foundTarget) {
            return this.getNumFromName((String)names[foundIdx]);
        }
        return null;
    }

    public boolean filesExist() {
        String[] names = this.listFiles(JE_SUFFIXES);
        return names.length != 0;
    }

    private Long getFileNum(boolean first) {
        String[] names = this.listFiles(JE_SUFFIXES);
        if (names.length == 0) {
            return null;
        }
        int index = 0;
        if (!first) {
            index = names.length - 1;
        }
        return this.getNumFromName(names[index]);
    }

    public Long getNumFromName(String fileName) {
        String fileNumber = fileName.substring(0, fileName.indexOf("."));
        return new Long(Long.parseLong(fileNumber, 16));
    }

    public String[] listFiles(String[] suffixes) {
        Object[] fileNames = this.dbEnvHome.list(new JEFileFilter(suffixes));
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    public String[] listFiles(long minFileNumber, long maxFileNumber) {
        Object[] fileNames = this.dbEnvHome.list(new JEFileFilter(JE_SUFFIXES, minFileNumber, maxFileNumber));
        Arrays.sort(fileNames);
        return fileNames;
    }

    public static String[] listFiles(File envDirFile, String[] suffixes) {
        Object[] fileNames = envDirFile.list(new JEFileFilter(suffixes));
        if (fileNames != null) {
            Arrays.sort(fileNames);
        } else {
            fileNames = new String[]{};
        }
        return fileNames;
    }

    String[] getFullFileNames(long fileNum) {
        if (this.includeDeletedFiles) {
            int nSuffixes = JE_AND_DEL_SUFFIXES.length;
            String[] ret = new String[nSuffixes];
            for (int i = 0; i < nSuffixes; ++i) {
                ret[i] = this.getFullFileName(FileManager.getFileName(fileNum, JE_AND_DEL_SUFFIXES[i]));
            }
            return ret;
        }
        return new String[]{this.getFullFileName(FileManager.getFileName(fileNum, JE_SUFFIX))};
    }

    public String getFullFileName(long fileNum, String suffix) {
        return this.getFullFileName(FileManager.getFileName(fileNum, suffix));
    }

    private String getFullFileName(String fileName) {
        return this.dbEnvHome + File.separator + fileName;
    }

    public static String getFileName(long fileNum, String suffix) {
        return HexFormatter.formatLong(fileNum).substring(10) + suffix;
    }

    public void renameFile(long fileNum, String newSuffix) throws DatabaseException, IOException {
        int repeatNum = 0;
        boolean renamed = false;
        while (!renamed) {
            String newName;
            File targetFile;
            String generation = "";
            if (repeatNum > 0) {
                generation = "." + repeatNum;
            }
            if ((targetFile = new File(newName = this.getFullFileName(FileManager.getFileName(fileNum, newSuffix) + generation))).exists()) {
                ++repeatNum;
                continue;
            }
            String oldFileName = this.getFullFileNames(fileNum)[0];
            this.clearFileCache(fileNum);
            File oldFile = new File(oldFileName);
            if (oldFile.renameTo(targetFile)) {
                renamed = true;
                continue;
            }
            throw new LogException("Couldn't rename " + oldFileName + " to " + newName);
        }
    }

    public void deleteFile(long fileNum) throws DatabaseException, IOException {
        String fileName = this.getFullFileNames(fileNum)[0];
        this.clearFileCache(fileNum);
        File file = new File(fileName);
        boolean done = file.delete();
        if (!done) {
            throw new LogException("Couldn't delete " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileHandle getFileHandle(long fileNum) throws LogException, DatabaseException {
        Long fileId = new Long(fileNum);
        FileHandle fileHandle = null;
        while (true) {
            if ((fileHandle = this.fileCache.get(fileId)) == null) {
                this.fileCacheLatch.acquire();
                try {
                    fileHandle = this.fileCache.get(fileId);
                    if (fileHandle == null) {
                        fileHandle = this.makeFileHandle(fileNum, FileMode.READ_MODE);
                        this.fileCache.add(fileId, fileHandle);
                    }
                }
                finally {
                    this.fileCacheLatch.release();
                }
            }
            fileHandle.latch();
            if (fileHandle.getFile() != null) break;
            fileHandle.release();
        }
        return fileHandle;
    }

    private FileHandle makeFileHandle(long fileNum, FileMode mode) throws DatabaseException {
        String[] fileNames = this.getFullFileNames(fileNum);
        RandomAccessFile newFile = null;
        String fileName = null;
        try {
            FileNotFoundException FNFE = null;
            for (int i = 0; i < fileNames.length; ++i) {
                fileName = fileNames[i];
                try {
                    newFile = new RandomAccessFile(fileName, mode.getModeValue());
                    break;
                }
                catch (FileNotFoundException e) {
                    if (FNFE != null) continue;
                    FNFE = e;
                    continue;
                }
            }
            if (newFile == null) {
                throw FNFE;
            }
            boolean oldHeaderVersion = false;
            if (newFile.length() == 0L) {
                if (mode == FileMode.READWRITE_MODE) {
                    long lastLsn = DbLsn.longToLsn((Long)this.perFileLastUsedLsn.remove(new Long(fileNum - 1L)));
                    long headerPrevOffset = 0L;
                    if (lastLsn != -1L) {
                        headerPrevOffset = DbLsn.getFileOffset(lastLsn);
                    }
                    FileHeader fileHeader = new FileHeader(fileNum, headerPrevOffset);
                    this.writeFileHeader(newFile, fileName, fileHeader);
                }
            } else {
                oldHeaderVersion = this.readAndValidateFileHeader(newFile, fileName, fileNum);
            }
            return new FileHandle(newFile, fileName, this.envImpl, oldHeaderVersion);
        }
        catch (FileNotFoundException e) {
            throw new LogFileNotFoundException("Couldn't open file " + fileName + ": " + e.getMessage());
        }
        catch (DbChecksumException e) {
            this.closeFileInErrorCase(newFile);
            throw new DbChecksumException(this.envImpl, "Couldn't open file " + fileName, e);
        }
        catch (Throwable t) {
            this.closeFileInErrorCase(newFile);
            throw new DatabaseException("Couldn't open file " + fileName + ": " + t, t);
        }
    }

    private void closeFileInErrorCase(RandomAccessFile file) {
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean readAndValidateFileHeader(RandomAccessFile file, String fileName, long fileNum) throws DatabaseException, IOException {
        LogManager logManager = this.envImpl.getLogManager();
        LogEntry headerEntry = logManager.getLogEntry(DbLsn.makeLsn(fileNum, 0L), file);
        FileHeader header = (FileHeader)headerEntry.getMainItem();
        return header.validate(fileName, fileNum);
    }

    private void writeFileHeader(RandomAccessFile file, String fileName, FileHeader header) throws DatabaseException, IOException {
        int bytesWritten;
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        SingleItemEntry headerLogEntry = new SingleItemEntry(LogEntryType.LOG_FILE_HEADER, header);
        ByteBuffer headerBuf = this.envImpl.getLogManager().putIntoBuffer(headerLogEntry, 0L);
        if (++writeCount >= stopOnWriteCount) {
            Runtime.getRuntime().halt(255);
        }
        try {
            if (RUNRECOVERY_EXCEPTION_TESTING) {
                this.generateRunRecoveryException(file, headerBuf, 0L);
            }
            bytesWritten = this.writeToFile(file, headerBuf, 0L);
        }
        catch (ClosedChannelException e) {
            throw new RunRecoveryException(this.envImpl, "Channel closed, may be due to thread interrupt", e);
        }
        catch (IOException e) {
            throw new RunRecoveryException(this.envImpl, "IOException caught: " + e);
        }
        if (bytesWritten != headerLogEntry.getSize() + 14) {
            throw new LogException("File " + fileName + " was created with an incomplete header. Only " + bytesWritten + " bytes were written.");
        }
    }

    long getFileHeaderPrevOffset(long fileNum) throws IOException, DatabaseException {
        LogEntry headerEntry = this.envImpl.getLogManager().getLogEntry(DbLsn.makeLsn(fileNum, 0L));
        FileHeader header = (FileHeader)headerEntry.getMainItem();
        return header.getLastEntryInPrevFileOffset();
    }

    long getPrevEntryOffset() {
        return this.prevOffset;
    }

    boolean bumpLsn(long size) {
        this.saveLastPosition();
        boolean flippedFiles = false;
        if (this.forceNewFile || DbLsn.getFileOffset(this.nextAvailableLsn) + size > this.maxFileSize) {
            this.forceNewFile = false;
            ++this.currentFileNum;
            if (this.lastUsedLsn != -1L) {
                this.perFileLastUsedLsn.put(new Long(DbLsn.getFileNumber(this.lastUsedLsn)), new Long(this.lastUsedLsn));
            }
            this.prevOffset = 0L;
            this.lastUsedLsn = DbLsn.makeLsn(this.currentFileNum, FileManager.firstLogEntryOffset());
            flippedFiles = true;
        } else {
            this.prevOffset = this.lastUsedLsn == -1L ? 0L : DbLsn.getFileOffset(this.lastUsedLsn);
            this.lastUsedLsn = this.nextAvailableLsn;
        }
        this.nextAvailableLsn = DbLsn.makeLsn(DbLsn.getFileNumber(this.lastUsedLsn), DbLsn.getFileOffset(this.lastUsedLsn) + size);
        return flippedFiles;
    }

    void writeLogBuffer(LogBuffer fullBuffer) throws DatabaseException {
        this.envImpl.checkIfInvalid();
        if (this.envImpl.mayNotWrite()) {
            return;
        }
        long firstLsn = fullBuffer.getFirstLsn();
        if (firstLsn != -1L) {
            RandomAccessFile file = this.endOfLog.getWritableFile(DbLsn.getFileNumber(firstLsn));
            ByteBuffer data = fullBuffer.getDataBuffer();
            if (++writeCount >= stopOnWriteCount) {
                Runtime.getRuntime().halt(255);
            }
            try {
                if (!$assertionsDisabled && !fullBuffer.getRewriteAllowed() && DbLsn.getFileOffset(firstLsn) < file.length() && file.length() != (long)FileManager.firstLogEntryOffset()) {
                    throw new AssertionError((Object)("FileManager would overwrite non-empty file 0x" + Long.toHexString(DbLsn.getFileNumber(firstLsn)) + " lsnOffset=0x" + Long.toHexString(DbLsn.getFileOffset(firstLsn)) + " fileLength=0x" + Long.toHexString(file.length())));
                }
                if (IO_EXCEPTION_TESTING) {
                    throw new IOException("generated for testing");
                }
                if (RUNRECOVERY_EXCEPTION_TESTING) {
                    this.generateRunRecoveryException(file, data, DbLsn.getFileOffset(firstLsn));
                }
                this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn));
            }
            catch (ClosedChannelException e) {
                throw new RunRecoveryException(this.envImpl, "File closed, may be due to thread interrupt", e);
            }
            catch (IOException IOE) {
                this.abortCommittedTxns(data);
                try {
                    if (IO_EXCEPTION_TESTING) {
                        throw new IOException("generated for testing");
                    }
                    this.writeToFile(file, data, DbLsn.getFileOffset(firstLsn));
                }
                catch (IOException IOE2) {
                    fullBuffer.setRewriteAllowed();
                    throw new DatabaseException(IOE2);
                }
            }
            if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeToFile(RandomAccessFile file, ByteBuffer data, long destOffset) throws IOException, DatabaseException {
        int totalBytesWritten = 0;
        if (this.useNIO) {
            FileChannel channel = file.getChannel();
            if (this.chunkedNIOSize > 0L) {
                ByteBuffer useData = data.duplicate();
                int originalLimit = useData.limit();
                useData.limit(useData.position());
                while (useData.limit() < originalLimit) {
                    useData.limit((int)Math.min((long)useData.limit() + this.chunkedNIOSize, (long)originalLimit));
                    int bytesWritten = channel.write(useData, destOffset);
                    destOffset += (long)bytesWritten;
                    totalBytesWritten += bytesWritten;
                }
            } else {
                totalBytesWritten = channel.write(data, destOffset);
            }
        } else {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                if (!$assertionsDisabled && !data.hasArray()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && data.arrayOffset() != 0) {
                    throw new AssertionError();
                }
                int pos = data.position();
                int size = data.limit() - pos;
                file.seek(destOffset);
                file.write(data.array(), pos, size);
                data.position(pos + size);
                totalBytesWritten = size;
            }
        }
        return totalBytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFromFile(RandomAccessFile file, ByteBuffer readBuffer, long offset) throws IOException {
        if (this.useNIO) {
            FileChannel channel = file.getChannel();
            if (this.chunkedNIOSize > 0L) {
                int readLength = readBuffer.limit();
                long currentPosition = offset;
                while (readBuffer.position() < readLength) {
                    readBuffer.limit((int)Math.min((long)readBuffer.limit() + this.chunkedNIOSize, (long)readLength));
                    int bytesRead = channel.read(readBuffer, currentPosition);
                    if (bytesRead >= 1) {
                        currentPosition += (long)bytesRead;
                        continue;
                    }
                    break;
                }
            } else {
                channel.read(readBuffer, offset);
            }
        } else {
            RandomAccessFile randomAccessFile = file;
            synchronized (randomAccessFile) {
                if (!$assertionsDisabled && !readBuffer.hasArray()) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && readBuffer.arrayOffset() != 0) {
                    throw new AssertionError();
                }
                int pos = readBuffer.position();
                int size = readBuffer.limit() - pos;
                file.seek(offset);
                int bytesRead = file.read(readBuffer.array(), pos, size);
                if (bytesRead > 0) {
                    readBuffer.position(pos + bytesRead);
                }
            }
        }
    }

    private void abortCommittedTxns(ByteBuffer data) throws DatabaseException {
        byte commitType = LogEntryType.LOG_TXN_COMMIT.getTypeNum();
        byte abortType = LogEntryType.LOG_TXN_ABORT.getTypeNum();
        data.position(0);
        while (data.remaining() > 0) {
            int recStartPos = data.position();
            LogEntryHeader header = new LogEntryHeader(this.envImpl, data, false);
            if (header.getType() == commitType) {
                header.convertCommitToAbort(data);
            }
            data.position(recStartPos + header.getSize() + header.getItemSize());
        }
        data.position(0);
    }

    void syncLogEnd() throws DatabaseException {
        try {
            this.endOfLog.force();
        }
        catch (IOException e) {
            throw new DatabaseException(e);
        }
    }

    void syncLogEndAndFinishFile() throws DatabaseException, IOException {
        if (this.syncAtFileEnd) {
            this.syncLogEnd();
        }
        this.endOfLog.close();
    }

    void groupSync() throws DatabaseException {
        this.syncManager.fsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException, DatabaseException {
        this.fileCacheLatch.acquire();
        try {
            this.fileCache.clear();
        }
        finally {
            this.fileCacheLatch.release();
        }
        this.endOfLog.close();
    }

    public void close() throws IOException, DatabaseException {
        if (this.envLock != null) {
            this.envLock.release();
        }
        if (this.exclLock != null) {
            this.exclLock.release();
        }
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.lockFile != null) {
            this.lockFile.close();
            this.lockFile = null;
        }
    }

    public boolean lockEnvironment(boolean readOnly, boolean exclusive) throws DatabaseException {
        try {
            if (this.checkEnvHomePermissions(readOnly)) {
                return true;
            }
            if (this.lockFile == null) {
                this.lockFile = new RandomAccessFile(new File(this.dbEnvHome, LOCK_FILE), FileMode.READWRITE_MODE.getModeValue());
            }
            this.channel = this.lockFile.getChannel();
            boolean throwIt = false;
            try {
                if (exclusive) {
                    this.exclLock = this.channel.tryLock(1L, 1L, false);
                    return this.exclLock != null;
                }
                this.envLock = readOnly ? this.channel.tryLock(1L, 1L, true) : this.channel.tryLock(0L, 1L, false);
                if (this.envLock == null) {
                    throwIt = true;
                }
            }
            catch (OverlappingFileLockException e) {
                throwIt = true;
            }
            if (throwIt) {
                throw new LogException("A je.lck file exists in " + this.dbEnvHome.getAbsolutePath() + " The environment can not be locked for " + (readOnly ? "shared" : "single writer") + " access.");
            }
        }
        catch (IOException IOE) {
            throw new LogException(IOE.toString());
        }
        return true;
    }

    public void releaseExclusiveLock() throws DatabaseException {
        try {
            if (this.exclLock != null) {
                this.exclLock.release();
            }
        }
        catch (IOException IOE) {
            throw new DatabaseException(IOE);
        }
    }

    public boolean checkEnvHomePermissions(boolean readOnly) throws DatabaseException {
        boolean envDirIsReadOnly;
        boolean bl = envDirIsReadOnly = !this.dbEnvHome.canWrite();
        if (envDirIsReadOnly && !readOnly) {
            throw new DatabaseException("The Environment directory " + this.dbEnvHome.getAbsolutePath() + " is not writable, but the " + "Environment was opened for read-write access.");
        }
        return envDirIsReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateLog(long fileNum, long offset) throws IOException, DatabaseException {
        FileHandle handle = this.makeFileHandle(fileNum, FileMode.READWRITE_MODE);
        RandomAccessFile file = handle.getFile();
        try {
            file.getChannel().truncate(offset);
        }
        finally {
            file.close();
        }
        if (handle.isOldHeaderVersion()) {
            this.forceNewFile = true;
        }
    }

    void forceNewLogFile() {
        this.forceNewFile = true;
    }

    public static int firstLogEntryOffset() {
        return FileHeader.entrySize() + 14;
    }

    public long getNextLsn() {
        return this.nextAvailableLsn;
    }

    public long getLastUsedLsn() {
        return this.lastUsedLsn;
    }

    public long getNFSyncs() {
        return this.syncManager.getNFSyncs();
    }

    public long getNFSyncRequests() {
        return this.syncManager.getNFSyncRequests();
    }

    public long getNFSyncTimeouts() {
        return this.syncManager.getNTimeouts();
    }

    void loadStats(StatsConfig config, EnvironmentStats stats) throws DatabaseException {
        this.syncManager.loadStats(config, stats);
    }

    Set getCacheKeys() {
        return this.fileCache.getCacheKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFileCache(long fileNum) throws IOException, DatabaseException {
        this.fileCacheLatch.acquire();
        try {
            this.fileCache.remove(fileNum);
        }
        finally {
            this.fileCacheLatch.release();
        }
    }

    private void generateRunRecoveryException(RandomAccessFile file, ByteBuffer data, long destOffset) throws DatabaseException, IOException {
        if (this.runRecoveryExceptionThrown) {
            try {
                throw new Exception("Write after RunRecoveryException");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++this.runRecoveryExceptionCounter;
        if (this.runRecoveryExceptionCounter >= 100) {
            this.runRecoveryExceptionCounter = 0;
        }
        if (this.runRecoveryExceptionRandom == null) {
            this.runRecoveryExceptionRandom = new Random(System.currentTimeMillis());
        }
        if (this.runRecoveryExceptionCounter == this.runRecoveryExceptionRandom.nextInt(100)) {
            int len = this.runRecoveryExceptionRandom.nextInt(data.remaining());
            if (len > 0) {
                byte[] a = new byte[len];
                data.get(a, 0, len);
                ByteBuffer buf = ByteBuffer.wrap(a);
                this.writeToFile(file, buf, destOffset);
            }
            this.runRecoveryExceptionThrown = true;
            throw new RunRecoveryException(this.envImpl, "Randomly generated for testing");
        }
    }

    static {
        $assertionsDisabled = !FileManager.class.desiredAssertionStatus();
        IO_EXCEPTION_TESTING = false;
        DEBUG_NAME = FileManager.class.getName();
        writeCount = 0L;
        stopOnWriteCount = Long.MAX_VALUE;
        DEL_SUFFIXES = new String[]{DEL_SUFFIX};
        JE_SUFFIXES = new String[]{JE_SUFFIX};
        JE_AND_DEL_SUFFIXES = new String[]{JE_SUFFIX, DEL_SUFFIX};
        RUNRECOVERY_EXCEPTION_TESTING = false;
    }

    class LogEndFileDescriptor {
        private RandomAccessFile endOfLogRWFile = null;
        private RandomAccessFile endOfLogSyncFile = null;
        private Object fsyncFileSynchronizer = new Object();
        static final /* synthetic */ boolean $assertionsDisabled;

        LogEndFileDescriptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RandomAccessFile getWritableFile(long fileNumber) throws RunRecoveryException {
            try {
                if (this.endOfLogRWFile == null) {
                    this.endOfLogRWFile = FileManager.this.makeFileHandle(fileNumber, FileMode.READWRITE_MODE).getFile();
                    Object object = this.fsyncFileSynchronizer;
                    synchronized (object) {
                        this.endOfLogSyncFile = FileManager.this.makeFileHandle(fileNumber, FileMode.READWRITE_MODE).getFile();
                    }
                }
                return this.endOfLogRWFile;
            }
            catch (Exception e) {
                throw new RunRecoveryException(FileManager.this.envImpl, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void force() throws DatabaseException, IOException {
            Object object = this.fsyncFileSynchronizer;
            synchronized (object) {
                RandomAccessFile file = this.endOfLogSyncFile;
                if (file != null) {
                    FileChannel channel = file.getChannel();
                    try {
                        channel.force(false);
                    }
                    catch (ClosedChannelException e) {
                        throw new RunRecoveryException(FileManager.this.envImpl, "Channel closed, may be due to thread interrupt", e);
                    }
                    if (!$assertionsDisabled && !EnvironmentImpl.maybeForceYield()) {
                        throw new AssertionError();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() throws IOException {
            IOException firstException = null;
            if (this.endOfLogRWFile != null) {
                RandomAccessFile file = this.endOfLogRWFile;
                this.endOfLogRWFile = null;
                try {
                    file.close();
                }
                catch (IOException e) {
                    firstException = e;
                }
            }
            Object object = this.fsyncFileSynchronizer;
            synchronized (object) {
                if (this.endOfLogSyncFile != null) {
                    RandomAccessFile file = this.endOfLogSyncFile;
                    this.endOfLogSyncFile = null;
                    file.close();
                }
                if (firstException != null) {
                    throw firstException;
                }
            }
        }

        static {
            $assertionsDisabled = !(class$com$sleepycat$je$log$FileManager == null ? (class$com$sleepycat$je$log$FileManager = FileManager.class$("com.sleepycat.je.log.FileManager")) : class$com$sleepycat$je$log$FileManager).desiredAssertionStatus();
        }
    }

    private static class FileCache {
        private Map fileMap = new Hashtable();
        private LinkedList fileList = new LinkedList();
        private int fileCacheSize;

        FileCache(DbConfigManager configManager) throws DatabaseException {
            this.fileCacheSize = configManager.getInt(EnvironmentParams.LOG_FILE_CACHE_SIZE);
        }

        private FileHandle get(Long fileId) {
            return (FileHandle)this.fileMap.get(fileId);
        }

        private void add(Long fileId, FileHandle fileHandle) throws DatabaseException {
            if (this.fileList.size() >= this.fileCacheSize) {
                Iterator iter = this.fileList.iterator();
                while (iter.hasNext()) {
                    Long evictId = (Long)iter.next();
                    FileHandle evictTarget = (FileHandle)this.fileMap.get(evictId);
                    if (!evictTarget.latchNoWait()) continue;
                    try {
                        this.fileMap.remove(evictId);
                        iter.remove();
                        evictTarget.close();
                        break;
                    }
                    catch (IOException e) {
                        throw new DatabaseException(e);
                    }
                    finally {
                        evictTarget.release();
                    }
                }
            }
            this.fileList.add(fileId);
            this.fileMap.put(fileId, fileHandle);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remove(long fileNum) throws IOException, DatabaseException {
            Iterator iter = this.fileList.iterator();
            while (iter.hasNext()) {
                Long evictId = (Long)iter.next();
                if (evictId != fileNum) continue;
                FileHandle evictTarget = (FileHandle)this.fileMap.get(evictId);
                try {
                    evictTarget.latch();
                    this.fileMap.remove(evictId);
                    iter.remove();
                    evictTarget.close();
                }
                finally {
                    evictTarget.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() throws IOException, DatabaseException {
            Iterator iter = this.fileMap.values().iterator();
            while (iter.hasNext()) {
                FileHandle fileHandle = (FileHandle)iter.next();
                try {
                    fileHandle.latch();
                    fileHandle.close();
                    iter.remove();
                }
                finally {
                    fileHandle.release();
                }
            }
            this.fileMap.clear();
            this.fileList.clear();
        }

        private Set getCacheKeys() {
            return this.fileMap.keySet();
        }
    }

    public static class FileMode {
        public static final FileMode READ_MODE = new FileMode("r");
        public static final FileMode READWRITE_MODE = new FileMode("rw");
        private String fileModeValue;

        private FileMode(String fileModeValue) {
            this.fileModeValue = fileModeValue;
        }

        public String getModeValue() {
            return this.fileModeValue;
        }
    }
}

