/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;

public class RunRecoveryException
extends DatabaseException {
    private boolean alreadyThrown = false;

    RunRecoveryException() {
    }

    public RunRecoveryException(EnvironmentImpl env) {
        this.invalidate(env);
    }

    public RunRecoveryException(EnvironmentImpl env, Throwable t) {
        super(t);
        this.invalidate(env);
    }

    public RunRecoveryException(EnvironmentImpl env, String message) {
        super(message);
        this.invalidate(env);
    }

    public RunRecoveryException(EnvironmentImpl env, String message, Throwable t) {
        super(message, t);
        this.invalidate(env);
    }

    private void invalidate(EnvironmentImpl env) {
        if (env != null) {
            env.invalidate(this);
        }
    }

    public void setAlreadyThrown() {
        this.alreadyThrown = true;
    }

    public String toString() {
        if (this.alreadyThrown) {
            return "Environment invalid because of previous exception: " + super.toString();
        }
        return super.toString();
    }
}

