/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import java.io.IOException;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SortedAndPaginatedDataSource
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SortedAndPaginatedDataSource.class);
    private final ExpressionResolver expressionResolver;
    private static final String PARAMETER_SORT_NAME = "sortName";
    private static final String PARAMETER_SORT_DIRECTION = "sortDir";

    SortedAndPaginatedDataSource(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
    }

    protected OffsetAndLimit getOffsetAndLimit(SlingHttpServletRequest request) {
        Config dsCfg = new Config(request.getResource().getChild("datasource"));
        ExpressionHelper expressionHelper = new ExpressionHelper(this.expressionResolver, request);
        if (dsCfg == null) {
            LOG.warn("No datasource configuration found for resource: {}", (Object)request.getResource().getPath());
            return new OffsetAndLimit(0, -1);
        }
        if (dsCfg.get("limit").isBlank() || dsCfg.get("offset").isBlank()) {
            LOG.warn("No limit or offset configured for datasource: {}", (Object)request.getResource().getPath());
            return new OffsetAndLimit(0, -1);
        }
        Integer limit = (Integer)expressionHelper.get(dsCfg.get("limit"), Integer.class);
        Integer offset = (Integer)expressionHelper.get(dsCfg.get("offset"), Integer.class);
        if (limit == null || offset == null) {
            offset = 0;
            limit = -1;
        }
        return new OffsetAndLimit(offset, limit);
    }

    protected Optional<Comparator<Resource>> getComparator(SlingHttpServletRequest request) {
        String sortName = request.getParameter(PARAMETER_SORT_NAME);
        boolean isAscending = "asc".equals(request.getParameter(PARAMETER_SORT_DIRECTION));
        if (sortName == null || sortName.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getComparator(request.getLocale(), sortName, isAscending));
    }

    protected Comparator<Resource> getComparator(Locale locale, String sortName, boolean isAscending) {
        return SortedAndPaginatedDataSource.getComparator(this.getResourceValueForSortName(sortName), locale, isAscending);
    }

    public abstract Function<Resource, Comparable<?>> getResourceValueForSortName(String var1);

    private static Comparator<Resource> getComparator(final Function<Resource, Comparable<?>> resourceValueExtractor, Locale locale, final boolean isAscending) {
        final Collator collator = Collator.getInstance(locale);
        return new Comparator<Resource>(){

            @Override
            public int compare(Resource o1, Resource o2) {
                Comparable value1 = (Comparable)resourceValueExtractor.apply(o1);
                Comparable value2 = (Comparable)resourceValueExtractor.apply(o2);
                int result = value1 == null ? (value2 == null ? 0 : -1) : (value2 == null ? 1 : (value1 instanceof String && value2 instanceof String ? collator.compare((String)((Object)value1), (String)((Object)value2)) : value1.compareTo(value2)));
                if (!isAscending) {
                    result = -result;
                }
                return result;
            }
        };
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        DataSource dataSource;
        OffsetAndLimit offsetAndLimit = this.getOffsetAndLimit(request);
        Optional<Comparator<Resource>> comparator = this.getComparator(request);
        try {
            Collection<Resource> resources = this.populateResources(request, response, request.getResourceResolver(), offsetAndLimit.getOffset(), offsetAndLimit.getLimit(), comparator);
            dataSource = new SimpleDataSource(resources.iterator());
        }
        catch (Exception e) {
            LOG.error("Error creating dictionary data source", (Throwable)e);
            dataSource = EmptyDataSource.instance();
        }
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }

    protected Collection<Resource> populateResources(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceResolver resolver, int offset, int limit, Optional<Comparator<Resource>> comparator) throws DictionaryException, ServletException, IOException {
        List<Object> resourceList = new LinkedList<Resource>();
        this.populateResources(request, response, resolver, resourceList);
        if (comparator.isPresent()) {
            resourceList.sort(comparator.get());
        }
        if (offset >= resourceList.size()) {
            return new LinkedList<Resource>();
        }
        if (limit > 0) {
            resourceList = resourceList.subList(offset, Math.min(offset + limit, resourceList.size()));
        }
        return resourceList;
    }

    protected abstract void populateResources(@NotNull SlingHttpServletRequest var1, @NotNull SlingHttpServletResponse var2, ResourceResolver var3, Collection<Resource> var4) throws DictionaryException, ServletException, IOException;

    private static final class OffsetAndLimit {
        private final int offset;
        private final int limit;

        public OffsetAndLimit(int offset, int limit) {
            this.offset = offset;
            this.limit = limit;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }
    }
}

