/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.datasource;

import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"aem-dictionary-translator/datasource/breadcrumbs"}, methods={"GET"})
public class BreadcrumbsDatasource
extends SlingSafeMethodsServlet {
    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        ArrayList<Resource> syntheticItemResources = new ArrayList<Resource>();
        this.addCurrentDictionaryCrumb(request, syntheticItemResources);
        this.addDictionariesCrumb(request, syntheticItemResources);
        SimpleDataSource dataSource = new SimpleDataSource(syntheticItemResources.iterator());
        request.setAttribute(DataSource.class.getName(), (Object)dataSource);
    }

    private void addCurrentDictionaryCrumb(SlingHttpServletRequest request, List<Resource> syntheticItemResources) {
        ValueMapDecorator crumbVM = new ValueMapDecorator(new HashMap());
        crumbVM.put((Object)"title", (Object)request.getRequestPathInfo().getSuffix());
        crumbVM.put((Object)"href", (Object)request.getRequestURI());
        syntheticItemResources.add((Resource)new ValueMapResource(request.getResourceResolver(), new ResourceMetadata(), "nt:unstructured", (ValueMap)crumbVM));
    }

    private void addDictionariesCrumb(@NotNull SlingHttpServletRequest request, List<Resource> syntheticItemResources) {
        ValueMapDecorator crumbVM = new ValueMapDecorator(new HashMap());
        crumbVM.put((Object)"title", (Object)"Dictionaries");
        crumbVM.put((Object)"href", (Object)"/tools/translation/dictionaries.html");
        syntheticItemResources.add((Resource)new ValueMapResource(request.getResourceResolver(), new ResourceMetadata(), "nt:unstructured", (ValueMap)crumbVM));
    }
}

