/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.servlets.action.AbstractDictionaryServlet;
import java.io.IOException;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.apache.sling.servlets.post.HtmlResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/update-message-entry"}, methods={"POST"})
public class UpdateMessageEntryServlet
extends AbstractDictionaryServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateMessageEntryServlet.class);
    @Reference
    private transient DictionaryService dictionaryService;

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String combiningMessageEntryPath = this.getMandatoryParameter(request, "item", false);
        ResourceResolver resourceResolver = request.getResourceResolver();
        try {
            Resource combiningMessageEntryResource = resourceResolver.getResource(combiningMessageEntryPath);
            if (combiningMessageEntryResource != null) {
                LOG.debug("Update message entry for path '{}'", (Object)combiningMessageEntryPath);
                this.updateCombiningMessageEntry(request, resourceResolver, combiningMessageEntryResource);
            } else {
                HtmlResponse htmlResponse = new HtmlResponse();
                htmlResponse.setStatus(500, String.format("No dictionaries to update exist for '%s'", combiningMessageEntryPath));
                htmlResponse.send((HttpServletResponse)response, true);
            }
        }
        catch (Exception e) {
            HtmlResponse htmlResponse = new HtmlResponse();
            htmlResponse.setStatus(500, String.format("Unable to update message entry '%s': %s", combiningMessageEntryPath, e.getMessage()));
            htmlResponse.send((HttpServletResponse)response, true);
        }
    }

    private void updateCombiningMessageEntry(SlingHttpServletRequest request, ResourceResolver resourceResolver, Resource combiningMessageEntryResource) throws DictionaryException, PersistenceException, RepositoryException {
        String key = this.getMandatoryParameter(request, "key", false);
        String dictionaryPath = (String)combiningMessageEntryResource.getValueMap().get("dictionaryPath", String.class);
        if (StringUtils.isNotBlank((CharSequence)dictionaryPath)) {
            String[] languages;
            for (String language : languages = (String[])combiningMessageEntryResource.getValueMap().get("languages", (Object)new String[0])) {
                String message = this.getMandatoryParameter(request, language, true);
                Dictionary dictionary = this.dictionaryService.getDictionary(resourceResolver, dictionaryPath, Locale.forLanguageTag(language)).orElseThrow(() -> new DictionaryException("Could not find dictionary for language '" + language + "' below path: " + dictionaryPath));
                dictionary.createOrUpdateEntry(resourceResolver, key, message);
            }
        } else {
            throw new DictionaryException("Could not find dictionary path in resource: " + combiningMessageEntryResource.getPath());
        }
        resourceResolver.commit();
    }
}

