/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.services.impl.DictionaryImpl;
import be.orbinson.aem.dictionarytranslator.servlets.action.AbstractDictionaryServlet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.apache.sling.servlets.post.HtmlResponse;
import org.apache.tika.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/import-dictionary"}, methods={"POST"})
public class ImportDictionaryServlet
extends AbstractDictionaryServlet {
    @Reference
    private DictionaryService dictionaryService;

    public void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        String dictionaryPath = this.getMandatoryParameter(request, "dictionary", false);
        RequestParameter csvfile = request.getRequestParameter("csvfile");
        if (csvfile != null) {
            try {
                this.processCsvFile(request, dictionaryPath, csvfile.getInputStream());
            }
            catch (DictionaryException | IOException | RepositoryException e) {
                HtmlResponse htmlResponse = new HtmlResponse();
                htmlResponse.setStatus(500, "Error while importing CSV file: " + e.getMessage());
                htmlResponse.send((HttpServletResponse)response, true);
            }
        }
    }

    private void processCsvFile(SlingHttpServletRequest request, String dictionaryPath, InputStream csvContent) throws IOException, RepositoryException, DictionaryException {
        ResourceResolver resourceResolver = request.getResourceResolver();
        List lines = IOUtils.readLines((InputStream)csvContent, (String)String.valueOf(StandardCharsets.UTF_8));
        String header = !lines.isEmpty() ? (String)lines.get(0) : "";
        String result = String.join((CharSequence)"\n", lines);
        CSVFormat format = this.determineCsvFormat(header);
        if (format == null) {
            return;
        }
        try (CSVParser csvParser = CSVParser.parse((String)result, (CSVFormat)format);){
            Map headers = csvParser.getHeaderMap();
            this.validateCsvHeaders(headers);
            headers.remove("KEY");
            SortedMap<Locale, Dictionary> dictionaries = this.dictionaryService.getDictionariesByLanguage(resourceResolver, dictionaryPath);
            if (!dictionaries.isEmpty()) {
                List<Locale> knownLanguages = dictionaries.keySet().stream().collect(Collectors.toList());
                Map<Locale, String> localeToHeaderMap = this.getLocalesToCsvHeadersMap(headers.keySet(), knownLanguages);
                for (CSVRecord csvRecord : csvParser) {
                    this.processCsvRecord(resourceResolver, dictionaries, localeToHeaderMap, csvRecord);
                }
                resourceResolver.commit();
            }
        }
    }

    private CSVFormat determineCsvFormat(String csvHeader) throws IOException {
        CSVFormat.Builder builder = CSVFormat.Builder.create().setSkipHeaderRecord(true);
        if (csvHeader.contains(";")) {
            builder.setDelimiter(';').setHeader(csvHeader.split("\n")[0].split(";"));
        } else if (csvHeader.contains(",")) {
            builder.setDelimiter(',').setHeader(csvHeader.split("\n")[0].split(","));
        } else {
            throw new IOException("Invalid CSV file. The Delimiter should be ',' or ';'.");
        }
        return builder.build();
    }

    private void validateCsvHeaders(Map<String, Integer> headers) throws IOException {
        if (!headers.containsKey("KEY") || headers.get("KEY") != 0) {
            throw new IOException(MessageFormat.format("Invalid CSV file. The first column must be {0}. The Delimiter should be ',' or ';'.", "KEY"));
        }
    }

    private Map<Locale, String> getLocalesToCsvHeadersMap(Collection<String> columnHeaders, List<Locale> knownLanguages) throws IOException {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (String language : columnHeaders) {
            Locale languageInCsv = DictionaryImpl.toLocale(language);
            if (knownLanguages.contains(languageInCsv)) {
                map.put(languageInCsv, language);
                continue;
            }
            throw new IOException("Incorrect CSV file, please only add languages that already have existing dictionaries. No dictionary found for language: " + language);
        }
        return map;
    }

    private void processCsvRecord(ResourceResolver resourceResolver, Map<Locale, Dictionary> dictionaries, Map<Locale, String> localeToHeaderMap, CSVRecord csvRecord) throws IOException, RepositoryException, DictionaryException {
        if (csvRecord.size() != localeToHeaderMap.size() + 1) {
            throw new IOException("Record has an incorrect number of translations: " + String.valueOf(csvRecord));
        }
        String key = csvRecord.get("KEY");
        for (Map.Entry<Locale, String> localeWithHeader : localeToHeaderMap.entrySet()) {
            Dictionary dictionary = dictionaries.get(localeWithHeader.getKey());
            if (dictionary == null) {
                throw new IOException("No dictionary found for language: " + localeWithHeader.getValue());
            }
            if (!dictionary.isEditable(resourceResolver)) {
                throw new IOException("Dictionary for language '" + localeWithHeader.getValue() + "' is not editable: " + dictionary.getPath());
            }
            String translation = csvRecord.get(localeWithHeader.getValue());
            dictionary.createOrUpdateEntry(resourceResolver, key, translation);
        }
    }
}

