/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.servlets.action;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.DictionaryService;
import be.orbinson.aem.dictionarytranslator.servlets.action.AbstractDictionaryServlet;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.apache.sling.servlets.post.HtmlResponse;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceSuperType="granite/ui/components/coral/foundation/form", resourceTypes={"aem-dictionary-translator/servlet/action/delete-message-entry"}, methods={"POST"})
public class DeleteMessageEntryServlet
extends AbstractDictionaryServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteMessageEntryServlet.class);
    public static final String ITEM_PARAM = "item";
    @Reference
    private transient DictionaryService dictionaryService;
    @Reference
    private Replicator replicator;

    protected void doPost(SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Collection<String> combiningMessageEntryPaths = this.getMandatoryParameters(request, ITEM_PARAM, false);
        for (String combiningMessageEntryPath : combiningMessageEntryPaths) {
            HtmlResponse htmlResponse;
            ResourceResolver resourceResolver = request.getResourceResolver();
            Resource combiningMessageEntryResource = resourceResolver.getResource(combiningMessageEntryPath);
            if (combiningMessageEntryResource == null) {
                HtmlResponse htmlResponse2 = new HtmlResponse();
                htmlResponse2.setStatus(400, String.format("Unable to get message entry '%s'", combiningMessageEntryPath));
                htmlResponse2.send((HttpServletResponse)response, true);
                return;
            }
            try {
                ValueMap properties = combiningMessageEntryResource.getValueMap();
                String key = (String)properties.get("key", String.class);
                if (key == null) {
                    throw new IllegalArgumentException("key is required");
                }
                String dictionaryPath = (String)properties.get("dictionaryPath", String.class);
                if (dictionaryPath == null) {
                    throw new IllegalArgumentException("dictionaryPath is required");
                }
                for (Dictionary dictionary : this.dictionaryService.getDictionaries(resourceResolver, dictionaryPath)) {
                    dictionary.deleteEntry(this.replicator, resourceResolver, key);
                }
                resourceResolver.commit();
                LOG.debug("Deleted message entry for key '{}' from all dictionaries below '{}'", (Object)key, (Object)dictionaryPath);
            }
            catch (DictionaryException | ReplicationException | PersistenceException e) {
                htmlResponse = new HtmlResponse();
                htmlResponse.setStatus(500, String.format("Unable to delete message entry '%s': %s", combiningMessageEntryPath, e.getMessage()));
                htmlResponse.send((HttpServletResponse)response, true);
                return;
            }
            catch (IllegalArgumentException e) {
                htmlResponse = new HtmlResponse();
                htmlResponse.setStatus(400, String.format("Missing mandatory property from resource: %s", combiningMessageEntryPath, e.getMessage()));
                htmlResponse.send((HttpServletResponse)response, true);
                return;
            }
        }
    }
}

