/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services.impl;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.impl.DictionaryImpl;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingMessageDictionaryImpl
extends DictionaryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SlingMessageDictionaryImpl.class);

    public SlingMessageDictionaryImpl(Resource dictionaryResource, Supplier<ResourceResolver> resourceResolverSupplier) {
        super(dictionaryResource, resourceResolverSupplier);
    }

    @Override
    public Dictionary.Type getType() {
        return Dictionary.Type.SLING_MESSAGE_ENTRY;
    }

    private static boolean isMessageEntryResource(Resource messageEntryResource) {
        return messageEntryResource != null && (messageEntryResource.isResourceType("sling:MessageEntry") || SlingMessageDictionaryImpl.hasMixinType(messageEntryResource, "sling:Message"));
    }

    private static boolean hasMixinType(Resource resource, String mixinType) {
        return Arrays.asList((String[])resource.getValueMap().get("jcr:mixinTypes", (Object)new String[0])).contains(mixinType);
    }

    @Override
    public Map<String, Dictionary.Message> loadMessages(Resource dictionaryResource) {
        HashMap<String, Dictionary.Message> messages = new HashMap<String, Dictionary.Message>();
        dictionaryResource.listChildren().forEachRemaining(messageEntryResource -> {
            if (SlingMessageDictionaryImpl.isMessageEntryResource(messageEntryResource)) {
                String key = Optional.ofNullable((String)messageEntryResource.getValueMap().get("sling:key", String.class)).orElse(Text.unescapeIllegalJcrChars((String)messageEntryResource.getName()));
                messages.put(key, new Dictionary.Message((String)messageEntryResource.getValueMap().get("sling:message", (Object)""), messageEntryResource.getPath()));
            }
        });
        return messages;
    }

    @Override
    public void createOrUpdateEntry(ResourceResolver resourceResolver, String key, String message) throws PersistenceException, DictionaryException {
        Resource messageEntryResource = this.getOrCreateMessageEntryResource(resourceResolver, key);
        SlingMessageDictionaryImpl.updateMessage(key, message, messageEntryResource);
    }

    private static void updateMessage(String key, String message, Resource messageEntryResource) throws PersistenceException {
        ValueMap valueMap = (ValueMap)messageEntryResource.adaptTo(ModifiableValueMap.class);
        if (valueMap != null) {
            if (message.isBlank()) {
                valueMap.remove((Object)"sling:message");
            } else {
                valueMap.put((Object)"sling:message", (Object)message);
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    valueMap.putIfAbsent((Object)"sling:key", (Object)key);
                }
                LOG.trace("Updated message entry with name '{}' and message '{}' on path '{}'", new Object[]{messageEntryResource.getName(), message, messageEntryResource.getPath()});
            }
        } else {
            throw new PersistenceException("Could not update message entry, resource at \"" + messageEntryResource.getPath() + "\" not adaptable to ModifiableValueMap");
        }
    }

    private Optional<Resource> getMessageEntryResource(ResourceResolver resourceResolver, String key) throws DictionaryException {
        Objects.requireNonNull(resourceResolver, "resourceResolver must not be null");
        Objects.requireNonNull(key, "key must not be null");
        Dictionary.Message message = this.getEntries().get(key);
        if (message == null) {
            return Optional.empty();
        }
        Resource messageEntryResource = resourceResolver.getResource(message.getResourcePath().orElseThrow(() -> new DictionaryException("Message entry resource not found for key \"" + key + "\"")));
        return Optional.of(messageEntryResource);
    }

    @NotNull
    private Resource getOrCreateMessageEntryResource(ResourceResolver resourceResolver, String key) throws DictionaryException, PersistenceException {
        Optional<Resource> messageEntryResource = this.getMessageEntryResource(resourceResolver, key);
        if (messageEntryResource.isPresent()) {
            return messageEntryResource.get();
        }
        Resource newResource = resourceResolver.create(this.getResource(resourceResolver), Text.escapeIllegalJcrChars((String)key), Map.of("jcr:primaryType", "sling:MessageEntry"));
        LOG.trace("Created message entry with key '{}' on path '{}'", (Object)key, (Object)newResource.getPath());
        return newResource;
    }

    @Override
    public void deleteEntry(Replicator replicator, ResourceResolver resourceResolver, String key) throws PersistenceException, ReplicationException, DictionaryException {
        Resource messageEntryResource = this.getMessageEntryResource(resourceResolver, key).orElseThrow(() -> new DictionaryException("Message entry resource not found for key \"" + key + "\" of dictionary \"" + this.getPath() + "\""));
        replicator.replicate((Session)resourceResolver.adaptTo(Session.class), ReplicationActionType.DEACTIVATE, messageEntryResource.getPath());
        resourceResolver.delete(messageEntryResource);
    }
}

