/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services.impl;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import be.orbinson.aem.dictionarytranslator.services.impl.DictionaryImpl;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.commons.json.JsonParser;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileDictionary
extends DictionaryImpl {
    private static final Logger LOG = LoggerFactory.getLogger(JsonFileDictionary.class);

    protected JsonFileDictionary(Resource dictionaryResource, Supplier<ResourceResolver> resourceResolverSupplier) {
        super(dictionaryResource, resourceResolverSupplier);
    }

    @Override
    public Dictionary.Type getType() {
        return Dictionary.Type.JSON_FILE;
    }

    @Override
    public boolean isEditable(ResourceResolver resourceResolver) {
        return false;
    }

    @Override
    public Map<String, Dictionary.Message> loadMessages(Resource dictionaryResource) {
        HashMap<String, Object> messages = new HashMap<String, Object>();
        this.loadJsonDictionary(dictionaryResource.getChild("jcr:content"), messages);
        return messages.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Dictionary.Message(e.getValue().toString(), null)));
    }

    @Override
    public void createOrUpdateEntry(ResourceResolver resourceResolver, String key, String message) throws PersistenceException, DictionaryException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void deleteEntry(Replicator replicator, ResourceResolver resourceResolver, String key) throws PersistenceException, ReplicationException, DictionaryException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static boolean isCompliant(Resource languageResource) {
        return languageResource.getName().endsWith(".json") && languageResource.getChild("jcr:content") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJsonDictionary(Resource resource, final Map<String, Object> targetDictionary) {
        LOG.info("Loading json dictionary: {}", (Object)resource.getPath());
        JsonParser parser = new JsonParser(new JsonHandler(){
            private String key;

            public void key(String key) throws IOException {
                this.key = key;
            }

            public void value(String value) throws IOException {
                targetDictionary.put(this.key, value);
            }

            public void object() throws IOException {
            }

            public void endObject() throws IOException {
            }

            public void array() throws IOException {
            }

            public void endArray() throws IOException {
            }

            public void value(boolean value) throws IOException {
            }

            public void value(long value) throws IOException {
            }

            public void value(double value) throws IOException {
            }
        });
        InputStream stream = (InputStream)resource.adaptTo(InputStream.class);
        if (stream != null) {
            String encoding = "utf-8";
            ResourceMetadata metadata = resource.getResourceMetadata();
            if (metadata.getCharacterEncoding() != null) {
                encoding = metadata.getCharacterEncoding();
            }
            try {
                parser.parse(stream, encoding);
            }
            catch (IOException e) {
                LOG.warn("Could not parse i18n json dictionary {}: {}", (Object)resource.getPath(), (Object)e.getMessage());
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            LOG.warn("Not a json file: {}", (Object)resource.getPath());
        }
    }
}

