/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services.impl;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import be.orbinson.aem.dictionarytranslator.services.Dictionary;
import java.util.Arrays;
import java.util.IllformedLocaleException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DictionaryImpl
implements Dictionary {
    private static final Logger LOG = LoggerFactory.getLogger(DictionaryImpl.class);
    static final String SLING_BASENAME = "sling:basename";
    protected final String path;
    private final int ordinal;
    private final Locale language;
    private final Set<String> baseNames;
    private Map<String, Dictionary.Message> messages;
    private final Supplier<ResourceResolver> resourceResolverSupplier;
    private static final Pattern USER_ASSIGNED_COUNTRY_CODES_PATTERN = Pattern.compile("aa|q[m-z]|x[a-z]|zz");

    protected DictionaryImpl(Resource dictionaryResource, Supplier<ResourceResolver> resourceResolverSupplier) {
        this.path = dictionaryResource.getPath();
        this.ordinal = DictionaryImpl.getOrdinal(this.path, dictionaryResource.getResourceResolver().getSearchPath());
        ValueMap properties = dictionaryResource.getValueMap();
        String languageString = (String)properties.get("jcr:language", String.class);
        if (languageString == null || languageString.isEmpty()) {
            throw new IllegalStateException("Language is not set for dictionary: " + this.path);
        }
        this.language = DictionaryImpl.toLocale((String)properties.get("jcr:language", String.class));
        String[] baseNames = (String[])properties.get(SLING_BASENAME, String[].class);
        this.baseNames = baseNames != null ? Set.of(baseNames) : Set.of();
        this.resourceResolverSupplier = resourceResolverSupplier;
    }

    private static int getOrdinal(String path, String[] searchPaths) {
        int i;
        for (i = 0; i < searchPaths.length; ++i) {
            if (!path.startsWith(searchPaths[i])) continue;
            return i;
        }
        return i;
    }

    @Override
    public boolean isEditable(ResourceResolver resourceResolver) {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session != null) {
            try {
                AccessControlManager accessControlManager = session.getAccessControlManager();
                Privilege[] privileges = new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes"), accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"), accessControlManager.privilegeFromName("crx:replicate")};
                boolean isPathWritable = session.hasCapability("addNode", (Object)this.path, new Object[]{"nt:folder"});
                return isPathWritable && accessControlManager.hasPrivileges(this.path, privileges);
            }
            catch (RepositoryException e) {
                LOG.debug("Could not check if dictionary is editable, therefore assume it is not!", (Throwable)e);
                return false;
            }
        }
        LOG.debug("ResourceResolver is not adaptable to Session, cannot check if dictionary is editable at path: {}", (Object)this.path);
        return true;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Locale getLanguage() {
        return this.language;
    }

    @Override
    public Set<String> getBaseNames() {
        return this.baseNames;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public synchronized Map<String, Dictionary.Message> getEntries() throws DictionaryException {
        if (this.messages == null) {
            try (ResourceResolver resolver = this.resourceResolverSupplier.get();){
                Resource dictionaryResource = resolver.getResource(this.path);
                if (dictionaryResource == null) {
                    throw new DictionaryException("Dictionary resource not found: " + this.path);
                }
                this.messages = this.loadMessages(dictionaryResource);
            }
        }
        return this.messages;
    }

    public abstract Map<String, Dictionary.Message> loadMessages(Resource var1) throws DictionaryException;

    protected Resource getResource(ResourceResolver resourceResolver) throws DictionaryException {
        Resource resource = resourceResolver.getResource(this.path);
        if (resource == null) {
            throw new DictionaryException("Dictionary resource not found: " + this.path);
        }
        return resource;
    }

    public static Locale toLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return Locale.getDefault();
        }
        String[] parts = (localeString = localeString.replaceAll("-", "_")).split("_");
        if (parts.length == 0) {
            return Locale.getDefault();
        }
        String lang = DictionaryImpl.getValidLanguage(parts[0]);
        if (parts.length == 1) {
            return new Locale(lang);
        }
        Locale localeWithBuilder = DictionaryImpl.createLocaleWithBuilder(parts, lang);
        if (localeWithBuilder != null) {
            return localeWithBuilder;
        }
        return DictionaryImpl.createLocaleWithConstructor(lang, parts);
    }

    private static Locale createLocaleWithBuilder(String[] parts, String lang) {
        if (parts.length >= 2 && DictionaryImpl.isScript(parts[1])) {
            try {
                switch (parts.length) {
                    case 2: {
                        return new Locale.Builder().setLanguage(lang).setScript(parts[1]).build();
                    }
                    case 3: {
                        return new Locale.Builder().setLanguage(lang).setScript(parts[1]).setRegion(DictionaryImpl.getValidCountry(parts[2])).build();
                    }
                }
                return DictionaryImpl.processMultipleParts(parts, lang);
            }
            catch (IllformedLocaleException e) {
                LOG.warn("Failed to create locale with LocaleBuilder having parts: {}", (Object)Arrays.toString(parts), (Object)e);
            }
        }
        return null;
    }

    private static Locale processMultipleParts(String[] parts, String lang) {
        if (parts.length >= 4) {
            Locale.Builder localeBuilder = new Locale.Builder().setLanguage(lang).setScript(parts[1]).setRegion(DictionaryImpl.getValidCountry(parts[2]));
            try {
                localeBuilder.setVariant(parts[3]);
                return localeBuilder.build();
            }
            catch (IllformedLocaleException e) {
                return localeBuilder.build();
            }
        }
        return null;
    }

    private static String getValidLanguage(String lang) {
        for (String validLang : Locale.getISOLanguages()) {
            if (!validLang.equalsIgnoreCase(lang)) continue;
            return lang;
        }
        return Locale.getDefault().getLanguage();
    }

    private static String getValidCountry(String country) {
        return DictionaryImpl.isValidCountryCode(country) ? country : Locale.getDefault().getCountry();
    }

    private static Locale createLocaleWithConstructor(String lang, String[] parts) {
        String country = parts.length > 1 ? DictionaryImpl.getValidCountry(parts[1]) : "";
        String variant = parts.length > 2 ? parts[2] : "";
        return new Locale(lang, country, variant);
    }

    private static boolean isValidCountryCode(String country) {
        boolean isValidCountryCode = false;
        if (USER_ASSIGNED_COUNTRY_CODES_PATTERN.matcher(country.toLowerCase()).matches()) {
            isValidCountryCode = true;
        } else {
            String[] countries = Locale.getISOCountries();
            for (int i = 0; i < countries.length; ++i) {
                if (!countries[i].equalsIgnoreCase(country)) continue;
                isValidCountryCode = true;
                break;
            }
        }
        return isValidCountryCode;
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isAlphaString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (DictionaryImpl.isAlpha(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isScript(String s) {
        return s.length() == 4 && DictionaryImpl.isAlphaString(s);
    }
}

