/*
 * Decompiled with CFR 0.152.
 */
package be.orbinson.aem.dictionarytranslator.services;

import be.orbinson.aem.dictionarytranslator.exception.DictionaryException;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;

public interface Dictionary {
    public String getPath();

    public Locale getLanguage();

    public boolean isEditable(ResourceResolver var1);

    public Set<String> getBaseNames();

    public Type getType();

    public int getOrdinal();

    public Map<String, Message> getEntries() throws DictionaryException;

    public void createOrUpdateEntry(ResourceResolver var1, String var2, String var3) throws PersistenceException, DictionaryException;

    public void deleteEntry(Replicator var1, ResourceResolver var2, String var3) throws PersistenceException, ReplicationException, DictionaryException;

    public static final class Message {
        private final String text;
        private final String resourcePath;

        public Message(String message, String resourcePath) {
            this.text = message;
            this.resourcePath = resourcePath;
        }

        public String getText() {
            return this.text;
        }

        public Optional<String> getResourcePath() {
            return Optional.ofNullable(this.resourcePath);
        }

        public String toString() {
            return "Message [text=" + this.text + ", resourcePath=" + this.resourcePath + "]";
        }

        public int hashCode() {
            return Objects.hash(this.text, this.resourcePath);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Message other = (Message)obj;
            return Objects.equals(this.text, other.text) && Objects.equals(this.resourcePath, other.resourcePath);
        }
    }

    public static enum Type {
        SLING_MESSAGE_ENTRY("sling:MessageEntry"),
        JSON_FILE("JSON file"),
        MIXED("Mixed");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

