/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.serialization;

import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamWriter;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.serialization.LazyTagWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\rH\u0002J\u001a\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u000e2\b\u0010#\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010$\u001a\u00020\u0011H\u0002J\b\u0010%\u001a\u00020\u001eH\u0016J\u001a\u0010&\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/serialization/BufferingXmlStreamWriter;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamWriter;", "pretty", "", "<init>", "(Z)V", "getPretty", "()Z", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "nsAttributes", "", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$QualifiedName;", "", "tagWriterStack", "Lkotlin/collections/ArrayDeque;", "Laws/smithy/kotlin/runtime/serde/xml/serialization/LazyTagWriter;", "bytes", "", "getBytes", "()[B", "text", "getText", "()Ljava/lang/String;", "attribute", "name", "value", "namespace", "endDocument", "", "endTag", "qName", "namespacePrefix", "uri", "prefix", "requireWriter", "startDocument", "startTag", "serde-xml"})
public final class BufferingXmlStreamWriter
implements XmlStreamWriter {
    private final boolean pretty;
    @NotNull
    private final StringBuilder buffer;
    @NotNull
    private final Map<XmlToken.QualifiedName, String> nsAttributes;
    @NotNull
    private final ArrayDeque<LazyTagWriter> tagWriterStack;

    public BufferingXmlStreamWriter(boolean pretty) {
        this.pretty = pretty;
        this.buffer = new StringBuilder();
        this.nsAttributes = new LinkedHashMap();
        this.tagWriterStack = new ArrayDeque();
    }

    public /* synthetic */ BufferingXmlStreamWriter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getPretty() {
        return this.pretty;
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        return StringsKt.encodeToByteArray((String)this.getText());
    }

    @Override
    @NotNull
    public String getText() {
        this.endDocument();
        String string = this.buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public XmlStreamWriter attribute(@NotNull String name, @Nullable String value, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        XmlToken.QualifiedName qName = new XmlToken.QualifiedName(name, namespace);
        this.requireWriter().attribute(qName, value);
        return this;
    }

    @Override
    public void endDocument() {
        LazyTagWriter top = (LazyTagWriter)this.tagWriterStack.lastOrNull();
        while (top != null) {
            this.endTag(top.getQName());
            top = (LazyTagWriter)this.tagWriterStack.lastOrNull();
        }
    }

    @Override
    @NotNull
    public XmlStreamWriter endTag(@NotNull String name, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.endTag(new XmlToken.QualifiedName(name, namespace));
    }

    private final XmlStreamWriter endTag(XmlToken.QualifiedName qName) {
        LazyTagWriter lazyTagWriter = (LazyTagWriter)this.tagWriterStack.removeLastOrNull();
        if (lazyTagWriter == null) {
            throw new SerializationException("Unexpected end of tag while no tags are open");
        }
        LazyTagWriter childWriter = lazyTagWriter;
        if (!Intrinsics.areEqual((Object)childWriter.getQName(), (Object)qName)) {
            throw new SerializationException("Tried to end tag " + qName + " but expected end of " + childWriter.getQName() + " tag");
        }
        if (this.tagWriterStack.isEmpty()) {
            childWriter.write(this.buffer);
        }
        return this;
    }

    @Override
    public void namespacePrefix(@NotNull String uri, @Nullable String prefix) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        XmlToken.QualifiedName attrQName = prefix == null ? new XmlToken.QualifiedName("xmlns", null, 2, null) : new XmlToken.QualifiedName(prefix, "xmlns");
        this.nsAttributes.put(attrQName, uri);
    }

    private final LazyTagWriter requireWriter() {
        if (this.tagWriterStack.isEmpty()) {
            throw new SerializationException("Attempted to serialize text or attribute without containing tag");
        }
        return (LazyTagWriter)this.tagWriterStack.last();
    }

    @Override
    public void startDocument() {
        this.buffer.append("<?xml version=\"1.0\"?>");
        if (this.pretty) {
            this.buffer.append('\n');
        }
    }

    @Override
    @NotNull
    public XmlStreamWriter startTag(@NotNull String name, @Nullable String namespace) {
        LazyTagWriter currentWriter;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LazyTagWriter lazyTagWriter = currentWriter = (LazyTagWriter)this.tagWriterStack.lastOrNull();
        int currentIndent = lazyTagWriter != null ? lazyTagWriter.getIndentLevel() : -1;
        XmlToken.QualifiedName qName = new XmlToken.QualifiedName(name, namespace);
        LazyTagWriter childWriter = new LazyTagWriter(this.pretty, currentIndent + 1, qName, this.nsAttributes);
        this.nsAttributes.clear();
        LazyTagWriter lazyTagWriter2 = currentWriter;
        if (lazyTagWriter2 != null) {
            lazyTagWriter2.childTag(childWriter);
        }
        this.tagWriterStack.addLast((Object)childWriter);
        return this;
    }

    @Override
    @NotNull
    public XmlStreamWriter text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.requireWriter().text(text);
        return this;
    }

    public BufferingXmlStreamWriter() {
        this(false, 1, null);
    }
}

