/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.deserialization;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.XmlTokenKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.ChildXmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.EmptyXmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.LexingXmlStreamReaderKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStream;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStreamKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.XmlLexer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0080\b\u00a2\u0006\u0002\b\rJ\n\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u001b\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0082\u0010J\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/deserialization/LexingXmlStreamReader;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "source", "Laws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer;", "<init>", "(Laws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer;)V", "peekQueue", "Lkotlin/collections/ArrayDeque;", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "error", "", "msg", "", "error$serde_xml", "value", "lastToken", "getLastToken", "()Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "nextToken", "peek", "index", "", "skipNext", "", "scanUntilDepth", "startDepth", "from", "subTreeReader", "subtreeStartDepth", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader$SubtreeStartDepth;", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nLexingXmlStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LexingXmlStreamReader.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/LexingXmlStreamReader\n+ 2 XmlLexer.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer\n+ 3 StringTextStream.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n50#2:134\n94#3,12:135\n1#4:147\n*S KotlinDebug\n*F\n+ 1 LexingXmlStreamReader.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/LexingXmlStreamReader\n*L\n27#1:134\n27#1:135,12\n*E\n"})
public final class LexingXmlStreamReader
implements XmlStreamReader {
    @NotNull
    private final XmlLexer source;
    @NotNull
    private final ArrayDeque<XmlToken> peekQueue;
    @Nullable
    private XmlToken lastToken;

    public LexingXmlStreamReader(@NotNull XmlLexer source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.peekQueue = new ArrayDeque();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Void error$serde_xml(@NotNull String msg) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        boolean $i$f$error$serde_xml = false;
        XmlLexer xmlLexer = this.source;
        String msg$iv = msg;
        boolean $i$f$error$serde_xml2 = false;
        StringTextStream stringTextStream = this_$iv.getSource$serde_xml();
        String msg$iv$iv = msg$iv;
        boolean $i$f$error$serde_xml3 = false;
        int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p((StringTextStream)this_$iv$iv) - 3);
        int end$iv$iv = Math.min(StringTextStream.access$getEnd$p((StringTextStream)this_$iv$iv) - 1, StringTextStream.access$getOffset$p((StringTextStream)this_$iv$iv) + 3);
        String string = StringTextStream.access$getSource$p((StringTextStream)this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        Regex regex = StringTextStreamKt.access$getNonAscii$p();
        String string2 = "\u00b7";
        String snippet$iv$iv = regex.replace(charSequence, string2);
        int caretPos$iv$iv = StringTextStream.access$getOffset$p((StringTextStream)this_$iv$iv) - start$iv$iv;
        String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
        String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p((StringTextStream)this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
        String fullMsg$iv$iv = msg$iv$iv + '\n' + locationMultilineString$iv$iv;
        throw new DeserializationException(fullMsg$iv$iv);
    }

    @Override
    @Nullable
    public XmlToken getLastToken() {
        return this.lastToken;
    }

    @Override
    @Nullable
    public XmlToken nextToken() {
        XmlToken xmlToken;
        XmlToken xmlToken2 = (XmlToken)this.peekQueue.removeFirstOrNull();
        if (xmlToken2 == null) {
            xmlToken2 = this.source.parseNext();
        }
        XmlToken it = xmlToken = xmlToken2;
        boolean bl = false;
        this.lastToken = it;
        return xmlToken;
    }

    @Override
    @Nullable
    public XmlToken peek(int index) {
        while (index > this.peekQueue.size() && !this.source.getEndOfDocument()) {
            XmlToken xmlToken = this.source.parseNext();
            Intrinsics.checkNotNull((Object)xmlToken);
            this.peekQueue.addLast((Object)xmlToken);
        }
        return (XmlToken)LexingXmlStreamReaderKt.access$getOrNull((List)this.peekQueue, index - 1);
    }

    @Override
    public void skipNext() {
        XmlToken xmlToken = this.peek(1);
        if (xmlToken == null) {
            return;
        }
        XmlToken peekToken = xmlToken;
        int startDepth = peekToken.getDepth();
        this.scanUntilDepth(startDepth, this.nextToken());
    }

    private final void scanUntilDepth(int startDepth, XmlToken from) {
        LexingXmlStreamReader lexingXmlStreamReader = this;
        while (from != null && !(from instanceof XmlToken.EndDocument)) {
            if (from instanceof XmlToken.EndElement && ((XmlToken.EndElement)from).getDepth() == startDepth) {
                return;
            }
            LexingXmlStreamReader lexingXmlStreamReader2 = lexingXmlStreamReader;
            int n = startDepth;
            XmlToken xmlToken = lexingXmlStreamReader.nextToken();
            lexingXmlStreamReader = lexingXmlStreamReader2;
            startDepth = n;
            from = xmlToken;
        }
        return;
    }

    @Override
    @NotNull
    public XmlStreamReader subTreeReader(@NotNull XmlStreamReader.SubtreeStartDepth subtreeStartDepth) {
        XmlStreamReader xmlStreamReader;
        Intrinsics.checkNotNullParameter((Object)((Object)subtreeStartDepth), (String)"subtreeStartDepth");
        if (XmlTokenKt.terminates(this.peek(1), this.getLastToken())) {
            this.nextToken();
            xmlStreamReader = new EmptyXmlStreamReader(this);
        } else {
            xmlStreamReader = new ChildXmlStreamReader(this, subtreeStartDepth);
        }
        return xmlStreamReader;
    }
}

