/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.text;

import aws.smithy.kotlin.runtime.InternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0012\u0010\u0011J5\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J+\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J3\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0013H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ5\u0010\u001d\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0004\b\u001d\u0010\u0015J\u000f\u0010\u001e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010!\u001a\u00020 2\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b!\u0010\"J5\u0010#\u001a\u00020\u000e2\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0006\"\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0004\b#\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\u001fR\u0016\u0010&\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Laws/smithy/kotlin/runtime/text/Scanner;", "", "", "text", "<init>", "(Ljava/lang/String;)V", "", "literals", "Lkotlin/Pair;", "", "findAnyOf", "([Ljava/lang/String;)Lkotlin/Pair;", "prefix", "Lkotlin/Function0;", "", "handler", "ifStartsWith", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "ifStartsWithSkip", "Lkotlin/Function1;", "optionalAndSkip", "([Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "untilIndex", "process", "(ILkotlin/jvm/functions/Function1;)V", "literal", "startIndex", "processAndSkip", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "requireAndSkip", "toString", "()Ljava/lang/String;", "", "startsWith", "(Ljava/lang/String;)Z", "upToOrEnd", "Ljava/lang/String;", "getText", "currentIndex", "I", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Scanner.kt\naws/smithy/kotlin/runtime/text/Scanner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n11228#2:181\n11563#2,3:182\n774#3:185\n865#3,2:186\n2423#3,14:188\n1#4:202\n*S KotlinDebug\n*F\n+ 1 Scanner.kt\naws/smithy/kotlin/runtime/text/Scanner\n*L\n20#1:181\n20#1:182,3\n21#1:185\n21#1:186,2\n22#1:188,14\n*E\n"})
public final class Scanner {
    @NotNull
    private final String text;
    private int currentIndex;

    public Scanner(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, Integer> findAnyOf(String[] literals) {
        Object v0;
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        String[] $this$map$iv = literals;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Pair item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_18 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)StringsKt.indexOf$default((CharSequence)this.text, (String)it, (int)this.currentIndex, (boolean)false, (int)4, null)));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair item$iv$iv;
            item$iv$iv = (Pair)element$iv$iv;
            boolean bl = false;
            int index = ((Number)item$iv$iv.component2()).intValue();
            if (!(index != -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                int index2;
                Pair $i$f$filterTo2 = (Pair)minElem$iv;
                boolean bl = false;
                int minValue$iv = index2 = ((Number)$i$f$filterTo2.component2()).intValue();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair index2 = (Pair)e$iv;
                    $i$a$-minByOrNull-Scanner$findAnyOf$3 = false;
                    int index3 = ((Number)index2.component2()).intValue();
                    int v$iv = index3;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public final void ifStartsWith(@NotNull String prefix, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.startsWith(prefix)) {
            handler.invoke();
        }
    }

    public final void ifStartsWithSkip(@NotNull String prefix, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.startsWith(prefix)) {
            this.currentIndex += prefix.length();
            handler.invoke();
        }
    }

    public final void optionalAndSkip(@NotNull String[] literals, @NotNull Function1<? super String, Unit> handler) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)literals, (String)"literals");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            Pair<String, Integer> pair = this.findAnyOf(literals);
            if (pair == null) break block0;
            Pair<String, Integer> pair2 = pair;
            boolean bl = false;
            String literal = (String)pair2.component1();
            int startIndex = ((Number)pair2.component2()).intValue();
            this.processAndSkip(literal, startIndex, handler);
        }
    }

    private final void process(int untilIndex, Function1<? super String, Unit> handler) {
        String string = this.text.substring(this.currentIndex, untilIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String captured = string;
        this.currentIndex = untilIndex;
        handler.invoke((Object)captured);
    }

    private final void processAndSkip(String literal, int startIndex, Function1<? super String, Unit> handler) {
        this.process(startIndex, handler);
        this.currentIndex += literal.length();
    }

    public final void requireAndSkip(@NotNull String[] literals, @NotNull Function1<? super String, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)literals, (String)"literals");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Pair<String, Integer> pair = this.findAnyOf(literals);
        if (pair == null) {
            boolean $i$a$-requireNotNull-Scanner$requireAndSkip$22 = false;
            String $i$a$-requireNotNull-Scanner$requireAndSkip$22 = "Cannot find any of " + ArraysKt.toList((Object[])literals);
            throw new IllegalArgumentException($i$a$-requireNotNull-Scanner$requireAndSkip$22.toString());
        }
        Pair<String, Integer> pair2 = pair;
        String literal = (String)pair2.component1();
        int startIndex = ((Number)pair2.component2()).intValue();
        this.processAndSkip(literal, startIndex, handler);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Scanner(remainingText='");
        String string = this.text.substring(this.currentIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return stringBuilder.append(string).append("')").toString();
    }

    public final boolean startsWith(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return StringsKt.regionMatches$default((String)this.text, (int)this.currentIndex, (String)prefix, (int)0, (int)prefix.length(), (boolean)false, (int)16, null);
    }

    public final void upToOrEnd(@NotNull String[] literals, @NotNull Function1<? super String, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)literals, (String)"literals");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Pair<String, Integer> pair = this.findAnyOf(literals);
        int untilIndex = pair != null ? ((Number)pair.getSecond()).intValue() : this.text.length();
        this.process(untilIndex, handler);
    }
}

