/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.io;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkSource;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Laws/smithy/kotlin/runtime/io/GzipSdkSource;", "Laws/smithy/kotlin/runtime/io/SdkSource;", "source", "<init>", "(Laws/smithy/kotlin/runtime/io/SdkSource;)V", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "sink", "", "limit", "read", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;J)J", "", "close", "()V", "Laws/smithy/kotlin/runtime/io/SdkSource;", "gzipBuffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "Ljava/util/zip/GZIPOutputStream;", "gzipOutputStream", "Ljava/util/zip/GZIPOutputStream;", "runtime-core"})
public final class GzipSdkSource
implements SdkSource {
    @NotNull
    private final SdkSource source;
    @NotNull
    private final SdkBuffer gzipBuffer;
    @NotNull
    private final GZIPOutputStream gzipOutputStream;

    public GzipSdkSource(@NotNull SdkSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.gzipBuffer = new SdkBuffer();
        this.gzipOutputStream = new GZIPOutputStream(this.gzipBuffer.outputStream(), true);
    }

    @Override
    public long read(@NotNull SdkBuffer sink, long limit) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!(limit >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (limit == 0L) {
            return 0L;
        }
        SdkBuffer temp = new SdkBuffer();
        long rc = this.source.read(temp, limit);
        if (rc == -1L) {
            this.gzipOutputStream.close();
        }
        if (rc == -1L && this.gzipBuffer.exhausted()) {
            return -1L;
        }
        if (rc >= 0L) {
            this.gzipOutputStream.write(temp.readByteArray());
            this.gzipOutputStream.flush();
        }
        return this.gzipBuffer.read(sink, limit);
    }

    @Override
    public void close() {
        this.gzipOutputStream.close();
        this.source.close();
    }
}

