/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.content;

import aws.smithy.kotlin.runtime.content.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\r\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0018\u0010$\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b$\u0010%R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010&\u001a\u0004\b'\u0010\rR\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0018\u00a8\u0006."}, d2={"Laws/smithy/kotlin/runtime/content/BigDecimal;", "", "", "", "value", "<init>", "(Ljava/lang/String;)V", "Laws/smithy/kotlin/runtime/content/BigInteger;", "mantissa", "", "exponent", "(Laws/smithy/kotlin/runtime/content/BigInteger;I)V", "toPlainString", "()Ljava/lang/String;", "", "toByte", "()B", "", "toDouble", "()D", "", "toFloat", "()F", "toInt", "()I", "", "toLong", "()J", "", "toShort", "()S", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "compareTo", "(Laws/smithy/kotlin/runtime/content/BigDecimal;)I", "Ljava/lang/String;", "getValue", "Ljava/math/BigDecimal;", "delegate", "Ljava/math/BigDecimal;", "getMantissa", "()Laws/smithy/kotlin/runtime/content/BigInteger;", "getExponent", "runtime-core"})
public final class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    @NotNull
    private final String value;
    @NotNull
    private final java.math.BigDecimal delegate;

    public BigDecimal(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        this.delegate = new java.math.BigDecimal(this.value);
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public BigDecimal(@NotNull BigInteger mantissa, int exponent) {
        Intrinsics.checkNotNullParameter((Object)mantissa, (String)"mantissa");
        String string = new java.math.BigDecimal(new java.math.BigInteger(mantissa.toString()), exponent).toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPlainString(...)");
        this(string);
    }

    @NotNull
    public final String toPlainString() {
        String string = this.delegate.toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPlainString(...)");
        return string;
    }

    public byte toByte() {
        return this.delegate.byteValue();
    }

    public double toDouble() {
        return this.delegate.doubleValue();
    }

    public float toFloat() {
        return this.delegate.floatValue();
    }

    public int toInt() {
        return this.delegate.intValue();
    }

    public long toLong() {
        return this.delegate.longValue();
    }

    public short toShort() {
        return this.delegate.shortValue();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BigDecimal && Intrinsics.areEqual((Object)this.delegate, (Object)((BigDecimal)other).delegate);
    }

    @NotNull
    public final BigInteger getMantissa() {
        String string = this.delegate.unscaledValue().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new BigInteger(string);
    }

    public final int getExponent() {
        return this.delegate.scale();
    }

    @Override
    public int compareTo(@NotNull BigDecimal other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.delegate.compareTo(other.delegate);
    }
}

