/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.response;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.HeadersBuilder;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.http.response.HttpResponseKt;
import aws.smithy.kotlin.runtime.util.CanDeepCopy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/http/response/HttpResponseBuilder;", "Laws/smithy/kotlin/runtime/util/CanDeepCopy;", "status", "Laws/smithy/kotlin/runtime/http/HttpStatusCode;", "headers", "Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "body", "Laws/smithy/kotlin/runtime/http/HttpBody;", "<init>", "(Laws/smithy/kotlin/runtime/http/HttpStatusCode;Laws/smithy/kotlin/runtime/http/HeadersBuilder;Laws/smithy/kotlin/runtime/http/HttpBody;)V", "()V", "getStatus", "()Laws/smithy/kotlin/runtime/http/HttpStatusCode;", "setStatus", "(Laws/smithy/kotlin/runtime/http/HttpStatusCode;)V", "getHeaders", "()Laws/smithy/kotlin/runtime/http/HeadersBuilder;", "getBody", "()Laws/smithy/kotlin/runtime/http/HttpBody;", "setBody", "(Laws/smithy/kotlin/runtime/http/HttpBody;)V", "build", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "deepCopy", "toString", "", "http"})
public final class HttpResponseBuilder
implements CanDeepCopy<HttpResponseBuilder> {
    @NotNull
    private HttpStatusCode status;
    @NotNull
    private final HeadersBuilder headers;
    @NotNull
    private HttpBody body;

    private HttpResponseBuilder(HttpStatusCode status, HeadersBuilder headers, HttpBody body) {
        this.status = status;
        this.headers = headers;
        this.body = body;
    }

    @NotNull
    public final HttpStatusCode getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull HttpStatusCode httpStatusCode) {
        Intrinsics.checkNotNullParameter((Object)httpStatusCode, (String)"<set-?>");
        this.status = httpStatusCode;
    }

    @NotNull
    public final HeadersBuilder getHeaders() {
        return this.headers;
    }

    @NotNull
    public final HttpBody getBody() {
        return this.body;
    }

    public final void setBody(@NotNull HttpBody httpBody) {
        Intrinsics.checkNotNullParameter((Object)httpBody, (String)"<set-?>");
        this.body = httpBody;
    }

    public HttpResponseBuilder() {
        this(HttpStatusCode.Companion.getOK(), new HeadersBuilder(), HttpBody.Empty.INSTANCE);
    }

    @NotNull
    public final HttpResponse build() {
        return HttpResponseKt.HttpResponse(this.status, this.headers.isEmpty() ? Headers.Companion.getEmpty() : this.headers.build(), this.body);
    }

    @NotNull
    public HttpResponseBuilder deepCopy() {
        return new HttpResponseBuilder(this.status, this.headers.deepCopy(), this.body);
    }

    @NotNull
    public String toString() {
        return "HttpResponseBuilder(status=" + this.status + ", headers=" + (Object)((Object)this.headers) + ", body=" + this.body + ')';
    }
}

