/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.internal;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.http.engine.internal.HttpClientMetricAttributes;
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider;
import aws.smithy.kotlin.runtime.telemetry.metrics.AsyncMeasurement;
import aws.smithy.kotlin.runtime.telemetry.metrics.AsyncMeasurementHandle;
import aws.smithy.kotlin.runtime.telemetry.metrics.Histogram;
import aws.smithy.kotlin.runtime.telemetry.metrics.Meter;
import aws.smithy.kotlin.runtime.telemetry.metrics.MonotonicCounter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u00020\r2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0010\u001a\u00020\r2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R!\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR!\u0010 \u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b8\u0006\u00a2\u0006\f\n\u0004\b \u0010\u001d\u001a\u0004\b!\u0010\u001fR!\u0010\"\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010\u001d\u001a\u0004\b#\u0010\u001fR\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010&R\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010/\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b/\u0010,\u001a\u0004\b0\u0010.R!\u00101\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001b8\u0006\u00a2\u0006\f\n\u0004\b1\u0010\u001d\u001a\u0004\b2\u0010\u001fR$\u00108\u001a\u00020\n2\u0006\u00103\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u00105\"\u0004\b6\u00107R$\u0010;\u001a\u00020\n2\u0006\u00103\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u00105\"\u0004\b:\u00107R$\u0010>\u001a\u00020\n2\u0006\u00103\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u00105\"\u0004\b=\u00107R$\u0010A\u001a\u00020\n2\u0006\u00103\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u00105\"\u0004\b@\u00107R$\u0010D\u001a\u00020\n2\u0006\u00103\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u00105\"\u0004\bC\u00107R$\u0010G\u001a\u00020\n2\u0006\u00103\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u00105\"\u0004\bF\u00107\u00a8\u0006H"}, d2={"Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;", "Ljava/io/Closeable;", "Laws/smithy/kotlin/runtime/io/Closeable;", "", "scope", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "provider", "<init>", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;)V", "Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurement;", "", "Laws/smithy/kotlin/runtime/telemetry/metrics/LongAsyncMeasurement;", "measurement", "", "recordRequestsState", "(Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurement;)V", "recordConnectionState", "close", "()V", "Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "getProvider", "()Laws/smithy/kotlin/runtime/telemetry/TelemetryProvider;", "Laws/smithy/kotlin/runtime/telemetry/metrics/Meter;", "meter", "Laws/smithy/kotlin/runtime/telemetry/metrics/Meter;", "Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "", "Laws/smithy/kotlin/runtime/telemetry/metrics/DoubleHistogram;", "connectionAcquireDuration", "Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "getConnectionAcquireDuration", "()Laws/smithy/kotlin/runtime/telemetry/metrics/Histogram;", "requestsQueuedDuration", "getRequestsQueuedDuration", "connectionUptime", "getConnectionUptime", "Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurementHandle;", "connectionLimitHandle", "Laws/smithy/kotlin/runtime/telemetry/metrics/AsyncMeasurementHandle;", "connectionUsageHandle", "requestsConcurrencyLimitHandle", "requestsHandle", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "bytesSent", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "getBytesSent", "()Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "bytesReceived", "getBytesReceived", "timeToFirstByteDuration", "getTimeToFirstByteDuration", "value", "getConnectionsLimit", "()J", "setConnectionsLimit", "(J)V", "connectionsLimit", "getRequestConcurrencyLimit", "setRequestConcurrencyLimit", "requestConcurrencyLimit", "getIdleConnections", "setIdleConnections", "idleConnections", "getAcquiredConnections", "setAcquiredConnections", "acquiredConnections", "getQueuedRequests", "setQueuedRequests", "queuedRequests", "getInFlightRequests", "setInFlightRequests", "inFlightRequests", "http-client"})
@SourceDebugExtension(value={"SMAP\nHttpClientMetrics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientMetrics.kt\naws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics\n+ 2 AtomicFU.common.kt\nkotlinx/atomicfu/AtomicFU_commonKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n477#2,4:204\n477#2,4:208\n477#2,4:212\n477#2,4:216\n477#2,4:220\n477#2,4:224\n1#3:228\n1#3:239\n1617#4,9:229\n1869#4:238\n1870#4:240\n1626#4:241\n1869#4,2:242\n*S KotlinDebug\n*F\n+ 1 HttpClientMetrics.kt\naws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics\n*L\n131#1:204,4\n140#1:208,4\n149#1:212,4\n158#1:216,4\n167#1:220,4\n176#1:224,4\n195#1:239\n195#1:229,9\n195#1:238\n195#1:240\n195#1:241\n198#1:242,2\n*E\n"})
public final class HttpClientMetrics
implements Closeable {
    @NotNull
    private final TelemetryProvider provider;
    @NotNull
    private final Meter meter;
    @NotNull
    private volatile /* synthetic */ long _connectionsLimit;
    private static final /* synthetic */ AtomicLongFieldUpdater _connectionsLimit$FU;
    @NotNull
    private volatile /* synthetic */ long _idleConnections;
    private static final /* synthetic */ AtomicLongFieldUpdater _idleConnections$FU;
    @NotNull
    private volatile /* synthetic */ long _acquiredConnections;
    private static final /* synthetic */ AtomicLongFieldUpdater _acquiredConnections$FU;
    @NotNull
    private volatile /* synthetic */ long _requestConcurrencyLimit;
    private static final /* synthetic */ AtomicLongFieldUpdater _requestConcurrencyLimit$FU;
    @NotNull
    private volatile /* synthetic */ long _queuedRequests;
    private static final /* synthetic */ AtomicLongFieldUpdater _queuedRequests$FU;
    @NotNull
    private volatile /* synthetic */ long _inFlightRequests;
    private static final /* synthetic */ AtomicLongFieldUpdater _inFlightRequests$FU;
    @NotNull
    private final Histogram<Double> connectionAcquireDuration;
    @NotNull
    private final Histogram<Double> requestsQueuedDuration;
    @NotNull
    private final Histogram<Double> connectionUptime;
    @NotNull
    private final AsyncMeasurementHandle connectionLimitHandle;
    @NotNull
    private final AsyncMeasurementHandle connectionUsageHandle;
    @NotNull
    private final AsyncMeasurementHandle requestsConcurrencyLimitHandle;
    @NotNull
    private final AsyncMeasurementHandle requestsHandle;
    @NotNull
    private final MonotonicCounter bytesSent;
    @NotNull
    private final MonotonicCounter bytesReceived;
    @NotNull
    private final Histogram<Double> timeToFirstByteDuration;

    public HttpClientMetrics(@NotNull String scope, @NotNull TelemetryProvider provider) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        this.meter = this.provider.getMeterProvider().getOrCreateMeter(scope);
        this._connectionsLimit = 0L;
        this._idleConnections = 0L;
        this._acquiredConnections = 0L;
        this._requestConcurrencyLimit = 0L;
        this._queuedRequests = 0L;
        this._inFlightRequests = 0L;
        this.connectionAcquireDuration = this.meter.createDoubleHistogram("smithy.client.http.connections.acquire_duration", "s", "The amount of time requests take to acquire a connection from the pool");
        this.requestsQueuedDuration = this.meter.createDoubleHistogram("smithy.client.http.requests.queued_duration", "s", "The amount of time a request spent queued waiting to be executed by the HTTP client");
        this.connectionUptime = this.meter.createDoubleHistogram("smithy.client.http.connections.uptime", "s", "The amount of time a connection has been open");
        this.connectionLimitHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.connections.limit", arg_0 -> HttpClientMetrics.connectionLimitHandle$lambda$0(this, arg_0), "{connection}", "Max connections configured for the HTTP client");
        this.connectionUsageHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.connections.usage", (Function1)new Function1<AsyncMeasurement<Long>, Unit>((Object)this){

            public final void invoke(AsyncMeasurement<Long> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                HttpClientMetrics.access$recordConnectionState((HttpClientMetrics)this.receiver, p0);
            }
        }, "{connection}", "Current state of connections (idle, acquired)");
        this.requestsConcurrencyLimitHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.requests.limit", arg_0 -> HttpClientMetrics.requestsConcurrencyLimitHandle$lambda$1(this, arg_0), "{request}", "Max concurrent requests configured for the HTTP client");
        this.requestsHandle = this.meter.createAsyncUpDownCounter("smithy.client.http.requests.usage", (Function1)new Function1<AsyncMeasurement<Long>, Unit>((Object)this){

            public final void invoke(AsyncMeasurement<Long> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                HttpClientMetrics.access$recordRequestsState((HttpClientMetrics)this.receiver, p0);
            }
        }, "{request}", "The current state of HTTP client request concurrency (queued, in-flight)");
        this.bytesSent = this.meter.createMonotonicCounter("smithy.client.http.bytes_sent", "By", "The total number of bytes sent by the HTTP client");
        this.bytesReceived = this.meter.createMonotonicCounter("smithy.client.http.bytes_received", "By", "The total number of bytes received by the HTTP client");
        this.timeToFirstByteDuration = this.meter.createDoubleHistogram("smithy.client.http.time_to_first_byte", "s", "The amount of time after a request has been sent spent waiting on a response from the remote server");
    }

    @NotNull
    public final TelemetryProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final Histogram<Double> getConnectionAcquireDuration() {
        return this.connectionAcquireDuration;
    }

    @NotNull
    public final Histogram<Double> getRequestsQueuedDuration() {
        return this.requestsQueuedDuration;
    }

    @NotNull
    public final Histogram<Double> getConnectionUptime() {
        return this.connectionUptime;
    }

    @NotNull
    public final MonotonicCounter getBytesSent() {
        return this.bytesSent;
    }

    @NotNull
    public final MonotonicCounter getBytesReceived() {
        return this.bytesReceived;
    }

    @NotNull
    public final Histogram<Double> getTimeToFirstByteDuration() {
        return this.timeToFirstByteDuration;
    }

    public final long getConnectionsLimit() {
        return this._connectionsLimit;
    }

    public final void setConnectionsLimit(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._connectionsLimit;
            boolean bl = false;
        } while (!_connectionsLimit$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getRequestConcurrencyLimit() {
        return this._requestConcurrencyLimit;
    }

    public final void setRequestConcurrencyLimit(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._requestConcurrencyLimit;
            boolean bl = false;
        } while (!_requestConcurrencyLimit$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getIdleConnections() {
        return this._idleConnections;
    }

    public final void setIdleConnections(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._idleConnections;
            boolean bl = false;
        } while (!_idleConnections$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getAcquiredConnections() {
        return this._acquiredConnections;
    }

    public final void setAcquiredConnections(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._acquiredConnections;
            boolean bl = false;
        } while (!_acquiredConnections$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getQueuedRequests() {
        return this._queuedRequests;
    }

    public final void setQueuedRequests(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._queuedRequests;
            boolean bl = false;
        } while (!_queuedRequests$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    public final long getInFlightRequests() {
        return this._inFlightRequests;
    }

    public final void setInFlightRequests(long value) {
        long upd$iv;
        long cur$iv;
        HttpClientMetrics $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            long it = cur$iv = $this$update$iv._inFlightRequests;
            boolean bl = false;
        } while (!_inFlightRequests$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = value));
    }

    private final void recordRequestsState(AsyncMeasurement<Long> measurement) {
        AsyncMeasurement.record$default(measurement, (Number)this.getInFlightRequests(), (Attributes)HttpClientMetricAttributes.INSTANCE.getInFlightRequest(), null, (int)4, null);
        AsyncMeasurement.record$default(measurement, (Number)this.getQueuedRequests(), (Attributes)HttpClientMetricAttributes.INSTANCE.getQueuedRequest(), null, (int)4, null);
    }

    private final void recordConnectionState(AsyncMeasurement<Long> measurement) {
        AsyncMeasurement.record$default(measurement, (Number)this.getIdleConnections(), (Attributes)HttpClientMetricAttributes.INSTANCE.getIdleConnection(), null, (int)4, null);
        AsyncMeasurement.record$default(measurement, (Number)this.getAcquiredConnections(), (Attributes)HttpClientMetricAttributes.INSTANCE.getAcquiredConnection(), null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void $this$mapNotNullTo$iv$iv;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$82;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$72;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$62;
        Object $i$a$-runCatching-HttpClientMetrics$close$exceptions$52;
        Object object = new Result[4];
        AsyncMeasurementHandle asyncMeasurementHandle = this.connectionLimitHandle;
        int n = 0;
        Object[] objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$52 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$52 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$52 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$52;
        objectArray[n] = Result.box-impl((Object)object2);
        asyncMeasurementHandle = this.connectionUsageHandle;
        n = 1;
        objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$62 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$62 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$62 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$62;
        objectArray[n] = Result.box-impl((Object)object2);
        asyncMeasurementHandle = this.requestsHandle;
        n = 2;
        objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$72 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$72 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$72 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$72;
        objectArray[n] = Result.box-impl((Object)object2);
        asyncMeasurementHandle = this.requestsConcurrencyLimitHandle;
        n = 3;
        objectArray = object;
        try {
            boolean $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = false;
            asyncMeasurementHandle.stop();
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = $i$a$-runCatching-HttpClientMetrics$close$exceptions$82;
        objectArray[n] = Result.box-impl((Object)object2);
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])object);
        boolean $i$f$mapNotNull = false;
        $i$a$-runCatching-HttpClientMetrics$close$exceptions$82 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Throwable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Object p0 = ((Result)element$iv$iv).unbox-impl();
            boolean bl2 = false;
            if (Result.exceptionOrNull-impl((Object)p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List exceptions = (List)destination$iv$iv;
        object = (Throwable)CollectionsKt.firstOrNull((List)exceptions);
        if (object != null) {
            Object first = object;
            boolean bl = false;
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)exceptions, (int)1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable p0 = (Throwable)element$iv;
                boolean bl4 = false;
                ((Throwable)first).addSuppressed(p0);
            }
            throw first;
        }
    }

    private static final Unit connectionLimitHandle$lambda$0(HttpClientMetrics this$0, AsyncMeasurement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AsyncMeasurement.record$default((AsyncMeasurement)it, (Number)this$0._connectionsLimit, null, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit requestsConcurrencyLimitHandle$lambda$1(HttpClientMetrics this$0, AsyncMeasurement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AsyncMeasurement.record$default((AsyncMeasurement)it, (Number)this$0._requestConcurrencyLimit, null, null, (int)6, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$recordConnectionState(HttpClientMetrics $this, AsyncMeasurement measurement) {
        $this.recordConnectionState((AsyncMeasurement<Long>)measurement);
    }

    public static final /* synthetic */ void access$recordRequestsState(HttpClientMetrics $this, AsyncMeasurement measurement) {
        $this.recordRequestsState((AsyncMeasurement<Long>)measurement);
    }

    static {
        _connectionsLimit$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_connectionsLimit");
        _idleConnections$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_idleConnections");
        _acquiredConnections$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_acquiredConnections");
        _requestConcurrencyLimit$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_requestConcurrencyLimit");
        _queuedRequests$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_queuedRequests");
        _inFlightRequests$FU = AtomicLongFieldUpdater.newUpdater(HttpClientMetrics.class, "_inFlightRequests");
    }
}

