/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine;

import aws.smithy.kotlin.runtime.http.engine.EnvironmentProxySelectorKt;
import aws.smithy.kotlin.runtime.http.engine.NonProxyHost;
import aws.smithy.kotlin.runtime.http.engine.ProxyConfig;
import aws.smithy.kotlin.runtime.http.engine.ProxySelector;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.url.Url;
import aws.smithy.kotlin.runtime.util.EnvironmentProvider;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import aws.smithy.kotlin.runtime.util.PropertyProvider;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u001d\u0010\u0012\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0014\u0010\u0011R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u000f\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001c"}, d2={"Laws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector;", "Laws/smithy/kotlin/runtime/http/engine/ProxySelector;", "Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;", "provider", "<init>", "(Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;)V", "Laws/smithy/kotlin/runtime/net/url/Url;", "url", "Laws/smithy/kotlin/runtime/http/engine/ProxyConfig;", "select", "(Laws/smithy/kotlin/runtime/net/url/Url;)Laws/smithy/kotlin/runtime/http/engine/ProxyConfig;", "", "nonProxy", "(Laws/smithy/kotlin/runtime/net/url/Url;)Z", "httpProxy$delegate", "Lkotlin/Lazy;", "getHttpProxy", "()Laws/smithy/kotlin/runtime/http/engine/ProxyConfig;", "httpProxy", "httpsProxy$delegate", "getHttpsProxy", "httpsProxy", "", "Laws/smithy/kotlin/runtime/http/engine/NonProxyHost;", "nonProxyHosts$delegate", "getNonProxyHosts", "()Ljava/util/Set;", "nonProxyHosts", "http-client"})
@SourceDebugExtension(value={"SMAP\nEnvironmentProxySelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentProxySelector.kt\naws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n1761#2,3:161\n*S KotlinDebug\n*F\n+ 1 EnvironmentProxySelector.kt\naws/smithy/kotlin/runtime/http/engine/EnvironmentProxySelector\n*L\n50#1:161,3\n*E\n"})
public final class EnvironmentProxySelector
implements ProxySelector {
    @NotNull
    private final Lazy httpProxy$delegate;
    @NotNull
    private final Lazy httpsProxy$delegate;
    @NotNull
    private final Lazy nonProxyHosts$delegate;

    public EnvironmentProxySelector(@NotNull PlatformEnvironProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.httpProxy$delegate = LazyKt.lazy(() -> EnvironmentProxySelector.httpProxy_delegate$lambda$0(provider));
        this.httpsProxy$delegate = LazyKt.lazy(() -> EnvironmentProxySelector.httpsProxy_delegate$lambda$1(provider));
        this.nonProxyHosts$delegate = LazyKt.lazy(() -> EnvironmentProxySelector.nonProxyHosts_delegate$lambda$2(provider));
    }

    public /* synthetic */ EnvironmentProxySelector(PlatformEnvironProvider platformEnvironProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            platformEnvironProvider = (PlatformEnvironProvider)PlatformProvider.Companion.getSystem();
        }
        this(platformEnvironProvider);
    }

    private final ProxyConfig getHttpProxy() {
        Lazy lazy = this.httpProxy$delegate;
        return (ProxyConfig)lazy.getValue();
    }

    private final ProxyConfig getHttpsProxy() {
        Lazy lazy = this.httpsProxy$delegate;
        return (ProxyConfig)lazy.getValue();
    }

    private final Set<NonProxyHost> getNonProxyHosts() {
        Lazy lazy = this.nonProxyHosts$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public ProxyConfig select(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.getHttpProxy() == null && this.getHttpsProxy() == null || this.nonProxy(url)) {
            return ProxyConfig.Direct.INSTANCE;
        }
        Scheme scheme = url.getScheme();
        ProxyConfig proxyConfig = Intrinsics.areEqual((Object)scheme, (Object)Scheme.Companion.getHTTP()) ? this.getHttpProxy() : (Intrinsics.areEqual((Object)scheme, (Object)Scheme.Companion.getHTTPS()) ? this.getHttpsProxy() : null);
        ProxyConfig proxyConfig2 = proxyConfig;
        if (proxyConfig2 == null) {
            proxyConfig2 = ProxyConfig.Direct.INSTANCE;
        }
        return proxyConfig2;
    }

    private final boolean nonProxy(Url url) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getNonProxyHosts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NonProxyHost it = (NonProxyHost)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final ProxyConfig httpProxy_delegate$lambda$0(PlatformEnvironProvider $provider) {
        ProxyConfig proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByProperty((PropertyProvider)$provider, Scheme.Companion.getHTTP());
        if (proxyConfig == null) {
            proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByEnvironment((EnvironmentProvider)$provider, Scheme.Companion.getHTTP());
        }
        return proxyConfig;
    }

    private static final ProxyConfig httpsProxy_delegate$lambda$1(PlatformEnvironProvider $provider) {
        ProxyConfig proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByProperty((PropertyProvider)$provider, Scheme.Companion.getHTTPS());
        if (proxyConfig == null) {
            proxyConfig = EnvironmentProxySelectorKt.access$resolveProxyByEnvironment((EnvironmentProvider)$provider, Scheme.Companion.getHTTPS());
        }
        return proxyConfig;
    }

    private static final Set nonProxyHosts_delegate$lambda$2(PlatformEnvironProvider $provider) {
        return EnvironmentProxySelectorKt.access$resolveNonProxyHosts($provider);
    }

    public EnvironmentProxySelector() {
        this(null, 1, null);
    }
}

