/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.http.engine.AlpnId;
import aws.smithy.kotlin.runtime.http.engine.TlsContext;
import aws.smithy.kotlin.runtime.http.engine.internal.HttpClientMetrics;
import aws.smithy.kotlin.runtime.http.engine.okhttp.EventListenerChain;
import aws.smithy.kotlin.runtime.http.engine.okhttp.HttpEngineEventListener;
import aws.smithy.kotlin.runtime.http.engine.okhttp.MetricsInterceptor;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpDns;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpEngineConfig;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpProxyAuthenticator;
import aws.smithy.kotlin.runtime.http.engine.okhttp.OkHttpProxySelector;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.time.Duration;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.TlsVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a1\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u0006\"\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"buildClient", "Lokhttp3/OkHttpClient;", "Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineConfig;", "metrics", "Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;", "clientScopedEventListeners", "", "Lokhttp3/EventListener;", "(Laws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineConfig;Laws/smithy/kotlin/runtime/http/engine/internal/HttpClientMetrics;[Lokhttp3/EventListener;)Lokhttp3/OkHttpClient;", "minTlsConnectionSpec", "Lokhttp3/ConnectionSpec;", "tlsContext", "Laws/smithy/kotlin/runtime/http/engine/TlsContext;", "toOkHttpTlsVersion", "Lokhttp3/TlsVersion;", "sdkTlsVersion", "Laws/smithy/kotlin/runtime/net/TlsVersion;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nOkHttpEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpEngine.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,182:1\n1617#2,9:183\n1869#2:192\n1870#2:194\n1626#2:195\n1563#2:199\n1634#2,3:200\n1#3:193\n3829#4:196\n4344#4,2:197\n37#5:203\n36#5,3:204\n*S KotlinDebug\n*F\n+ 1 OkHttpEngine.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/OkHttpEngineKt\n*L\n142#1:183,9\n142#1:192\n142#1:194\n142#1:195\n168#1:199\n168#1:200,3\n142#1:193\n166#1:196\n166#1:197,2\n169#1:203\n169#1:204,3\n*E\n"})
public final class OkHttpEngineKt {
    /*
     * WARNING - void declaration
     */
    @InternalApi
    @NotNull
    public static final OkHttpClient buildClient(@NotNull OkHttpEngineConfig $this$buildClient, @NotNull HttpClientMetrics metrics, EventListener ... clientScopedEventListeners) {
        Dispatcher dispatcher;
        OkHttpClient.Builder builder;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$buildClient), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)clientScopedEventListeners, (String)"clientScopedEventListeners");
        OkHttpEngineConfig config = $this$buildClient;
        OkHttpClient.Builder $this$buildClient_u24lambda_u243 = builder = new OkHttpClient.Builder();
        boolean bl = false;
        $this$buildClient_u24lambda_u243.followRedirects(false);
        $this$buildClient_u24lambda_u243.followSslRedirects(false);
        Object[] objectArray = new ConnectionSpec[]{OkHttpEngineKt.minTlsConnectionSpec(config.getTlsContext()), ConnectionSpec.CLEARTEXT};
        $this$buildClient_u24lambda_u243.connectionSpecs(CollectionsKt.listOf((Object[])objectArray));
        $this$buildClient_u24lambda_u243.retryOnConnectionFailure(false);
        long l = config.getConnectTimeout-UwyO8pc();
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        $this$buildClient_u24lambda_u243.connectTimeout(duration);
        l = config.getSocketReadTimeout-UwyO8pc();
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration2 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"toComponents-impl(...)");
        $this$buildClient_u24lambda_u243.readTimeout(duration2);
        l = config.getSocketWriteTimeout-UwyO8pc();
        n = Duration.getNanosecondsComponent-impl((long)l);
        l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration3 = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"toComponents-impl(...)");
        $this$buildClient_u24lambda_u243.writeTimeout(duration3);
        ConnectionPool pool = new ConnectionPool(5, Duration.getInWholeMilliseconds-impl((long)config.getConnectionIdleTimeout-UwyO8pc()), TimeUnit.MILLISECONDS);
        $this$buildClient_u24lambda_u243.connectionPool(pool);
        Dispatcher $this$buildClient_u24lambda_u243_u24lambda_u240 = dispatcher = new Dispatcher();
        boolean bl2 = false;
        $this$buildClient_u24lambda_u243_u24lambda_u240.setMaxRequests(config.getMaxConcurrency-pVg5ArA());
        $this$buildClient_u24lambda_u243_u24lambda_u240.setMaxRequestsPerHost(config.getMaxConcurrencyPerHost-pVg5ArA());
        Dispatcher dispatcher2 = dispatcher;
        $this$buildClient_u24lambda_u243.dispatcher(dispatcher2);
        $this$buildClient_u24lambda_u243.eventListenerFactory(arg_0 -> OkHttpEngineKt.buildClient$lambda$3$lambda$1(pool, config, dispatcher2, metrics, clientScopedEventListeners, arg_0));
        if (!((Collection)config.getTlsContext().getAlpn()).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = config.getTlsContext().getAlpn();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Protocol protocol;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                AlpnId it = (AlpnId)element$iv$iv;
                boolean bl4 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1: {
                        protocol = Protocol.HTTP_1_1;
                        break;
                    }
                    case 2: {
                        protocol = Protocol.HTTP_2;
                        break;
                    }
                    case 3: {
                        protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                        break;
                    }
                    default: {
                        protocol = null;
                    }
                }
                if (protocol == null) continue;
                Protocol it$iv$iv = protocol;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List protocols = (List)destination$iv$iv;
            $this$buildClient_u24lambda_u243.protocols(protocols);
        }
        $this$buildClient_u24lambda_u243.proxySelector((ProxySelector)new OkHttpProxySelector(config.getProxySelector()));
        $this$buildClient_u24lambda_u243.proxyAuthenticator((Authenticator)new OkHttpProxyAuthenticator(config.getProxySelector()));
        $this$buildClient_u24lambda_u243.dns((Dns)new OkHttpDns(config.getHostResolver()));
        $this$buildClient_u24lambda_u243.addInterceptor((Interceptor)MetricsInterceptor.INSTANCE);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    private static final ConnectionSpec minTlsConnectionSpec(TlsContext tlsContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        aws.smithy.kotlin.runtime.net.TlsVersion tlsVersion = tlsContext.getMinVersion();
        if (tlsVersion == null) {
            tlsVersion = aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_2;
        }
        aws.smithy.kotlin.runtime.net.TlsVersion minVersion = tlsVersion;
        aws.smithy.kotlin.runtime.net.TlsVersion[] $this$filter$iv = aws.smithy.kotlin.runtime.net.TlsVersion.values();
        boolean $i$f$filter = false;
        aws.smithy.kotlin.runtime.net.TlsVersion[] tlsVersionArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (aws.smithy.kotlin.runtime.net.TlsVersion element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(it.compareTo((Enum)minVersion) >= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            aws.smithy.kotlin.runtime.net.TlsVersion element$iv$iv;
            element$iv$iv = (aws.smithy.kotlin.runtime.net.TlsVersion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(OkHttpEngineKt.toOkHttpTlsVersion((aws.smithy.kotlin.runtime.net.TlsVersion)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        TlsVersion[] okHttpTlsVersions = thisCollection$iv.toArray(new TlsVersion[0]);
        return new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(Arrays.copyOf(okHttpTlsVersions, okHttpTlsVersions.length)).build();
    }

    private static final TlsVersion toOkHttpTlsVersion(aws.smithy.kotlin.runtime.net.TlsVersion sdkTlsVersion) {
        TlsVersion tlsVersion;
        switch (WhenMappings.$EnumSwitchMapping$1[sdkTlsVersion.ordinal()]) {
            case 1: {
                tlsVersion = TlsVersion.TLS_1_0;
                break;
            }
            case 2: {
                tlsVersion = TlsVersion.TLS_1_1;
                break;
            }
            case 3: {
                tlsVersion = TlsVersion.TLS_1_2;
                break;
            }
            case 4: {
                tlsVersion = TlsVersion.TLS_1_3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return tlsVersion;
    }

    private static final EventListener buildClient$lambda$3$lambda$1(ConnectionPool $pool, OkHttpEngineConfig $config, Dispatcher $dispatcher, HttpClientMetrics $metrics, EventListener[] $clientScopedEventListeners, Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)new HttpEngineEventListener($pool, $config.getHostResolver(), $dispatcher, $metrics, call));
        spreadBuilder.addSpread((Object)$clientScopedEventListeners);
        return new EventListenerChain(CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new EventListener[spreadBuilder.size()])));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AlpnId.values().length];
            try {
                nArray[AlpnId.HTTP1_1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlpnId.HTTP2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlpnId.H2_PRIOR_KNOWLEDGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[aws.smithy.kotlin.runtime.net.TlsVersion.values().length];
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_1.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[aws.smithy.kotlin.runtime.net.TlsVersion.TLS_1_3.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

