/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.collections.AttributesBuilder;
import aws.smithy.kotlin.runtime.http.engine.okhttp.MetricsInterceptorKt;
import aws.smithy.kotlin.runtime.http.engine.okhttp.SdkRequestTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/MetricsInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "http-client-engine-okhttp"})
@SourceDebugExtension(value={"SMAP\nMetricsInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricsInterceptor.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/MetricsInterceptor\n+ 2 Attributes.kt\naws/smithy/kotlin/runtime/collections/AttributesKt\n*L\n1#1,113:1\n243#2:114\n226#2:115\n*S KotlinDebug\n*F\n+ 1 MetricsInterceptor.kt\naws/smithy/kotlin/runtime/http/engine/okhttp/MetricsInterceptor\n*L\n23#1:114\n23#1:115\n*E\n"})
public final class MetricsInterceptor
implements Interceptor {
    @NotNull
    public static final MetricsInterceptor INSTANCE = new MetricsInterceptor();

    private MetricsInterceptor() {
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Request request;
        AttributesBuilder attributesBuilder;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        SdkRequestTag sdkRequestTag = (SdkRequestTag)originalRequest.tag(SdkRequestTag.class);
        if (sdkRequestTag == null || (sdkRequestTag = sdkRequestTag.getMetrics()) == null) {
            return chain.proceed(originalRequest);
        }
        SdkRequestTag metrics = sdkRequestTag;
        boolean $i$f$attributesOf = false;
        boolean $i$f$mutableAttributesOf = false;
        AttributesBuilder $this$intercept_u24lambda_u240 = attributesBuilder = new AttributesBuilder();
        boolean bl = false;
        $this$intercept_u24lambda_u240.to("server.address", (Object)(originalRequest.url().host() + ':' + originalRequest.url().port()));
        Attributes attrs = (Attributes)attributesBuilder.getAttributes();
        if (originalRequest.body() != null) {
            RequestBody requestBody = originalRequest.body();
            request = originalRequest.newBuilder().method(originalRequest.method(), requestBody != null ? MetricsInterceptorKt.instrument(requestBody, metrics.getBytesSent(), attrs) : null).build();
        } else {
            request = originalRequest;
        }
        Request request2 = request;
        Response originalResponse = chain.proceed(request2);
        Response response = originalResponse.body().contentLength() == 0L ? originalResponse : originalResponse.newBuilder().body(MetricsInterceptorKt.instrument(originalResponse.body(), metrics.getBytesReceived(), attrs)).build();
        return response;
    }
}

