/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.engine.okhttp;

import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.telemetry.metrics.MonotonicCounter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Laws/smithy/kotlin/runtime/http/engine/okhttp/InstrumentedSource;", "Lokio/Source;", "delegate", "counter", "Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;", "attributes", "Laws/smithy/kotlin/runtime/collections/Attributes;", "<init>", "(Lokio/Source;Laws/smithy/kotlin/runtime/telemetry/metrics/MonotonicCounter;Laws/smithy/kotlin/runtime/collections/Attributes;)V", "timeout", "Lokio/Timeout;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "close", "", "http-client-engine-okhttp"})
public final class InstrumentedSource
implements Source {
    @NotNull
    private final Source delegate;
    @NotNull
    private final MonotonicCounter counter;
    @NotNull
    private final Attributes attributes;

    public InstrumentedSource(@NotNull Source delegate, @NotNull MonotonicCounter counter, @NotNull Attributes attributes) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)counter, (String)"counter");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.delegate = delegate;
        this.counter = counter;
        this.attributes = attributes;
    }

    @NotNull
    public Timeout timeout() {
        return this.delegate.timeout();
    }

    public long read(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long rc = this.delegate.read(sink, byteCount);
        if (rc > 0L) {
            MonotonicCounter.add$default((MonotonicCounter)this.counter, (long)rc, (Attributes)this.attributes, null, (int)4, null);
        }
        return rc;
    }

    public void close() {
        this.delegate.close();
    }
}

