/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.awsprotocol.eventstream;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.hashing.Crc32;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.io.HashingSink;
import aws.smithy.kotlin.runtime.io.HashingSource;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.io.SdkBufferedSource;
import aws.smithy.kotlin.runtime.io.SdkIoKt;
import aws.smithy.kotlin.runtime.io.SdkSink;
import aws.smithy.kotlin.runtime.io.SdkSource;
import aws.smithy.kotlin.runtime.io.SdkSourceKt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Prelude;", "", "totalLen", "", "headersLength", "<init>", "(II)V", "getTotalLen", "()I", "getHeadersLength", "payloadLen", "getPayloadLen", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/SdkBufferedSink;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "aws-event-stream"})
public final class Prelude {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int totalLen;
    private final int headersLength;

    public Prelude(int totalLen, int headersLength) {
        this.totalLen = totalLen;
        this.headersLength = headersLength;
    }

    public final int getTotalLen() {
        return this.totalLen;
    }

    public final int getHeadersLength() {
        return this.headersLength;
    }

    public final int getPayloadLen() {
        return this.totalLen - 12 - this.headersLength - 4;
    }

    public final void encode(@NotNull SdkBufferedSink dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        HashingSink sink = new HashingSink((HashFunction)new Crc32(), (SdkSink)dest);
        SdkBufferedSink buffer = SdkIoKt.buffer((SdkSink)((SdkSink)sink));
        buffer.writeInt(this.totalLen);
        buffer.writeInt(this.headersLength);
        buffer.emit();
        SdkBufferedSink.write$default((SdkBufferedSink)dest, (byte[])sink.digest(), (int)0, (int)0, (int)6, null);
    }

    public final int component1() {
        return this.totalLen;
    }

    public final int component2() {
        return this.headersLength;
    }

    @NotNull
    public final Prelude copy(int totalLen, int headersLength) {
        return new Prelude(totalLen, headersLength);
    }

    public static /* synthetic */ Prelude copy$default(Prelude prelude, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = prelude.totalLen;
        }
        if ((n3 & 2) != 0) {
            n2 = prelude.headersLength;
        }
        return prelude.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Prelude(totalLen=" + this.totalLen + ", headersLength=" + this.headersLength + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.totalLen);
        result = result * 31 + Integer.hashCode(this.headersLength);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Prelude)) {
            return false;
        }
        Prelude prelude = (Prelude)other;
        if (this.totalLen != prelude.totalLen) {
            return false;
        }
        return this.headersLength == prelude.headersLength;
    }

    @InternalApi
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Prelude$Companion;", "", "<init>", "()V", "decode", "Laws/smithy/kotlin/runtime/awsprotocol/eventstream/Prelude;", "source", "Laws/smithy/kotlin/runtime/io/SdkBufferedSource;", "aws-event-stream"})
    @SourceDebugExtension(value={"SMAP\nPrelude.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Prelude.kt\naws/smithy/kotlin/runtime/awsprotocol/eventstream/Prelude$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n1#2:69\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Prelude decode(@NotNull SdkBufferedSource source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (!source.request(12L)) {
                boolean $i$a$-check-Prelude$Companion$decode$52 = false;
                String $i$a$-check-Prelude$Companion$decode$52 = "Invalid message prelude";
                throw new IllegalStateException($i$a$-check-Prelude$Companion$decode$52.toString());
            }
            HashingSource crcSource = new HashingSource((HashFunction)new Crc32(), (SdkSource)source);
            SdkBuffer buffer = new SdkBuffer();
            SdkSourceKt.readFully((SdkSource)((SdkSource)crcSource), (SdkBuffer)buffer, (long)8L);
            byte[] expectedCrc = source.readByteArray(4L);
            byte[] computedCrc = crcSource.digest();
            int totalLen = buffer.readInt();
            int headerLen = buffer.readInt();
            if (!(totalLen <= 0x1800000)) {
                boolean $i$a$-check-Prelude$Companion$decode$62 = false;
                String $i$a$-check-Prelude$Companion$decode$62 = "Invalid Message size: " + totalLen;
                throw new IllegalStateException($i$a$-check-Prelude$Companion$decode$62.toString());
            }
            if (!(headerLen <= 131072)) {
                boolean $i$a$-check-Prelude$Companion$decode$72 = false;
                String $i$a$-check-Prelude$Companion$decode$72 = "Invalid Header size: " + headerLen;
                throw new IllegalStateException($i$a$-check-Prelude$Companion$decode$72.toString());
            }
            if (!Arrays.equals(expectedCrc, computedCrc)) {
                boolean bl = false;
                String string = "Prelude checksum mismatch; expected=0x" + HexKt.encodeToHex((byte[])expectedCrc) + "; calculated=0x" + HexKt.encodeToHex((byte[])computedCrc);
                throw new IllegalStateException(string.toString());
            }
            return new Prelude(totalLen, headerLen);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

