/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.dynamodb.endpoints;

import aws.sdk.kotlin.runtime.endpoint.functions.Arn;
import aws.sdk.kotlin.runtime.endpoint.functions.PartitionConfig;
import aws.sdk.kotlin.services.dynamodb.endpoints.DynamoDbEndpointParameters;
import aws.sdk.kotlin.services.dynamodb.endpoints.DynamoDbEndpointProvider;
import aws.sdk.kotlin.services.dynamodb.endpoints.internal.PartitionsKt;
import aws.smithy.kotlin.runtime.businessmetrics.BusinessMetricsUtilsKt;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException;
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextKt;
import aws.smithy.kotlin.runtime.client.endpoints.functions.FunctionsKt;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.collections.AttributesBuilder;
import aws.smithy.kotlin.runtime.collections.ValuesMap;
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthSchemeKt;
import aws.smithy.kotlin.runtime.net.url.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Laws/sdk/kotlin/services/dynamodb/endpoints/DefaultDynamoDbEndpointProvider;", "Laws/sdk/kotlin/services/dynamodb/endpoints/DynamoDbEndpointProvider;", "<init>", "()V", "resolveEndpoint", "Laws/smithy/kotlin/runtime/client/endpoints/Endpoint;", "params", "Laws/sdk/kotlin/services/dynamodb/endpoints/DynamoDbEndpointParameters;", "(Laws/sdk/kotlin/services/dynamodb/endpoints/DynamoDbEndpointParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dynamodb"})
@SourceDebugExtension(value={"SMAP\nDefaultDynamoDbEndpointProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDynamoDbEndpointProvider.kt\naws/sdk/kotlin/services/dynamodb/endpoints/DefaultDynamoDbEndpointProvider\n+ 2 Attributes.kt\naws/smithy/kotlin/runtime/collections/AttributesKt\n*L\n1#1,244:1\n243#2:245\n226#2:246\n243#2:247\n226#2:248\n243#2:249\n226#2:250\n*S KotlinDebug\n*F\n+ 1 DefaultDynamoDbEndpointProvider.kt\naws/sdk/kotlin/services/dynamodb/endpoints/DefaultDynamoDbEndpointProvider\n*L\n37#1:245\n37#1:246\n65#1:247\n65#1:248\n205#1:249\n205#1:250\n*E\n"})
public final class DefaultDynamoDbEndpointProvider
implements DynamoDbEndpointProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object resolveEndpoint(@NotNull DynamoDbEndpointParameters params, @NotNull Continuation<? super Endpoint> $completion) {
        if (params.getEndpoint() != null) {
            void $this$resolveEndpoint_u24lambda_u240;
            AttributesBuilder attributesBuilder;
            if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            boolean $i$f$attributesOf = false;
            boolean $i$f$mutableAttributesOf = false;
            AttributesBuilder attributesBuilder2 = attributesBuilder = new AttributesBuilder();
            ValuesMap valuesMap = null;
            Url url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)String.valueOf(params.getEndpoint()), null, (int)2, null);
            boolean bl = false;
            $this$resolveEndpoint_u24lambda_u240.to(BusinessMetricsUtilsKt.getServiceEndpointOverride(), (Object)Boxing.boxBoolean((boolean)true));
            Unit unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            Attributes attributes = (Attributes)attributesBuilder.getAttributes();
            ValuesMap valuesMap2 = valuesMap;
            Url url2 = url;
            return new Endpoint(url2, valuesMap2, attributes, n, defaultConstructorMarker);
        }
        if (params.getRegion() != null) {
            DefaultDynamoDbEndpointProvider $this$resolveEndpoint_u24lambda_u245 = this;
            boolean bl = false;
            PartitionConfig partitionResult = PartitionsKt.partition(params.getRegion());
            if (partitionResult != null) {
                if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"local")) {
                    void $this$resolveEndpoint_u24lambda_u245_u24lambda_u241;
                    AttributesBuilder attributesBuilder;
                    if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                        throw new EndpointProviderException("Invalid Configuration: FIPS and local endpoint are not supported");
                    }
                    if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                        throw new EndpointProviderException("Invalid Configuration: Dualstack and local endpoint are not supported");
                    }
                    boolean $i$f$attributesOf = false;
                    boolean $i$f$mutableAttributesOf = false;
                    AttributesBuilder attributesBuilder3 = attributesBuilder = new AttributesBuilder();
                    ValuesMap valuesMap = null;
                    Url url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)"http://localhost:8000", null, (int)2, null);
                    boolean bl2 = false;
                    $this$resolveEndpoint_u24lambda_u245_u24lambda_u241.to(SigningContextKt.getSigningContextAttributeKey(), (Object)CollectionsKt.listOf((Object)SigV4AuthSchemeKt.sigV4$default((boolean)false, (String)"dynamodb", (String)"us-east-1", (Boolean)Boxing.boxBoolean((boolean)false), null, (int)17, null)));
                    Unit unit = Unit.INSTANCE;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Attributes attributes = (Attributes)attributesBuilder.getAttributes();
                    ValuesMap valuesMap3 = valuesMap;
                    Url url3 = url;
                    return new Endpoint(url3, valuesMap3, attributes, n, defaultConstructorMarker);
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)partitionResult.getSupportsFIPS(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)partitionResult.getSupportsDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                        if (params.getAccountIdEndpointMode() != null && Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"required")) {
                            throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
                        }
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://dynamodb-fips." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both");
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)partitionResult.getSupportsFIPS(), (Object)Boxing.boxBoolean((boolean)true))) {
                        if (Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws-us-gov")) {
                            if (params.getAccountIdEndpointMode() != null && Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"required")) {
                                throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
                            }
                            return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://dynamodb." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
                        }
                        if (params.getAccountIdEndpointMode() != null && Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"required")) {
                            throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
                        }
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://dynamodb-fips." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS is enabled but this partition does not support FIPS");
                }
                if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)partitionResult.getSupportsDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                        if (params.getAccountIdEndpointMode() != null && Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"required")) {
                            if (!Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                                throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and DualStack is enabled, but DualStack account endpoints are not supported");
                            }
                            throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
                        }
                        return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://dynamodb." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, (int)2, null), null, 2, null);
                    }
                    throw new EndpointProviderException("DualStack is enabled but this partition does not support DualStack");
                }
                DefaultDynamoDbEndpointProvider $this$resolveEndpoint_u24lambda_u245_u24lambda_u242 = $this$resolveEndpoint_u24lambda_u245;
                boolean bl3 = false;
                Arn parsedArn = aws.sdk.kotlin.runtime.endpoint.functions.FunctionsKt.parseArn((String)params.getResourceArn());
                if (parsedArn != null && params.getAccountIdEndpointMode() != null && !Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"disabled") && Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws") && !Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && !Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true)) && params.getResourceArn() != null && Intrinsics.areEqual((Object)parsedArn.getService(), (Object)"dynamodb") && FunctionsKt.isValidHostLabel((String)parsedArn.getRegion(), (boolean)false) && Intrinsics.areEqual((Object)parsedArn.getRegion(), (Object)String.valueOf(params.getRegion())) && FunctionsKt.isValidHostLabel((String)parsedArn.getAccountId(), (boolean)false)) {
                    return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://" + parsedArn.getAccountId() + ".ddb." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
                }
                DefaultDynamoDbEndpointProvider $this$resolveEndpoint_u24lambda_u245_u24lambda_u243 = $this$resolveEndpoint_u24lambda_u245;
                boolean bl4 = false;
                List<String> list = params.getResourceArnList();
                String firstArn = list != null ? (String)CollectionsKt.getOrNull(list, (int)0) : null;
                Arn parsedArn2 = aws.sdk.kotlin.runtime.endpoint.functions.FunctionsKt.parseArn((String)firstArn);
                if (firstArn != null && parsedArn2 != null && params.getAccountIdEndpointMode() != null && !Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"disabled") && Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws") && !Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && !Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true)) && params.getResourceArnList() != null && Intrinsics.areEqual((Object)parsedArn2.getService(), (Object)"dynamodb") && FunctionsKt.isValidHostLabel((String)parsedArn2.getRegion(), (boolean)false) && Intrinsics.areEqual((Object)parsedArn2.getRegion(), (Object)String.valueOf(params.getRegion())) && FunctionsKt.isValidHostLabel((String)parsedArn2.getAccountId(), (boolean)false)) {
                    return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://" + parsedArn2.getAccountId() + ".ddb." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
                }
                if (params.getAccountIdEndpointMode() != null && !Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"disabled") && Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws") && !Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && !Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true)) && params.getAccountId() != null) {
                    if (FunctionsKt.isValidHostLabel((String)params.getAccountId(), (boolean)false)) {
                        void $this$resolveEndpoint_u24lambda_u245_u24lambda_u244;
                        boolean $i$f$attributesOf = false;
                        boolean $i$f$mutableAttributesOf = false;
                        AttributesBuilder attributesBuilder = new AttributesBuilder();
                        firstArn = attributesBuilder;
                        ValuesMap valuesMap = null;
                        Url url = Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://" + params.getAccountId() + ".ddb." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null);
                        boolean bl5 = false;
                        $this$resolveEndpoint_u24lambda_u245_u24lambda_u244.to(BusinessMetricsUtilsKt.getAccountIdBasedEndpointAccountId(), (Object)params.getAccountId());
                        Unit unit = Unit.INSTANCE;
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 2;
                        Attributes attributes = (Attributes)attributesBuilder.getAttributes();
                        ValuesMap valuesMap4 = valuesMap;
                        Url url4 = url;
                        return new Endpoint(url4, valuesMap4, attributes, n, defaultConstructorMarker);
                    }
                    throw new EndpointProviderException("Credentials-sourced account ID parameter is invalid");
                }
                if (params.getAccountIdEndpointMode() != null && Intrinsics.areEqual((Object)params.getAccountIdEndpointMode(), (Object)"required")) {
                    if (!Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                        if (!Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                            if (Intrinsics.areEqual((Object)partitionResult.getName(), (Object)"aws")) {
                                throw new EndpointProviderException("AccountIdEndpointMode is required but no AccountID was provided or able to be loaded");
                            }
                            throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition");
                        }
                        throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and DualStack is enabled, but DualStack account endpoints are not supported");
                    }
                    throw new EndpointProviderException("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
                }
                return new Endpoint(Url.Companion.parse$default((Url.Companion)Url.Companion, (String)("https://dynamodb." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, (int)2, null), null, 2, null);
            }
        }
        throw new EndpointProviderException("Invalid Configuration: Missing Region");
    }
}

