/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials.profile;

import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.auth.credentials.profile.LeafProvider;
import aws.sdk.kotlin.runtime.auth.credentials.profile.NextProfile;
import aws.sdk.kotlin.runtime.auth.credentials.profile.ProfileChainKt;
import aws.sdk.kotlin.runtime.auth.credentials.profile.RoleArn;
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig;
import aws.sdk.kotlin.runtime.config.profile.ConfigSection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain;", "", "leaf", "Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;", "roles", "", "Laws/sdk/kotlin/runtime/auth/credentials/profile/RoleArn;", "<init>", "(Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;Ljava/util/List;)V", "getLeaf", "()Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;", "getRoles", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "aws-config"})
public final class ProfileChain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LeafProvider leaf;
    @NotNull
    private final List<RoleArn> roles;

    public ProfileChain(@NotNull LeafProvider leaf, @NotNull List<RoleArn> roles) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        this.leaf = leaf;
        this.roles = roles;
    }

    @NotNull
    public final LeafProvider getLeaf() {
        return this.leaf;
    }

    @NotNull
    public final List<RoleArn> getRoles() {
        return this.roles;
    }

    @NotNull
    public final LeafProvider component1() {
        return this.leaf;
    }

    @NotNull
    public final List<RoleArn> component2() {
        return this.roles;
    }

    @NotNull
    public final ProfileChain copy(@NotNull LeafProvider leaf, @NotNull List<RoleArn> roles) {
        Intrinsics.checkNotNullParameter((Object)leaf, (String)"leaf");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        return new ProfileChain(leaf, roles);
    }

    public static /* synthetic */ ProfileChain copy$default(ProfileChain profileChain, LeafProvider leafProvider, List list, int n, Object object) {
        if ((n & 1) != 0) {
            leafProvider = profileChain.leaf;
        }
        if ((n & 2) != 0) {
            list = profileChain.roles;
        }
        return profileChain.copy(leafProvider, list);
    }

    @NotNull
    public String toString() {
        return "ProfileChain(leaf=" + this.leaf + ", roles=" + this.roles + ')';
    }

    public int hashCode() {
        int result = this.leaf.hashCode();
        result = result * 31 + ((Object)this.roles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileChain)) {
            return false;
        }
        ProfileChain profileChain = (ProfileChain)other;
        if (!Intrinsics.areEqual((Object)this.leaf, (Object)profileChain.leaf)) {
            return false;
        }
        return Intrinsics.areEqual(this.roles, profileChain.roles);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain$Companion;", "", "<init>", "()V", "resolve", "Laws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain;", "config", "Laws/sdk/kotlin/runtime/config/profile/AwsSharedConfig;", "resolve$aws_config", "aws-config"})
    @SourceDebugExtension(value={"SMAP\nProfileChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain$Companion\n+ 2 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChainKt\n*L\n1#1,354:1\n98#2:355\n*S KotlinDebug\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChain$Companion\n*L\n53#1:355\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProfileChain resolve$aws_config(@NotNull AwsSharedConfig config) {
            LeafProvider leaf;
            List chain2;
            block6: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                Set visited = new LinkedHashSet();
                chain2 = new ArrayList();
                String sourceProfileName = null;
                sourceProfileName = config.getActiveProfile().getName();
                leaf = null;
                while (true) {
                    ConfigSection profile2;
                    void $this$getOrThrow$iv;
                    Map<String, ConfigSection> map = config.getProfiles();
                    String name$iv = sourceProfileName;
                    boolean $i$f$getOrThrow = false;
                    if ((ConfigSection)$this$getOrThrow$iv.get(name$iv) == null) {
                        boolean bl = false;
                        DefaultConstructorMarker defaultConstructorMarker = null;
                        int n = 2;
                        Throwable throwable = null;
                        String string = visited.isEmpty() ? "could not find source profile " + sourceProfileName : "could not find source profile " + sourceProfileName + " referenced from " + (String)CollectionsKt.last((Iterable)visited);
                        throw new ProviderConfigurationException(string, throwable, n, defaultConstructorMarker);
                    }
                    if (!visited.add(sourceProfileName)) {
                        throw new ProviderConfigurationException("profile formed an infinite loop: " + CollectionsKt.joinToString$default((Iterable)visited, (CharSequence)" -> ", null, null, (int)0, null, null, (int)62, null) + " -> " + sourceProfileName, null, 2, null);
                    }
                    leaf = ProfileChainKt.access$staticCredsOrNull(profile2);
                    if (leaf != null) break block6;
                    RoleArn roleArn = ProfileChainKt.access$roleArnOrNull(profile2);
                    if (roleArn == null) {
                        leaf = ProfileChainKt.access$leafProvider(profile2, config);
                        break block6;
                    }
                    chain2.add(roleArn);
                    NextProfile nextProfile = ProfileChainKt.access$chainProvider(profile2);
                    if (nextProfile instanceof NextProfile.SelfReference) {
                        leaf = ProfileChainKt.access$leafProvider(profile2, config);
                        break block6;
                    }
                    if (!(nextProfile instanceof NextProfile.Named)) break;
                    sourceProfileName = ((NextProfile.Named)nextProfile).getName();
                }
                throw new NoWhenBranchMatchedException();
            }
            CollectionsKt.reverse((List)chain2);
            LeafProvider leafProvider = leaf;
            if (leafProvider == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            return new ProfileChain(leafProvider, chain2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

