/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

public abstract class FuzzyBoolean {
    public static final FuzzyBoolean YES = new YesFuzzyBoolean();
    public static final FuzzyBoolean NO = new NoFuzzyBoolean();
    public static final FuzzyBoolean MAYBE = new MaybeFuzzyBoolean();
    public static final FuzzyBoolean NEVER = new NeverFuzzyBoolean();

    public abstract boolean alwaysTrue();

    public abstract boolean alwaysFalse();

    public abstract boolean maybeTrue();

    public abstract boolean maybeFalse();

    public abstract FuzzyBoolean and(FuzzyBoolean var1);

    public abstract FuzzyBoolean or(FuzzyBoolean var1);

    public abstract FuzzyBoolean not();

    private static class MaybeFuzzyBoolean
    extends FuzzyBoolean {
        private MaybeFuzzyBoolean() {
        }

        public boolean alwaysFalse() {
            return false;
        }

        public boolean alwaysTrue() {
            return false;
        }

        public boolean maybeFalse() {
            return true;
        }

        public boolean maybeTrue() {
            return true;
        }

        public FuzzyBoolean and(FuzzyBoolean other) {
            return other.alwaysFalse() ? other : this;
        }

        public FuzzyBoolean not() {
            return this;
        }

        public FuzzyBoolean or(FuzzyBoolean other) {
            return other.alwaysTrue() ? other : this;
        }

        public String toString() {
            return "MAYBE";
        }
    }

    private static class NeverFuzzyBoolean
    extends FuzzyBoolean {
        private NeverFuzzyBoolean() {
        }

        public boolean alwaysFalse() {
            return true;
        }

        public boolean alwaysTrue() {
            return false;
        }

        public boolean maybeFalse() {
            return true;
        }

        public boolean maybeTrue() {
            return false;
        }

        public FuzzyBoolean and(FuzzyBoolean other) {
            return this;
        }

        public FuzzyBoolean not() {
            return this;
        }

        public FuzzyBoolean or(FuzzyBoolean other) {
            return this;
        }

        public String toString() {
            return "NEVER";
        }
    }

    private static class NoFuzzyBoolean
    extends FuzzyBoolean {
        private NoFuzzyBoolean() {
        }

        public boolean alwaysFalse() {
            return true;
        }

        public boolean alwaysTrue() {
            return false;
        }

        public boolean maybeFalse() {
            return true;
        }

        public boolean maybeTrue() {
            return false;
        }

        public FuzzyBoolean and(FuzzyBoolean other) {
            return this;
        }

        public FuzzyBoolean not() {
            return YES;
        }

        public FuzzyBoolean or(FuzzyBoolean other) {
            return other;
        }

        public String toString() {
            return "NO";
        }
    }

    private static class YesFuzzyBoolean
    extends FuzzyBoolean {
        private YesFuzzyBoolean() {
        }

        public boolean alwaysFalse() {
            return false;
        }

        public boolean alwaysTrue() {
            return true;
        }

        public boolean maybeFalse() {
            return false;
        }

        public boolean maybeTrue() {
            return true;
        }

        public FuzzyBoolean and(FuzzyBoolean other) {
            return other;
        }

        public FuzzyBoolean not() {
            return NO;
        }

        public FuzzyBoolean or(FuzzyBoolean other) {
            return this;
        }

        public String toString() {
            return "YES";
        }
    }
}

