/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.tools.ide.SourceLine;
import org.aspectj.tools.ide.SymbolManager;

public class ExceptionMapper {
    private SymbolManager sm;
    private File sourcepath;
    private File workingdir;
    private static final String newline = System.getProperty("line.separator");
    private Map classToFile = new HashMap();

    private ExceptionMapper(File sourcepath) {
        this.sourcepath = sourcepath;
        this.workingdir = new File(sourcepath, "ajworkingdir");
        this.sm = SymbolManager.getSymbolManager();
    }

    public ExceptionMapper(String sourcepath) {
        this(ExceptionMapper.validate(sourcepath));
    }

    public ExceptionMapper() {
        this(".");
    }

    public void printStackTrace(Throwable t) {
        System.err.println(this.map(t));
    }

    public void printStackTrace(Throwable t, PrintStream out) {
        out.println(this.map(t));
    }

    public void printStackTrace(Throwable t, PrintWriter out) {
        out.println(this.map(t));
    }

    private static File validate(String fileName) {
        String path;
        try {
            path = new File(fileName).getCanonicalPath();
        }
        catch (IOException ioe) {
            path = new File(fileName).getAbsolutePath();
        }
        while (!Character.isLetterOrDigit(path.charAt(path.length() - 1))) {
            path = path.substring(0, path.length() - 1);
        }
        return new File(path);
    }

    private String map(Throwable t) {
        return this.map(this.collect(t));
    }

    private String collect(Throwable t) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        t.printStackTrace(out);
        return sout + "";
    }

    private String map(String backtrace) {
        String result = "";
        StringTokenizer tok = new StringTokenizer(backtrace, newline, false);
        result = result + tok.nextToken() + newline;
        while (tok.hasMoreTokens()) {
            result = result + this.frame(tok.nextToken()) + newline;
        }
        return result;
    }

    private String frame(String frame) {
        char[] chars = frame.toCharArray();
        int i = 0;
        while (chars[i] != 'a') {
            ++i;
        }
        int iclass = i;
        while (chars[iclass++] != ' ') {
        }
        int ilparen = iclass;
        while (chars[ilparen] != '(') {
            ++ilparen;
        }
        int ilastdot = ilparen;
        while (chars[ilastdot] != '.') {
            --ilastdot;
        }
        int icolon = ilparen;
        while (chars[icolon] != ':') {
            ++icolon;
        }
        int irparen = icolon;
        while (chars[irparen] != ')') {
            ++irparen;
        }
        return this.map(new String(chars, iclass, ilastdot - iclass), new String(chars, ilastdot + 1, ilparen - ilastdot - 1), new String(chars, ilparen + 1, icolon - ilparen - 1), new String(chars, icolon + 1, irparen - icolon - 1));
    }

    private String map(String s0, String s1, String s2, String num) {
        return this.map(s0, s1, s2, Integer.parseInt(num));
    }

    private String map(String className, String method, String source, int line) {
        SourceLine sl = this.mapToSourceLine(className, line);
        return sl != null ? this.frame(className, method, this.strip(sl.filename), sl.line) : this.frame(className, method, source, line);
    }

    private String strip(String filename) {
        int isep = filename.lastIndexOf(File.separator);
        return isep != -1 ? filename.substring(isep + 1) : filename;
    }

    private String frame(String className, String method, String source, int line) {
        return "\tat " + className + "." + method + "(" + source + ":" + line + ")";
    }

    private File fileForClass(String className) {
        return (File)this.classToFile.get(className);
    }

    private File resolve(String className) {
        File result = this.fileForClass(className);
        if (result != null) {
            return result;
        }
        String resolvedName = className.replace('.', '/');
        int idollar = resolvedName.indexOf(36);
        if (idollar != -1) {
            resolvedName = resolvedName.substring(0, idollar);
        }
        result = new File(this.workingdir + File.separator + resolvedName + ".java");
        this.classToFile.put(className, result);
        return result;
    }

    private SourceLine mapToSourceLine(String className, int line) {
        return this.sm.mapToSourceLine(this.resolve(className).getAbsolutePath(), line - 1);
    }
}

