/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ide;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.aspectj.tools.ide.Declaration;
import org.aspectj.tools.ide.SourceLine;

public class SymbolManager {
    private static final String SYMBOL_FILE_EXTENSION = ".ajsym";
    private static final String SOURCE_LINES_FILE_EXTENSION = ".ajsline";
    private static SymbolManager symbolManagerInstance = new SymbolManager();
    private Hashtable symbolFileEntryCache = new Hashtable();
    private Hashtable sourceToOutputCache = new Hashtable();
    private Hashtable outputToSourceCache = new Hashtable();
    private static final int INDENT = 2;

    public static File mapFilenameToSymbolFile(String filename) {
        return SymbolManager.mapFilenameToNewExtensionFile(filename, SYMBOL_FILE_EXTENSION);
    }

    public static File mapFilenameToSourceLinesFile(String filename) {
        return SymbolManager.mapFilenameToNewExtensionFile(filename, SOURCE_LINES_FILE_EXTENSION);
    }

    public static File getSourceToOutputFile(String dirname) {
        return new File(dirname, SOURCE_LINES_FILE_EXTENSION);
    }

    public static File getOutputToSourceFile(String dirname) {
        return new File(dirname, ".ajoline");
    }

    private static File mapFilenameToNewExtensionFile(String filename, String ext) {
        int lastDot = filename.lastIndexOf(46);
        String basename = filename;
        if (lastDot != -1) {
            basename = basename.substring(0, lastDot);
        }
        return new File(basename + ext);
    }

    public static SymbolManager getSymbolManager() {
        return symbolManagerInstance;
    }

    public SourceLine mapToSourceLine(String filePath, int lineNumber) {
        Map map = this.lookupOutputToSource(filePath);
        if (map == null) {
            return null;
        }
        return (SourceLine)map.get(new SourceLine(filePath, lineNumber));
    }

    public SourceLine mapToOutputLine(String filePath, int lineNumber) {
        Map map = this.lookupSourceToOutput(filePath);
        if (map == null) {
            return null;
        }
        return (SourceLine)map.get(new SourceLine(filePath, lineNumber));
    }

    public Declaration[] getDeclarations(String filename) {
        return this.lookupDeclarations(filename);
    }

    public Declaration getDeclarationAtLine(String filename, int line) {
        return this.getDeclarationAtPoint(filename, line, -1);
    }

    public Declaration getDeclarationAtPoint(String filename, int line, int column) {
        Declaration[] declarations = this.lookupDeclarations(filename);
        return this.getDeclarationAtPoint(declarations, line, column);
    }

    public Declaration getDeclarationAtPoint(Declaration[] declarations, int line, int column) {
        if (declarations == null) {
            return null;
        }
        int i = 0;
        while (i < declarations.length) {
            Declaration dec1;
            Declaration[] enclosedDecs;
            Declaration dec = declarations[i];
            if (dec.getBeginLine() == line) {
                if (column == -1) {
                    return dec;
                }
                if (dec.getBeginColumn() == column) {
                    return dec;
                }
            }
            if ((enclosedDecs = dec.getDeclarations()).length != 0 && (dec1 = this.getDeclarationAtPoint(enclosedDecs, line, column)) != null) {
                return dec1;
            }
            ++i;
        }
        return null;
    }

    private Declaration[] lookupDeclarations(String filename) {
        CorrFileEntry entry = this.lookup(filename, SymbolManager.mapFilenameToSymbolFile(filename), this.symbolFileEntryCache);
        return (Declaration[])entry.data;
    }

    private Map lookupSourceToOutput(String filename) {
        CorrFileEntry entry = this.lookup(filename, SymbolManager.getSourceToOutputFile(new File(filename).getParent()), this.sourceToOutputCache);
        return (Map)entry.data;
    }

    private Map lookupOutputToSource(String filename) {
        CorrFileEntry entry = this.lookup(filename, SymbolManager.getOutputToSourceFile(new File(filename).getParent()), this.outputToSourceCache);
        return (Map)entry.data;
    }

    private CorrFileEntry lookup(String filename, File file, Hashtable cache) {
        CorrFileEntry entry = (CorrFileEntry)cache.get(filename);
        if (entry != null && entry.lastModified == file.lastModified()) {
            return entry;
        }
        entry = this.createCorrFileEntry(file);
        cache.put(filename, entry);
        return entry;
    }

    private CorrFileEntry createCorrFileEntry(File file) {
        if (!file.exists()) {
            return new CorrFileEntry(0L, null);
        }
        try {
            long lastModified = file.lastModified();
            ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object data = stream.readObject();
            stream.close();
            return new CorrFileEntry(lastModified, data);
        }
        catch (IOException ioe) {
            return new CorrFileEntry(0L, null);
        }
        catch (ClassNotFoundException cce) {
            return new CorrFileEntry(0L, null);
        }
    }

    public static String translateMethodName(String methodName) {
        int firstDollar = methodName.indexOf(36);
        if (firstDollar == -1) {
            return methodName;
        }
        String baseName = methodName.substring(firstDollar);
        if (methodName.indexOf("ajc") != -1) {
            return "<" + baseName + " advice>";
        }
        return baseName;
    }

    private static final void printIndentation(int indent, String prefix) {
        int i = 0;
        while (i < indent) {
            System.out.print(" ");
            ++i;
        }
        System.out.print(prefix);
    }

    private static final void printDeclaration(Declaration dec, int indent, String prefix) {
        SymbolManager.printIndentation(indent, prefix);
        if (dec == null) {
            System.out.println("null");
            return;
        }
        System.out.println(dec.getKind() + ": " + dec.getDeclaringType() + ": " + dec.getModifiers() + ": " + dec.getSignature() + ": " + dec.getCrosscutDesignator() + ": " + dec.isIntroduced() + ": " + dec.getPackageName() + ": " + dec.getBeginLine() + ":" + dec.getBeginColumn());
        if (prefix.equals("")) {
            SymbolManager.printDeclarations(dec.getTargets(), indent + 2, "T> ");
            SymbolManager.printDeclarations(dec.getPointsTo(), indent + 2, ">> ");
            SymbolManager.printDeclarations(dec.getPointedToBy(), indent + 2, "<< ");
            SymbolManager.printDeclarations(dec.getDeclarations(), indent + 2, "");
        }
    }

    private static final void printDeclarations(Declaration[] decs, int indent, String prefix) {
        int i = 0;
        while (i < decs.length) {
            SymbolManager.printDeclaration(decs[i], indent, prefix);
            ++i;
        }
    }

    static void printLines(String filename, Map baseMap) throws IOException {
        if (baseMap == null) {
            return;
        }
        String fullName = new File(filename).getCanonicalPath();
        TreeMap map = new TreeMap();
        Iterator i = baseMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            SourceLine keyLine = (SourceLine)entry.getKey();
            if (!keyLine.filename.equals(fullName)) continue;
            map.put(new Integer(keyLine.line), entry.getValue());
        }
        Iterator j = map.entrySet().iterator();
        while (j.hasNext()) {
            Map.Entry entry = j.next();
            System.out.println(entry.getKey() + ":\t" + entry.getValue());
        }
    }

    public static void main(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            String filename = args[i];
            System.out.println(filename);
            System.out.println("declaration mappings");
            System.out.println("kind: declaringType: modifiers: signature: fullSignature: crosscutDesignator: isIntroduced: packageName: parentDeclaration");
            Declaration[] declarations = SymbolManager.getSymbolManager().getDeclarations(filename);
            if (declarations != null) {
                SymbolManager.printDeclarations(declarations, 2, "");
            }
            System.out.println("source to output");
            SymbolManager.printLines(filename, SymbolManager.getSymbolManager().lookupSourceToOutput(filename));
            System.out.println("output to source");
            SymbolManager.printLines(filename, SymbolManager.getSymbolManager().lookupOutputToSource(filename));
            ++i;
        }
    }

    private static class CorrFileEntry {
        public long lastModified;
        public Object data;

        public CorrFileEntry(long lastModified, Object data) {
            this.lastModified = lastModified;
            this.data = data;
        }
    }
}

