/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.doclets.standard;

import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.Configuration;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.standard.AllClassesFrameWriter;
import com.sun.tools.doclets.standard.FrameOutputWriter;
import com.sun.tools.doclets.standard.HelpWriter;
import com.sun.tools.doclets.standard.PackageIndexFrameWriter;
import com.sun.tools.doclets.standard.PackageIndexWriter;
import com.sun.tools.doclets.standard.PackageListWriter;
import com.sun.tools.doclets.standard.PackagesFileWriter;
import com.sun.tools.doclets.standard.SerializedFormWriter;
import com.sun.tools.doclets.standard.StylesheetWriter;
import java.io.IOException;
import org.aspectj.tools.ajdoc.Quietable;
import org.aspectj.tools.doclets.standard.AbstractStandard;
import org.aspectj.tools.doclets.standard.ClassUseMapper;
import org.aspectj.tools.doclets.standard.ConfigurationStandard;
import org.aspectj.tools.doclets.standard.DeprecatedListWriter;
import org.aspectj.tools.doclets.standard.SingleIndexWriter;
import org.aspectj.tools.doclets.standard.SplitIndexWriter;
import org.aspectj.tools.doclets.standard.TreeWriter;

public class Standard
extends AbstractStandard {
    private static Standard SINGLETON;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$ClassUseMapperPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$TreeWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$SplitIndexWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$SingleIndexWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$DeprecatedListWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$AllClassesFrameWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$FrameOutputWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$PackagesFileWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$PackageIndexWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$PackageIndexFrameWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$SerializedFormWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$PackageListWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$HelpWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$StylesheetWriterPass;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$NoPublicClassesToDocumentCheck;
    static /* synthetic */ Class class$org$aspectj$tools$doclets$standard$Standard$NoNonDeprecatedClassToDocumentCheck;

    public static final Standard getSingleton() {
        if (null == SINGLETON) {
            SINGLETON = new Standard();
        }
        return SINGLETON;
    }

    private Standard() {
    }

    public static boolean start(RootDoc root) throws IOException {
        return AbstractStandard.start(Standard.getSingleton(), root);
    }

    public ConfigurationStandard getConfiguration() {
        return (ConfigurationStandard)AbstractStandard.configuration();
    }

    public static void quiet() {
        AbstractStandard.configuration();
        if (Configuration.root instanceof Quietable) {
            AbstractStandard.configuration();
            ((Quietable)Configuration.root).quiet();
        }
    }

    public static void speak() {
        AbstractStandard.configuration();
        if (Configuration.root instanceof Quietable) {
            AbstractStandard.configuration();
            ((Quietable)Configuration.root).speak();
        }
    }

    protected Class[] preGenerationClasses() {
        return new Class[]{class$org$aspectj$tools$doclets$standard$Standard$ClassUseMapperPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$ClassUseMapperPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$ClassUseMapperPass")) : class$org$aspectj$tools$doclets$standard$Standard$ClassUseMapperPass, class$org$aspectj$tools$doclets$standard$Standard$TreeWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$TreeWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$TreeWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$TreeWriterPass, class$org$aspectj$tools$doclets$standard$Standard$SplitIndexWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$SplitIndexWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$SplitIndexWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$SplitIndexWriterPass, class$org$aspectj$tools$doclets$standard$Standard$SingleIndexWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$SingleIndexWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$SingleIndexWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$SingleIndexWriterPass, class$org$aspectj$tools$doclets$standard$Standard$DeprecatedListWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$DeprecatedListWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$DeprecatedListWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$DeprecatedListWriterPass, class$org$aspectj$tools$doclets$standard$Standard$AllClassesFrameWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$AllClassesFrameWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$AllClassesFrameWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$AllClassesFrameWriterPass, class$org$aspectj$tools$doclets$standard$Standard$FrameOutputWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$FrameOutputWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$FrameOutputWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$FrameOutputWriterPass, class$org$aspectj$tools$doclets$standard$Standard$PackagesFileWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$PackagesFileWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$PackagesFileWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$PackagesFileWriterPass, class$org$aspectj$tools$doclets$standard$Standard$PackageIndexWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$PackageIndexWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$PackageIndexWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$PackageIndexWriterPass, class$org$aspectj$tools$doclets$standard$Standard$PackageIndexFrameWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$PackageIndexFrameWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$PackageIndexFrameWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$PackageIndexFrameWriterPass};
    }

    protected Class[] postGenerationClasses() {
        return new Class[]{class$org$aspectj$tools$doclets$standard$Standard$SerializedFormWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$SerializedFormWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$SerializedFormWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$SerializedFormWriterPass, class$org$aspectj$tools$doclets$standard$Standard$PackageListWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$PackageListWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$PackageListWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$PackageListWriterPass, class$org$aspectj$tools$doclets$standard$Standard$HelpWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$HelpWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$HelpWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$HelpWriterPass, class$org$aspectj$tools$doclets$standard$Standard$StylesheetWriterPass == null ? (class$org$aspectj$tools$doclets$standard$Standard$StylesheetWriterPass = Standard.class$("org.aspectj.tools.doclets.standard.Standard$StylesheetWriterPass")) : class$org$aspectj$tools$doclets$standard$Standard$StylesheetWriterPass};
    }

    protected Class[] checkClasses() {
        return new Class[]{class$org$aspectj$tools$doclets$standard$Standard$NoPublicClassesToDocumentCheck == null ? (class$org$aspectj$tools$doclets$standard$Standard$NoPublicClassesToDocumentCheck = Standard.class$("org.aspectj.tools.doclets.standard.Standard$NoPublicClassesToDocumentCheck")) : class$org$aspectj$tools$doclets$standard$Standard$NoPublicClassesToDocumentCheck, class$org$aspectj$tools$doclets$standard$Standard$NoNonDeprecatedClassToDocumentCheck == null ? (class$org$aspectj$tools$doclets$standard$Standard$NoNonDeprecatedClassToDocumentCheck = Standard.class$("org.aspectj.tools.doclets.standard.Standard$NoNonDeprecatedClassToDocumentCheck")) : class$org$aspectj$tools$doclets$standard$Standard$NoNonDeprecatedClassToDocumentCheck};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NoNonDeprecatedClassToDocumentCheck
    extends AbstractStandard.Check {
        protected boolean cond() {
            return this.cs.topFile.length() == 0;
        }

        protected String message() {
            return "doclet.No_Non_Deprecated_Classes_To_Document";
        }
    }

    public static class NoPublicClassesToDocumentCheck
    extends AbstractStandard.Check {
        protected boolean cond() {
            return this.root.classes().length == 0;
        }

        protected String message() {
            return "doclet.No_Public_Classes_To_Document";
        }
    }

    public static class StylesheetWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return this.cs.stylesheetfile.length() == 0;
        }

        protected void gen() throws DocletAbortException {
            StylesheetWriter.generate();
        }

        public String title() {
            return "style sheet";
        }
    }

    public static class HelpWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return this.cs.helpfile.length() == 0 && !this.cs.nohelp;
        }

        protected void gen() throws DocletAbortException {
            HelpWriter.generate();
        }

        public String title() {
            return "help";
        }
    }

    public static class PackageListWriterPass
    extends AbstractStandard.Pass {
        protected void gen() throws DocletAbortException {
            PackageListWriter.generate((RootDoc)this.root);
        }

        public String title() {
            return "package list";
        }
    }

    public static class SerializedFormWriterPass
    extends AbstractStandard.Pass {
        protected void gen() throws DocletAbortException {
            SerializedFormWriter.generate((RootDoc)this.root);
        }

        public String title() {
            return "serialized form";
        }
    }

    public static class PackageIndexFrameWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return ((Configuration)this.cs).packages.length > 1;
        }

        protected void gen() throws DocletAbortException {
            PackageIndexFrameWriter.generate();
        }

        public String title() {
            return "package index frame";
        }
    }

    public static class PackageIndexWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond(ConfigurationStandard cs) {
            return cs.createoverview;
        }

        protected void gen() throws DocletAbortException {
            PackageIndexWriter.generate((RootDoc)this.root);
        }

        public String title() {
            return "package index";
        }
    }

    public static class PackagesFileWriterPass
    extends AbstractStandard.Pass {
        protected void gen() throws DocletAbortException {
            PackagesFileWriter.generate();
        }

        public String title() {
            return "packages files";
        }
    }

    public static class FrameOutputWriterPass
    extends AbstractStandard.Pass {
        protected void gen() throws DocletAbortException {
            FrameOutputWriter.generate();
        }

        public String title() {
            return "output frame";
        }
    }

    public static class AllClassesFrameWriterPass
    extends AbstractStandard.Pass {
        protected void gen() throws DocletAbortException {
            AllClassesFrameWriter.generate((IndexBuilder)this.std.indexBuilder(this.root, true));
        }

        public String title() {
            return "all classes frame";
        }
    }

    public static class DeprecatedListWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return !this.cs.nodeprecatedlist && !((Configuration)this.cs).nodeprecated;
        }

        protected void gen() throws DocletAbortException {
            DeprecatedListWriter.generate(this.root);
        }

        public String title() {
            return "deprecated list";
        }
    }

    public static class SingleIndexWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return this.cs.createindex && !this.cs.splitindex;
        }

        protected void gen() throws DocletAbortException {
            SingleIndexWriter.generate(this.std.indexBuilder(this.root, false));
        }

        public String title() {
            return "single index";
        }
    }

    public static class SplitIndexWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return this.cs.createindex && this.cs.splitindex;
        }

        protected void gen() throws DocletAbortException {
            SplitIndexWriter.generate(this.std.indexBuilder(this.root, false));
        }

        public String title() {
            return "split index";
        }
    }

    public static class TreeWriterPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return this.cs.createtree;
        }

        protected void gen() throws DocletAbortException {
            TreeWriter.generate(this.std.classtree);
        }

        public String title() {
            return "tree writer";
        }
    }

    public static class ClassUseMapperPass
    extends AbstractStandard.Pass {
        protected boolean cond() {
            return this.cs.classuse;
        }

        protected void gen() throws DocletAbortException {
            ClassUseMapper.generate(this.root, this.std.classtree);
        }

        public String title() {
            return "class use mapper";
        }
    }
}

