/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.doclets.standard;

import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.Configuration;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.HtmlDocWriter;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.standard.Standard;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.aspectj.ajdoc.AspectDoc;
import org.aspectj.ajdoc.ClassDoc;
import org.aspectj.tools.doclets.standard.AbstractStandard;
import org.aspectj.tools.doclets.standard.ClassWriter;
import org.aspectj.tools.doclets.standard.ConfigurationStandard;
import org.aspectj.tools.doclets.standard.PackageFrameWriter;
import org.aspectj.tools.doclets.standard.PackageTreeWriter;
import org.aspectj.tools.doclets.standard.PackageWriter;

public abstract class AbstractStandard
extends Standard {
    private static int refCount = 0;
    protected ClassTree classtree;

    public AbstractStandard() {
        if (refCount > 0) {
            System.err.println("Warning: " + refCount + " AbstractStandard already ");
        }
        ++refCount;
    }

    protected static boolean start(AbstractStandard as, RootDoc root) throws IOException {
        try {
            as.getConfiguration().setOptions(root);
            as.startGeneration(root);
        }
        catch (DocletAbortException exc) {
            return false;
        }
        return true;
    }

    protected abstract Class[] preGenerationClasses();

    protected abstract Class[] postGenerationClasses();

    protected abstract Class[] checkClasses();

    public abstract ConfigurationStandard getConfiguration();

    protected ConfigurationStandard makeConfiguration() {
        return new ConfigurationStandard();
    }

    public static com.sun.tools.doclets.standard.ConfigurationStandard configuration() {
        if (HtmlDocWriter.configuration == null || !(HtmlDocWriter.configuration instanceof ConfigurationStandard)) {
            HtmlDocWriter.configuration = new ConfigurationStandard();
        }
        return (ConfigurationStandard)HtmlDocWriter.configuration;
    }

    protected IndexBuilder indexBuilder(RootDoc root, boolean classesOnly) {
        class MyIndexBuilder
        extends IndexBuilder {
            private final /* synthetic */ AbstractStandard this$0;

            public MyIndexBuilder(AbstractStandard this$0, RootDoc r, boolean n) {
                super(r, n);
                this.this$0 = this$0;
            }

            public MyIndexBuilder(AbstractStandard this$0, RootDoc r, boolean n, boolean b) {
                super(r, n, b);
                this.this$0 = this$0;
            }

            protected void putMembersInIndexMap(com.sun.javadoc.ClassDoc classdoc) {
                super.putMembersInIndexMap(classdoc);
                if (classdoc instanceof ClassDoc) {
                    ClassDoc cd = (ClassDoc)classdoc;
                    this.adjustIndexMap(cd.pointcuts());
                    if (cd instanceof AspectDoc) {
                        this.adjustIndexMap(((AspectDoc)cd).advice());
                    }
                }
            }
        }
        return new MyIndexBuilder(this, root, AbstractStandard.configuration().nodeprecated, classesOnly);
    }

    protected void startGeneration(RootDoc root) throws DocletAbortException {
        if (!this.generateCheckPasses(this.getConfiguration(), root)) {
            return;
        }
        this.performCopy(((Configuration)this.getConfiguration()).destdirname, this.getConfiguration().helpfile);
        this.performCopy(((Configuration)this.getConfiguration()).destdirname, this.getConfiguration().stylesheetfile);
        this.classtree = new ClassTree(root, ((Configuration)this.getConfiguration()).nodeprecated);
        this.generatePrePasses(this.getConfiguration(), root);
        this.generatePackageCycle(((Configuration)this.getConfiguration()).packages, this.getConfiguration().createtree, ((Configuration)this.getConfiguration()).nodeprecated);
        this.generateClassFiles(root, this.classtree);
        this.generatePostPasses(this.getConfiguration(), root);
    }

    private final void generatePrePasses(ConfigurationStandard cs, RootDoc root) throws DocletAbortException {
        this.generatePasses(cs, root, this.preGenerationClasses());
    }

    private final void generatePostPasses(ConfigurationStandard cs, RootDoc root) throws DocletAbortException {
        this.generatePasses(cs, root, this.postGenerationClasses());
    }

    private final boolean generateCheckPasses(ConfigurationStandard cs, RootDoc root) throws DocletAbortException {
        try {
            this.generatePasses(cs, root, this.checkClasses());
        }
        catch (DocletAbortException e) {
            return false;
        }
        return true;
    }

    private final void generatePasses(ConfigurationStandard cs, RootDoc root, Class[] classes) throws DocletAbortException {
        if (classes == null) {
            return;
        }
        int i = 0;
        while (i < classes.length) {
            block9: {
                try {
                    Constructor<?>[] ctrs = classes[i].getConstructors();
                    int j = 0;
                    while (j < ctrs.length) {
                        Pass pass = null;
                        if (ctrs[j].getParameterTypes().length == 0) {
                            pass = (Pass)ctrs[j].newInstance(new Object[0]);
                        } else if (ctrs[j].getParameterTypes().length == 1) {
                            pass = (Pass)ctrs[j].newInstance(new Object[]{this});
                        }
                        if (pass != null) {
                            pass.generate(this, cs, root);
                            break block9;
                        }
                        ++j;
                    }
                    throw new Exception("Can't create pass for class " + classes[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AbstractStandard.configuration();
                    com.sun.tools.doclets.standard.ConfigurationStandard.standardmessage.error("doclet.exception", e + "");
                    throw new DocletAbortException();
                }
            }
            ++i;
        }
    }

    protected void generatePackageCycle(PackageDoc[] pkgs, boolean createtree, boolean nodeprecated) throws DocletAbortException {
        Arrays.sort(pkgs);
        int i = 0;
        while (i < pkgs.length) {
            PackageDoc prev = i == 0 ? null : pkgs[i - 1];
            PackageDoc curr = pkgs[i];
            PackageDoc next = i == pkgs.length - 1 ? null : pkgs[i + 1];
            this.generatePackages(prev, curr, next, createtree, nodeprecated);
            ++i;
        }
    }

    protected void generatePackages(PackageDoc prev, PackageDoc curr, PackageDoc next, boolean createtree, boolean nodeprecated) throws DocletAbortException {
        PackageWriter.generate(curr, prev, next);
        if (createtree) {
            PackageTreeWriter.generate(curr, prev, next, nodeprecated);
        }
        PackageFrameWriter.generate(curr);
    }

    protected void generateClassCycle(com.sun.javadoc.ClassDoc[] cs, ClassTree classtree, boolean nopackage) throws DocletAbortException {
        Arrays.sort(cs);
        int i = 0;
        while (i < cs.length) {
            if (!AbstractStandard.configuration().nodeprecated || cs[i].tags("deprecated").length <= 0) {
                com.sun.javadoc.ClassDoc prev = i == 0 ? null : cs[i - 1];
                com.sun.javadoc.ClassDoc curr = cs[i];
                com.sun.javadoc.ClassDoc next = i == cs.length - 1 ? null : cs[i + 1];
                this.generateClasses(prev, curr, next, classtree, nopackage);
            }
            ++i;
        }
    }

    protected void generateClasses(com.sun.javadoc.ClassDoc prev, com.sun.javadoc.ClassDoc curr, com.sun.javadoc.ClassDoc next, ClassTree classtree, boolean nopackage) throws DocletAbortException {
        ClassWriter.generate(curr, prev, next, classtree, nopackage);
    }

    public static int optionLength(String option) {
        return AbstractStandard.configuration().optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) throws IOException {
        return AbstractStandard.configuration().validOptions(options, reporter);
    }

    public static abstract class Check
    extends Pass {
        protected abstract String message();

        protected abstract boolean cond();

        protected void gen() throws DocletAbortException {
            com.sun.tools.doclets.standard.ConfigurationStandard.standardmessage.error(this.message());
            throw new DocletAbortException();
        }

        public String title() {
            return null;
        }
    }

    public static abstract class Pass {
        protected RootDoc root;
        protected ConfigurationStandard cs;
        protected AbstractStandard std;

        public abstract String title();

        protected abstract void gen() throws DocletAbortException;

        public final void generate(AbstractStandard std, ConfigurationStandard cs, RootDoc root) throws DocletAbortException {
            this.std = std;
            this.cs = cs;
            this.root = root;
            if (this.cond()) {
                String title = this.title();
                long start = System.currentTimeMillis();
                if (cs.log && title != null) {
                    com.sun.tools.doclets.standard.ConfigurationStandard.standardmessage.notice("doclet.pass_msg", title);
                }
                this.gen();
                if (cs.log && title != null) {
                    long stop = System.currentTimeMillis();
                    com.sun.tools.doclets.standard.ConfigurationStandard.standardmessage.notice("doclet.done_msg", title, stop - start + "");
                }
            }
        }

        protected boolean cond() {
            return true;
        }
    }
}

