/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.PrimitiveType;
import org.aspectj.tools.ajdoc.ClassDocImpl;

public class TypeImpl {
    private static final Factory factory = new Factory();

    public static Type getInstance(org.aspectj.compiler.base.ast.Type type) {
        return TypeImpl.factory.getInstance(type);
    }

    public static Type getInstance(String spec, ClassDoc where) {
        return TypeImpl.factory.getInstance(spec, where);
    }

    private static final class Factory {
        private Factory() {
        }

        private Type getInstance(org.aspectj.compiler.base.ast.Type type) {
            if (type instanceof PrimitiveType) {
                return Primitive.getInstance((PrimitiveType)type);
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                org.aspectj.compiler.base.ast.Type component = arrayType.getComponentType();
                while (component instanceof ArrayType) {
                    component = ((ArrayType)component).getComponentType();
                }
                return new Array(this.getInstance(component), arrayType.getArrayDimCount());
            }
            return ClassDocImpl.getInstance(((NameType)type).getTypeDec());
        }

        private Type getInstance(String spec, ClassDoc where) {
            int dimension;
            String name;
            int ibracket = spec.indexOf(91);
            if (ibracket != -1) {
                name = spec.substring(0, ibracket);
                dimension = spec.substring(ibracket + 1).length() / 2;
            } else {
                name = spec;
                dimension = 0;
            }
            org.aspectj.ajdoc.Type type = Primitive.getInstance(name);
            if (type == null) {
                type = where.findClass(name);
            }
            if (dimension > 0) {
                type = new Array(type, dimension);
            }
            return type;
        }
    }

    private static final class Array
    implements org.aspectj.ajdoc.Type {
        protected final Type type;
        protected final int dimension;

        private Array(Type type, int dimension) {
            this.type = type;
            this.dimension = dimension;
        }

        public String toString() {
            return this.type.toString();
        }

        public String typeName() {
            return this.type.typeName();
        }

        public String qualifiedTypeName() {
            return this.type.qualifiedTypeName();
        }

        public ClassDoc asClassDoc() {
            return this.type.asClassDoc();
        }

        public String dimension() {
            String str = "";
            int i = 0;
            while (i < this.dimension) {
                str = str + "[]";
                ++i;
            }
            return str;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Array)) {
                return super.equals(other);
            }
            Array array = (Array)other;
            return array.type.equals(this.type) && array.dimension == this.dimension;
        }
    }

    private static final class Primitive
    implements org.aspectj.ajdoc.Type {
        private final String name;
        private static final Primitive voidType = new Primitive("void");
        private static final Primitive booleanType = new Primitive("boolean");
        private static final Primitive byteType = new Primitive("byte");
        private static final Primitive charType = new Primitive("char");
        private static final Primitive shortType = new Primitive("short");
        private static final Primitive intType = new Primitive("int");
        private static final Primitive longType = new Primitive("long");
        private static final Primitive floatType = new Primitive("float");
        private static final Primitive doubleType = new Primitive("double");

        public static final Primitive getInstance(PrimitiveType type) {
            return Primitive.getInstance(type.getName());
        }

        public static final Primitive getInstance(String name) {
            if ("void".equals(name)) {
                return voidType;
            }
            if ("boolean".equals(name)) {
                return booleanType;
            }
            if ("byte".equals(name)) {
                return byteType;
            }
            if ("char".equals(name)) {
                return charType;
            }
            if ("short".equals(name)) {
                return shortType;
            }
            if ("int".equals(name)) {
                return intType;
            }
            if ("long".equals(name)) {
                return longType;
            }
            if ("float".equals(name)) {
                return floatType;
            }
            if ("double".equals(name)) {
                return doubleType;
            }
            return null;
        }

        public static final boolean isPrimitive(String name) {
            return name.equals("boolean") || name.equals("byte") || name.equals("char") || name.equals("short") || name.equals("int") || name.equals("long") || name.equals("float") || name.equals("double");
        }

        private Primitive(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String typeName() {
            return this.name;
        }

        public String qualifiedTypeName() {
            return this.name;
        }

        public String dimension() {
            return "";
        }

        public ClassDoc asClassDoc() {
            return null;
        }
    }
}

