/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.Doc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.aspectj.tools.ajdoc.ErrPrinter;
import org.aspectj.tools.ajdoc.Util;

public class Comment {
    private String commentText;
    private String rawCommentText;
    private List tags;
    private Doc doc;
    private Locale loc;
    private ErrPrinter err;

    public Comment(Doc doc, String formalComment) {
        this(doc, formalComment, ErrPrinter.instance);
    }

    public Comment(Doc doc, String formalComment, ErrPrinter err) {
        this(doc, formalComment, err, Locale.US);
    }

    public Comment(Doc doc, String formalComment, ErrPrinter err, Locale loc) {
        this.rawCommentText = Util.rawCommentText(formalComment);
        this.commentText = Util.commentText(this.rawCommentText);
        this.doc = doc;
        this.err = err;
        this.loc = loc;
    }

    public String commentText() {
        return this.commentText;
    }

    public String getRawCommentText() {
        return this.rawCommentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String rawCommentText() {
        return this.rawCommentText;
    }

    public void setRawCommentText(String rawCommentText) {
        this.rawCommentText = rawCommentText;
    }

    public List getTags() {
        if (this.tags == null) {
            this.tags = this.findTags();
        }
        return this.tags;
    }

    public void setDoc(Doc doc) {
        this.doc = doc;
    }

    public Doc doc() {
        return this.doc;
    }

    public void setLocale(Locale loc) {
        this.loc = loc;
    }

    public Locale locale() {
        return this.loc;
    }

    public void setErr(ErrPrinter err) {
        this.err = err;
    }

    public ErrPrinter err() {
        return this.err;
    }

    public void init(Doc doc, Locale loc, ErrPrinter err) {
        this.setDoc(doc);
        this.setLocale(loc);
        this.setErr(err);
    }

    public Tag[] inlineTags() {
        return Util.inlineTags(this.doc(), this.commentText(), this.locale(), this.err());
    }

    public Tag[] tags(String type) {
        type = type.startsWith("@") ? type : "@" + type;
        ArrayList<Tag> result = new ArrayList<Tag>();
        Iterator i = this.getTags().iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!tag.kind().equals(type)) continue;
            result.add(tag);
        }
        return result.toArray(new Tag[result.size()]);
    }

    public ParamTag[] paramTags() {
        ArrayList<ParamTag> result = new ArrayList<ParamTag>();
        Iterator i = this.getTags().iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!(tag instanceof ParamTag)) continue;
            result.add((ParamTag)tag);
        }
        return result.toArray(new ParamTag[result.size()]);
    }

    public SeeTag[] seeTags() {
        ArrayList<SeeTag> result = new ArrayList<SeeTag>();
        Iterator i = this.getTags().iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!(tag instanceof SeeTag)) continue;
            result.add((SeeTag)tag);
        }
        return result.toArray(new SeeTag[result.size()]);
    }

    public SerialFieldTag[] serialFieldTags() {
        ArrayList<SerialFieldTag> result = new ArrayList<SerialFieldTag>();
        Iterator i = this.getTags().iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!(tag instanceof SerialFieldTag)) continue;
            result.add((SerialFieldTag)tag);
        }
        return result.toArray(new SerialFieldTag[result.size()]);
    }

    public ThrowsTag[] throwsTags() {
        ArrayList<ThrowsTag> result = new ArrayList<ThrowsTag>();
        Iterator i = this.getTags().iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            if (!(tag instanceof ThrowsTag)) continue;
            result.add((ThrowsTag)tag);
        }
        return result.toArray(new ThrowsTag[result.size()]);
    }

    public Tag[] tags() {
        return this.getTags().toArray(new Tag[this.getTags().size()]);
    }

    public Tag[] firstSentenceTags() {
        return Util.firstSentenceTags(this.doc(), this.commentText(), this.locale(), this.err());
    }

    private List findTags() {
        return Util.findTags(this.doc(), this.rawCommentText(), this.locale(), this.err());
    }
}

