/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.MethodDoc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdoc.AdviceDoc;
import org.aspectj.ajdoc.ClassDoc;
import org.aspectj.ajdoc.FieldDoc;
import org.aspectj.ajdoc.IntroducedSuperDoc;
import org.aspectj.ajdoc.PackageDoc;
import org.aspectj.ajdoc.PointcutDoc;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Import;
import org.aspectj.compiler.base.ast.Imports;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.TextSourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedSuperDec;
import org.aspectj.compiler.crosscuts.ast.PointcutSO;
import org.aspectj.tools.ajdoc.AccessChecker;
import org.aspectj.tools.ajdoc.AjdocCompiler;
import org.aspectj.tools.ajdoc.AspectDocImpl;
import org.aspectj.tools.ajdoc.CodeDocImpl;
import org.aspectj.tools.ajdoc.ConstructorDocImpl;
import org.aspectj.tools.ajdoc.FieldDocImpl;
import org.aspectj.tools.ajdoc.FilteredDecList;
import org.aspectj.tools.ajdoc.IntroducedSuperDocImpl;
import org.aspectj.tools.ajdoc.MemberDocImpl;
import org.aspectj.tools.ajdoc.PackageDocImpl;
import org.aspectj.tools.ajdoc.ProgramElementDocImpl;

public class ClassDocImpl
extends ProgramElementDocImpl
implements ClassDoc {
    private static final Factory factory = new Factory();
    private final TypeDec typeDec;
    private Collection introducers;
    private Collection fieldDocs;
    private Collection methodDocs;
    private Collection constructorDocs;
    private Collection innerclassDocs;
    private Collection interfaceDocs;
    private Collection importedClasses;
    private Collection importedPackages;
    private Collection pointcutDocs;
    private AccessChecker filter;

    public static final ClassDocImpl getInstance(TypeDec typeDec) {
        return factory.getInstance(typeDec);
    }

    public static final ClassDocImpl getInstance(ClassDoc outerDoc, TypeDec typeDec) {
        return factory.getInstance(outerDoc, typeDec);
    }

    public static final ClassDocImpl find(String qualifiedName) {
        return factory.find(qualifiedName);
    }

    protected ClassDocImpl(com.sun.javadoc.ClassDoc containingClass, TypeDec typeDec) {
        super(containingClass);
        this.typeDec = typeDec;
        this.setIncluded(false);
        ClassDocImpl.factory.put(this, typeDec);
        this.importedClasses = new ArrayList();
        this.importedPackages = new ArrayList();
        this.createImports(this.importedClasses, this.importedPackages);
    }

    public MemberDocImpl docForDec(Dec dec) {
        if (dec instanceof FieldDec) {
            return this.docForDec((FieldDec)dec);
        }
        if (dec instanceof CodeDec) {
            return this.docForDec((CodeDec)dec);
        }
        return null;
    }

    public FieldDocImpl docForDec(FieldDec dec) {
        com.sun.javadoc.FieldDoc[] fs = this.fields();
        int i = 0;
        while (i < fs.length) {
            FieldDocImpl fd = (FieldDocImpl)fs[i];
            if (fd.dec() == dec) {
                return fd;
            }
            ++i;
        }
        return null;
    }

    public CodeDocImpl docForDec(CodeDec dec) {
        MethodDoc[] ms = this.methods();
        int i = 0;
        while (i < ms.length) {
            CodeDocImpl cd = (CodeDocImpl)ms[i];
            if (cd.dec() == dec) {
                return cd;
            }
            ++i;
        }
        ConstructorDoc[] cs = this.constructors();
        int i2 = 0;
        while (i2 < cs.length) {
            CodeDocImpl cd = (CodeDocImpl)cs[i2];
            if (cd.dec() == dec) {
                return cd;
            }
            ++i2;
        }
        return null;
    }

    public TypeDec nonNullTypeDec() {
        if (this.typeDec().getLexicalType() == null) {
            return this.typeDec();
        }
        return super.nonNullTypeDec();
    }

    private Collection createInnerTypes() {
        Collection items = ((NameType)this.typeDec.getType()).getInnerTypes();
        FilteredDecList result = new FilteredDecList(this.getFilter(), this);
        if (items != null) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                result.add(((NameType)i.next()).getTypeDec());
            }
        }
        Collections.sort(result);
        return result;
    }

    private void createImports(Collection importClasses, Collection importPkgs) {
        Imports imports;
        CompilationUnit cu = this.typeDec.getCompilationUnit();
        if (cu != null && (imports = cu.getImports()) != null) {
            int i = 0;
            while (i < imports.size()) {
                Import imprt = imports.get(i);
                if (imprt != null) {
                    if (imprt.getStar()) {
                        PackageDocImpl importedPkg = PackageDocImpl.getPackageDoc(imprt.getName());
                        if (importedPkg != null) {
                            importPkgs.add(importedPkg);
                        }
                    } else {
                        com.sun.javadoc.ClassDoc importedClass = this.findClass(imprt.getName());
                        if (importedClass != null) {
                            importClasses.add(importedClass);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private Collection createInterfaces() {
        Collection items = this.typeDec.getSuperInterfaceTypes();
        FilteredDecList result = new FilteredDecList(this.getFilter(), this);
        if (items != null) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                result.add(((NameType)i.next()).getTypeDec());
            }
        }
        Collections.sort(result);
        return result;
    }

    void postProcess() {
        int parentColumn;
        SourceLocation parentLoc = this.dec().getSourceLocation();
        int parentLine = null == parentLoc ? -1 : parentLoc.getBeginLine();
        int n = parentColumn = null == parentLoc ? -1 : parentLoc.getBeginColumn();
        if (null == this.constructorDocs && null == this.constructors()) {
            return;
        }
        try {
            Iterator i = this.constructorDocs.iterator();
            while (i.hasNext()) {
                AdviceDoc[] advice;
                SourceLocation sl;
                ConstructorDocImpl cdi = (ConstructorDocImpl)i.next();
                CodeDec cd = cdi.codeDec();
                SourceLocation sourceLocation = sl = null == cd ? null : cd.getSourceLocation();
                if (null == sl || parentColumn != sl.getBeginColumn() || parentLine != sl.getBeginLine() || null == (advice = cdi.advice()) || 1 <= advice.length) continue;
                i.remove();
            }
        }
        catch (UnsupportedOperationException e) {
            System.err.println("Warning: ClassDocImpl.constructorDocs not removable");
        }
    }

    private Collection createConstructors() {
        NameType type = (NameType)this.typeDec.getType();
        Collection items = type.getConstructors();
        SourceLocation parentLoc = this.dec().getSourceLocation();
        int parentLine = null == parentLoc ? -1 : parentLoc.getBeginLine();
        int parentColumn = null == parentLoc ? -1 : parentLoc.getBeginColumn();
        FilteredDecList result = new FilteredDecList(this.getFilter(), this);
        if (items != null) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                SourceLocation sl;
                Constructor c = (Constructor)i.next();
                ConstructorDec cd = c.getConstructorDec();
                ConstructorDocImpl impl = new ConstructorDocImpl((com.sun.javadoc.ClassDoc)this, cd);
                SourceLocation sourceLocation = sl = null == cd ? null : cd.getSourceLocation();
                if (null != sl && parentColumn == sl.getBeginColumn() && parentLine == sl.getBeginLine()) {
                    TextSourceLocation tsl = new TextSourceLocation(sl.getCompilationUnit(), sl.getStartPosition(), sl.getEndPosition());
                    tsl.clearComment();
                    cd.setSourceLocation(tsl);
                }
                result.add(impl);
            }
        }
        Collections.sort(result);
        return result;
    }

    private Collection createPointcuts() {
        NameType type = (NameType)this.typeDec.getType();
        Collection items = type.getPointcuts();
        FilteredDecList result = new FilteredDecList(this.getFilter(), this);
        if (items != null) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                result.add(((PointcutSO)i.next()).getPointcutDec());
            }
        }
        Collections.sort(result);
        return result;
    }

    private Collection createMethods() {
        NameType type = (NameType)this.typeDec.getType();
        Collection methods = type.getMethods();
        FilteredDecList result = new FilteredDecList(this.getFilter(), this);
        if (methods != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                result.add(((Method)i.next()).getMethodDec());
            }
        }
        Collections.sort(result);
        return result;
    }

    private Collection createFields() {
        NameType type = (NameType)this.typeDec.getType();
        Collection fields = type.getFields();
        FilteredDecList result = new FilteredDecList(this.getFilter(), this);
        if (fields != null) {
            Iterator i = fields.iterator();
            while (i.hasNext()) {
                result.add(((Field)i.next()).getFieldDec());
            }
        }
        Collections.sort(result);
        return result;
    }

    protected AccessChecker getFilter() {
        AspectJCompiler ajc;
        if (null == this.filter && (ajc = this.ajc()) instanceof AjdocCompiler) {
            this.filter = ((AjdocCompiler)ajc).getFilter();
        }
        return this.filter;
    }

    protected final Dec dec() {
        return this.typeDec();
    }

    public final TypeDec typeDec() {
        return this.typeDec;
    }

    public String qualifiedName() {
        return this.qualifiedTypeName().replace('$', '.');
    }

    public String toString() {
        return this.qualifiedName();
    }

    public String name() {
        return ((NameType)this.typeDec().getType()).getExtendedId().replace('$', '.');
    }

    public com.sun.javadoc.ClassDoc findClass(String classname) {
        com.sun.javadoc.PackageDoc[] pkgs;
        if (classname == null || classname.length() < 1) {
            return null;
        }
        if (classname.equals(this.name()) || classname.equals(this.qualifiedName())) {
            return this;
        }
        ClassDocImpl desired = ClassDocImpl.find(classname);
        if (desired != null) {
            return desired;
        }
        String innername = this.name() + '.' + classname;
        com.sun.javadoc.ClassDoc[] inners = this.innerClasses();
        if (inners != null) {
            int i = 0;
            while (i < inners.length) {
                if (classname.equals(inners[i].name()) || innername.equals(inners[i].name())) {
                    return inners[i];
                }
                ++i;
            }
        }
        if ((desired = this.containingPackage().findClass(classname)) != null) {
            return desired;
        }
        com.sun.javadoc.ClassDoc[] imports = this.importedClasses();
        if (imports != null) {
            int i = 0;
            while (i < imports.length) {
                if (classname.equals(imports[i].name())) {
                    return imports[i];
                }
                ++i;
            }
        }
        if ((pkgs = this.importedPackages()) != null) {
            int i = 0;
            while (i < pkgs.length) {
                desired = pkgs[i].findClass(classname);
                if (desired != null) {
                    return desired;
                }
                ++i;
            }
        }
        String[] pkgnames = new String[]{"java.lang", "org.aspectj.lang"};
        int i = 0;
        while (i < pkgnames.length) {
            PackageDocImpl pkg = PackageDocImpl.getPackageDoc(pkgnames[i]);
            if (pkg != null && (desired = pkg.findClass(classname)) != null) {
                return desired;
            }
            ++i;
        }
        return null;
    }

    public com.sun.javadoc.FieldDoc[] fields() {
        if (this.fieldDocs == null) {
            this.fieldDocs = this.createFields();
        }
        return this.fieldDocs.toArray(new FieldDoc[this.fieldDocs.size()]);
    }

    public boolean isExternalizable() {
        return false;
    }

    public boolean isSerializable() {
        Iterator i = this.typeDec().getSuperInterfaceTypes().iterator();
        while (i.hasNext()) {
            if (!((Type)i.next()).getId().equals("java.io.Serializable")) continue;
            return true;
        }
        return false;
    }

    public MethodDoc[] methods() {
        if (this.methodDocs == null) {
            this.methodDocs = this.createMethods();
        }
        return this.methodDocs.toArray(new org.aspectj.ajdoc.MethodDoc[this.methodDocs.size()]);
    }

    public MethodDoc[] serializationMethods() {
        ArrayList<MethodDoc> ser = new ArrayList<MethodDoc>();
        MethodDoc[] mds = this.methods();
        int i = 0;
        int N = mds.length;
        while (i < N) {
            if (mds[i].tags("@serialized").length > 1) {
                ser.add(mds[i]);
            }
            ++i;
        }
        return ser.toArray(new MethodDoc[ser.size()]);
    }

    public com.sun.javadoc.FieldDoc[] serializableFields() {
        ArrayList<com.sun.javadoc.FieldDoc> ser = new ArrayList<com.sun.javadoc.FieldDoc>();
        com.sun.javadoc.FieldDoc[] fds = this.fields();
        int i = 0;
        int N = fds.length;
        while (i < N) {
            if (fds[i].serialFieldTags().length > 1) {
                ser.add(fds[i]);
            }
            ++i;
        }
        return ser.toArray(new com.sun.javadoc.FieldDoc[ser.size()]);
    }

    public boolean definesSerializableFields() {
        return this.serializableFields().length > 0;
    }

    public com.sun.javadoc.ClassDoc superclass() {
        if ("java.lang.Object".equals(this.qualifiedTypeName())) {
            return null;
        }
        TypeDec superType = this.typeDec().getSuperClassType().getTypeDec();
        return ClassDocImpl.getInstance(superType);
    }

    public boolean subclassOf(com.sun.javadoc.ClassDoc c) {
        return c != null && c.equals(this.superclass());
    }

    public com.sun.javadoc.ClassDoc[] interfaces() {
        if (this.interfaceDocs == null) {
            this.interfaceDocs = this.createInterfaces();
        }
        return this.interfaceDocs.toArray(new ClassDoc[this.interfaceDocs.size()]);
    }

    public ConstructorDoc[] constructors() {
        if (this.constructorDocs == null) {
            this.constructorDocs = this.createConstructors();
        }
        return this.constructorDocs.toArray(new org.aspectj.ajdoc.ConstructorDoc[this.constructorDocs.size()]);
    }

    public com.sun.javadoc.ClassDoc[] innerClasses() {
        if (this.innerclassDocs == null) {
            this.innerclassDocs = this.createInnerTypes();
        }
        int size = this.innerclassDocs.size();
        return this.innerclassDocs.toArray(new ClassDoc[size]);
    }

    public com.sun.javadoc.ClassDoc[] importedClasses() {
        return this.importedClasses.toArray(new ClassDoc[this.importedClasses.size()]);
    }

    public com.sun.javadoc.PackageDoc[] importedPackages() {
        return this.importedPackages.toArray(new PackageDoc[this.importedPackages.size()]);
    }

    public PointcutDoc[] pointcuts() {
        if (this.pointcutDocs == null) {
            this.pointcutDocs = this.createPointcuts();
        }
        return this.pointcutDocs.toArray(new PointcutDoc[this.pointcutDocs.size()]);
    }

    public boolean isAbstract() {
        return this.typeDec().isAbstract();
    }

    public boolean isException() {
        com.sun.javadoc.ClassDoc superclass = this.superclass();
        while (superclass != null && !superclass.qualifiedTypeName().equals("java.lang.Object")) {
            if (superclass.qualifiedTypeName().equals("java.lang.Exception")) {
                return true;
            }
            superclass = superclass.superclass();
        }
        return false;
    }

    public boolean isError() {
        com.sun.javadoc.ClassDoc superclass = this.superclass();
        while (superclass != null && !superclass.qualifiedTypeName().equals("java.lang.Object")) {
            if (superclass.qualifiedTypeName().equals("java.lang.Error")) {
                return true;
            }
            superclass = superclass.superclass();
        }
        return false;
    }

    public IntroducedSuperDoc[] introducers() {
        if (this.introducers == null) {
            this.introducers = this.createIntroducers();
        }
        return this.introducers.toArray(new IntroducedSuperDoc[this.introducers.size()]);
    }

    public boolean isInterface() {
        return this.typeDec() instanceof InterfaceDec;
    }

    public boolean isClass() {
        return this.typeDec() instanceof ClassDec;
    }

    public boolean isAspect() {
        return this.typeDec() instanceof AspectDec;
    }

    public boolean isOrdinaryClass() {
        return this.isClass() && !this.isError() && !this.isException();
    }

    public int modifierSpecifier() {
        return super.modifierSpecifier() | (this.isInterface() ? 512 : 0);
    }

    public com.sun.javadoc.ClassDoc asClassDoc() {
        return this.isIncluded() ? this : null;
    }

    public String dimension() {
        return "";
    }

    public String qualifiedTypeName() {
        return this.typeDec().getFullName().replace('$', '.');
    }

    public String typeName() {
        return this.typeDec().getId().replace('$', '.');
    }

    private Collection createIntroducers() {
        Set affectedBy = this.ajc().getCorrespondences().getAffectedBy(this.typeDec);
        if (affectedBy.size() < 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IntroducedSuperDocImpl> list = new ArrayList<IntroducedSuperDocImpl>();
        Iterator i = affectedBy.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof IntroducedSuperDec)) continue;
            IntroducedSuperDec dec = (IntroducedSuperDec)o;
            TypeDec owner = ((NameType)dec.getDeclaringType()).getTypeDec();
            AspectDocImpl ad = (AspectDocImpl)ClassDocImpl.getInstance(owner);
            IntroducedSuperDocImpl id = ad.introDocForDec(dec);
            list.add(id);
            id.addTarget(this);
        }
        return list;
    }

    private static final class Factory {
        private final Map typeDecsToClassDocs = new HashMap();
        private final Map qualifiedNamesToClassDocs = new HashMap();

        private Factory() {
        }

        public final ClassDocImpl find(String qualifiedName) {
            return (ClassDocImpl)this.qualifiedNamesToClassDocs.get(qualifiedName);
        }

        public final ClassDocImpl getInstance(TypeDec typeDec) {
            if (typeDec == null) {
                return null;
            }
            ClassDocImpl outerDoc = this.getInstance(typeDec.getEnclosingTypeDec());
            return this.getInstance(outerDoc, typeDec);
        }

        public final ClassDocImpl getInstance(ClassDoc outerDoc, TypeDec typeDec) {
            if (typeDec == null) {
                return null;
            }
            ClassDocImpl cd = (ClassDocImpl)this.typeDecsToClassDocs.get(typeDec);
            if (cd == null) {
                cd = this.makeInstance(outerDoc, typeDec);
            }
            return cd;
        }

        private final ClassDocImpl makeInstance(ClassDoc outerDoc, TypeDec typeDec) {
            ClassDocImpl result = null;
            result = typeDec instanceof AspectDec ? new AspectDocImpl((com.sun.javadoc.ClassDoc)outerDoc, (AspectDec)typeDec) : new ClassDocImpl(outerDoc, typeDec);
            if (null == result.containingPackage()) {
                System.err.println("Warning: unable to add " + result + " to package");
            }
            return result;
        }

        private final Object put(ClassDocImpl classdoc, TypeDec typeDec) {
            ClassDocImpl result = this.typeDecsToClassDocs.put(typeDec, classdoc);
            if (null == result) {
                result = this.qualifiedNamesToClassDocs.put(classdoc.qualifiedName(), classdoc);
            }
            return result;
        }
    }
}

